/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.collection.IntervalIterator;
import de.intarsys.tools.number.NumberWrapper;
import java.util.Collection;
import java.util.Iterator;

public class NumberInterval
extends NumberWrapper {
    public static char SEPARATOR = (char)45;
    private Number from;
    private Number to;
    private double step = 1.0;

    public void setFrom(Number newFrom) {
        this.from = newFrom;
    }

    public Number getFrom() {
        return this.from;
    }

    public void setTo(Number newTo) {
        this.to = newTo;
    }

    public Number getTo() {
        return this.to;
    }

    public Iterator iterator() {
        return new IntervalIterator(this.from, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFrom());
        sb.append(SEPARATOR);
        sb.append(this.getTo());
        return sb.toString();
    }

    public int size() {
        return (int)Math.round((this.to.doubleValue() - this.from.doubleValue()) / this.step) + 1;
    }

    public boolean isEmpty() {
        if (this.to == null || this.from == null) {
            return true;
        }
        return this.from.intValue() > this.to.intValue();
    }

    public boolean contains(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.doubleValue() >= this.from.doubleValue() && n.doubleValue() <= this.to.doubleValue();
        }
        if (o instanceof NumberWrapper) {
            NumberWrapper wrapper = (NumberWrapper)o;
            return wrapper.getMin() >= this.getMin() && wrapper.getMax() <= this.getMax();
        }
        return false;
    }

    public Object[] toArray() {
        Object[] numbers = new Number[this.size()];
        int i = 0;
        while (i < numbers.length) {
            numbers[i] = new Double(this.from.doubleValue() + (double)i * this.step);
            ++i;
        }
        return numbers;
    }

    public boolean add(Object arg0) {
        if (arg0 instanceof Number) {
            Number n = (Number)arg0;
            if (n.doubleValue() < this.from.doubleValue()) {
                this.from = new Double(n.doubleValue());
            } else if (n.doubleValue() > this.to.doubleValue()) {
                this.to = new Double(n.doubleValue());
            }
            return true;
        }
        if (arg0 instanceof NumberWrapper) {
            NumberWrapper wrapper = (NumberWrapper)arg0;
            if (wrapper.getMin() < this.getMin()) {
                this.from = new Double(wrapper.getMin());
            }
            if (wrapper.getMax() > this.getMax()) {
                this.to = new Double(wrapper.getMax());
            }
        }
        throw new IllegalArgumentException("Only objects of type Number or NumberWrapper are supported.");
    }

    public boolean addAll(Collection arg0) {
        for (Object element : arg0) {
            if (this.add(element)) continue;
            return false;
        }
        return true;
    }

    protected double getMin() {
        return this.from.doubleValue();
    }

    protected double getMax() {
        return this.to.doubleValue();
    }

    public void increment(int i) {
        this.from = new Integer(this.getFrom().intValue() + i);
        this.to = new Integer(this.getTo().intValue() + i);
    }
}

