/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.Declaration;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;

public abstract class DeclarationElement
extends Declaration
implements IDeclarationElement,
IDeclarationBlock {
    private final String modifiers;
    private final String name;
    private final IDeclaration[] nestedDeclarations;

    public DeclarationElement(Object declarationContext, String name, String modifiers) {
        super(declarationContext);
        this.modifiers = modifiers;
        this.name = name;
        this.nestedDeclarations = null;
    }

    public DeclarationElement(Object declarationContext, String name, String modifiers, IDeclaration[] nestedDeclarations) {
        super(declarationContext);
        this.modifiers = modifiers;
        this.name = name;
        this.nestedDeclarations = nestedDeclarations;
    }

    public IDeclaration[] getDeclarations() {
        return this.nestedDeclarations;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasModifier(String modifier) {
        if (this.modifiers == null) {
            return false;
        }
        return this.modifiers.indexOf(modifier) >= 0;
    }

    public boolean isBlock() {
        return this.size() > 0;
    }

    public int size() {
        return this.nestedDeclarations == null ? 0 : this.nestedDeclarations.length;
    }

    public String toString() {
        return "declaration <'" + this.getName() + "'> [" + this.modifiers + "]";
    }
}

