/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.main.FeedBack;
import freemind.main.FreeMindMain;
import freemind.main.IFreeMindSplash;
import freemind.main.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class FreeMindSplash
extends JFrame
implements IFreeMindSplash {
    private static final int SPLASH_FONT_SIZE = 16;
    private final FreeMindMain frame;
    private final FeedBackImpl feedBack;
    private JProgressBar mProgressBar;
    private static Logger logger;
    private ImageIcon mIcon;

    @Override
    public FeedBack getFeedBack() {
        return this.feedBack;
    }

    public FreeMindSplash(final FreeMindMain frame) {
        super("FreeMind");
        this.frame = frame;
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
        this.feedBack = new FeedBackImpl();
        this.mIcon = new ImageIcon(frame.getResource("images/FreeMindWindowIcon.png"));
        this.setIconImage(this.mIcon.getImage());
        FreeMindSplash.setDefaultLookAndFeelDecorated(false);
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        ImageIcon splashImage = new ImageIcon(frame.getResource("images/splash.JPG"));
        JLabel splashImageLabel = new JLabel((Icon)splashImage){
            private Integer mWidth;
            private final Font progressFont;
            private Font versionTextFont;
            {
                super(x0);
                this.mWidth = null;
                this.progressFont = new Font("SansSerif", 0, 10);
                this.versionTextFont = null;
                Set availableFontFamilyNames = Tools.getAvailableFontFamilyNames();
                this.versionTextFont = availableFontFamilyNames.contains("Century Gothic") ? new Font("Century Gothic", 1, 14) : new Font("Arial", 1, 12);
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setFont(this.versionTextFont);
                String freemindVersion = frame.getFreemindVersion().toString();
                if (this.mWidth == null) {
                    this.mWidth = new Integer(g2.getFontMetrics().stringWidth(freemindVersion));
                }
                int yCoordinate = (int)this.getSize().getHeight() - 14;
                int xCoordinate = (int)(this.getSize().getWidth() - (double)this.mWidth.intValue()) - 45;
                g2.setColor(new Color(77, 99, 180));
                g2.drawString(freemindVersion, xCoordinate, yCoordinate);
                String progressString = (String)this.getClientProperty("progressString");
                if (progressString != null) {
                    Double percent = (Double)this.getClientProperty("progressPercent");
                    int xBase = 21;
                    int yBase = yCoordinate + 7;
                    int width = (int)this.getSize().getWidth() - 2 * xBase;
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                    g2.setFont(this.progressFont);
                    g2.setColor(new Color(128, 128, 128));
                    g2.drawString(progressString, xBase + 1, yBase - 4);
                    g2.setColor(new Color(240, 240, 240));
                    g2.draw(new Rectangle(xBase + 2, yBase, width, 3));
                    g2.setColor(new Color(208, 208, 208));
                    g2.draw(new Rectangle(xBase + 1, yBase + 1, width, 2));
                    g2.setColor(new Color(244, 244, 244));
                    g2.fill(new Rectangle(xBase + 1, yBase + 1, width - 1, 2));
                    g2.setColor(new Color(77, 99, 180));
                    g2.fill(new Rectangle(xBase + 1, yBase + 1, (int)((double)width * percent), 2));
                }
            }
        };
        this.feedBack.setImageJLabel(splashImageLabel);
        this.getContentPane().add((Component)splashImageLabel, "Center");
        this.mProgressBar = new JProgressBar();
        this.mProgressBar.setIndeterminate(true);
        this.mProgressBar.setStringPainted(true);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = splashImageLabel.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
    }

    @Override
    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public ImageIcon getWindowIcon() {
        return this.mIcon;
    }

    private class FeedBackImpl
    implements FeedBack {
        private int mActualValue;
        private long mActualTimeStamp = System.currentTimeMillis();
        private long mTotalTime = 0L;
        private String lastTaskId = null;
        private JLabel mImageJLabel = null;

        private FeedBackImpl() {
        }

        @Override
        public void progress(final int act, String messageId) {
            final String progressString = FreeMindSplash.this.frame.getResourceString(messageId);
            logger.info(progressString);
            this.mActualValue = act;
            long timeDifference = System.currentTimeMillis() - this.mActualTimeStamp;
            this.mActualTimeStamp = System.currentTimeMillis();
            this.mTotalTime += timeDifference;
            logger.info("Task: " + this.lastTaskId + " (" + act + ") last " + (double)timeDifference / 1000.0 + " seconds.\nTotal: " + (double)this.mTotalTime / 1000.0 + "\n");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FreeMindSplash.this.mProgressBar.setValue(act);
                    double percent = (double)act * 1.0 / (double)FreeMindSplash.this.mProgressBar.getMaximum();
                    FreeMindSplash.this.mProgressBar.setString(progressString);
                    if (FeedBackImpl.this.mImageJLabel != null) {
                        FeedBackImpl.this.mImageJLabel.putClientProperty("progressString", progressString);
                        FeedBackImpl.this.mImageJLabel.putClientProperty("progressPercent", new Double(percent));
                        FeedBackImpl.this.mImageJLabel.repaint();
                    }
                }
            });
            logger.info("Beginnig task:" + messageId);
            this.lastTaskId = messageId;
        }

        @Override
        public int getActualValue() {
            return this.mActualValue;
        }

        @Override
        public void setMaximumValue(int max) {
            FreeMindSplash.this.mProgressBar.setMaximum(max);
            FreeMindSplash.this.mProgressBar.setIndeterminate(false);
        }

        @Override
        public void increase(String messageId) {
            this.progress(this.getActualValue() + 1, messageId);
        }

        public void setImageJLabel(JLabel imageJLabel) {
            this.mImageJLabel = imageJLabel;
        }
    }
}

