/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsContext;
import de.intarsys.cwt.swt.image.ISwtImage;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.Printer;

public class CwtSwtImage
implements ISwtImage {
    public static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());
    private int height;
    private Image swtImage;
    private ImageData swtImageData;
    private int width;

    public CwtSwtImage(ImageData imageData) {
        this.swtImageData = imageData;
        this.setWidth(imageData.width);
        this.setHeight(imageData.height);
    }

    protected Image createSwtImage(Device device) {
        return new Image(device, this.getImageData());
    }

    public void drawFromGraphicsContext(IGraphicsContext graphicsContext, float x, float y) {
        GC gc = ((CwtSwtGraphicsContext)graphicsContext).getGc();
        ImageData imageData = this.getImageData();
        Transform transform = null;
        if (imageData.data.length > 0xFFFFFF) {
            transform = new Transform(gc.getDevice());
            gc.getTransform(transform);
            float[] elements = new float[6];
            transform.getElements(elements);
            double tx = elements[0];
            double ty = elements[3];
            double sx = elements[1];
            double sy = elements[2];
            double scaleX = Math.pow(tx * tx + sy * sy, 0.5);
            double scaleY = Math.pow(ty * ty + sx * sx, 0.5);
            imageData = imageData.scaledTo((int)Math.round((double)imageData.width * scaleX), (int)Math.round((double)imageData.height * scaleY));
            Transform tempTransform = new Transform(gc.getDevice(), elements);
            tempTransform.scale((float)(1.0 / scaleX), (float)(1.0 / scaleY));
            gc.setTransform(tempTransform);
            tempTransform.dispose();
        }
        try {
            byte[] bytes = null;
            if (IS_GTK && gc.getDevice() instanceof Printer && imageData.transparentPixel == -1 && imageData.alphaData == null && imageData.maskData == null) {
                bytes = new byte[imageData.width * imageData.height];
                Arrays.fill(bytes, (byte)-1);
                imageData.alphaData = bytes;
            }
            try {
                Image deviceImage = new Image(gc.getDevice(), imageData);
                try {
                    gc.drawImage(deviceImage, (int)x, (int)y);
                }
                finally {
                    deviceImage.dispose();
                }
            }
            finally {
                if (bytes != null) {
                    imageData.alphaData = null;
                }
            }
        }
        finally {
            if (transform != null) {
                gc.setTransform(transform);
                transform.dispose();
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage(Device device) {
        if (this.swtImage == null) {
            this.swtImage = this.createSwtImage(device);
        }
        return this.swtImage;
    }

    public ImageData getImageData() {
        return this.swtImageData;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setHeight(int paramHeight) {
        this.height = paramHeight;
    }

    protected void setWidth(int paramWidth) {
        this.width = paramWidth;
    }
}

