/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.randomaccess.RandomAccessViewport;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;

public class TTTable {
    private byte[] bytes;
    private int checksum = 0;
    private TTFont font;
    private long length;
    private byte[] name;
    private long offset;

    protected TTTable(TTFont font, long offset, long length) {
        this.font = font;
        this.offset = offset;
        this.length = length;
    }

    protected int createChecksum() throws IOException {
        IRandomAccess random = this.getRandomAccess();
        try {
            random.seek(0L);
            long len = (random.getLength() + 3L) / 4L;
            int sum = 0;
            int i = 0;
            while ((long)i < len) {
                int v = random.read();
                v = (v << 8) + random.read();
                v = (v << 8) + random.read();
                v = (v << 8) + random.read();
                sum += v;
                ++i;
            }
            int n = sum;
            return n;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public int getChecksum() {
        if (this.checksum == 0) {
            try {
                this.checksum = this.createChecksum();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.checksum;
    }

    public TTFont getFont() {
        return this.font;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getName() {
        return this.name;
    }

    public long getOffset() {
        return this.offset;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        if (this.bytes != null) {
            return new RandomAccessByteArray(this.bytes);
        }
        IRandomAccess random = this.getFont().getLocator().getRandomAccess();
        RandomAccessViewport viewport = new RandomAccessViewport(random, this.getOffset(), this.getLength());
        return viewport;
    }

    protected void setBytes(byte[] pBytes) {
        this.bytes = pBytes;
        this.checksum = 0;
        this.length = pBytes.length;
        this.offset = 0L;
    }

    protected void setChecksum(int i) {
        this.checksum = i;
    }

    public void setName(byte[] string) {
        this.name = string;
    }

    public String toString() {
        return new String(this.getName());
    }
}

