/*
 * Decompiled with CFR 0.152.
 */
package bibtex.parser;

import bibtex.parser.LookAheadReader;
import bibtex.parser.ParseException;
import java.io.IOException;
import java.io.Reader;

final class PseudoLexer {
    private final LookAheadReader input;
    private Token eofToken = null;
    private static final char[] QUOTE_OR_LBRACE = new char[]{'\"', '{'};
    private final char[] RBRACE_LBRACE = new char[]{'}', '{'};

    PseudoLexer(Reader input) throws IOException {
        this.input = new LookAheadReader(input);
    }

    Token getNextToken() {
        return null;
    }

    public Token scanTopLevelCommentOrAtOrEOF() throws IOException {
        this.skipWhitespace();
        if (this.eofToken != null) {
            return new Token(2, this.eofToken.content, this.eofToken.line, this.eofToken.column);
        }
        int column = this.input.getColumn();
        int line = this.input.getLine();
        if (this.input.getCurrent() == '@') {
            this.input.step();
            return new Token(1, "@", line, column);
        }
        StringBuffer content = new StringBuffer();
        while (!this.input.eof() && this.input.getCurrent() != '@') {
            content.append(this.input.getCurrent());
            this.input.step();
        }
        return new Token(0, content.toString(), line, column);
    }

    public final int scanAlternatives(char[] alternatives, boolean lookAhead) throws IOException, ParseException {
        this.skipWhitespace();
        if (this.eofToken != null) {
            throw new ParseException(this.eofToken.line, this.eofToken.column, "[EOF]", PseudoLexer.alternativesToString(alternatives));
        }
        int line = this.input.getLine();
        int column = this.input.getColumn();
        int i = 0;
        while (i < alternatives.length) {
            if (alternatives[i] == this.input.getCurrent()) {
                if (!lookAhead) {
                    this.input.step();
                }
                return i;
            }
            ++i;
        }
        if (!lookAhead) {
            this.input.step();
        }
        throw new ParseException(line, column, "" + this.input.getCurrent(), PseudoLexer.alternativesToString(alternatives));
    }

    public String scanLiteral(char[] terminationSet, boolean excludeWhitespace, boolean enforceNonzero) throws ParseException, IOException {
        StringBuffer buffer = new StringBuffer();
        this.scanLiteral(terminationSet, excludeWhitespace, enforceNonzero, buffer);
        return buffer.toString();
    }

    public int scanLiteral(char[] terminationSet, boolean excludeWhitespace, boolean enforceNonzero, StringBuffer resultTargetBuffer) throws ParseException, IOException {
        char inputChar;
        if (excludeWhitespace) {
            this.skipWhitespace();
            if (this.eofToken != null) {
                throw new ParseException(this.eofToken.line, this.eofToken.column, "[EOF]", "not (" + PseudoLexer.alternativesToString(terminationSet) + " or [whitespace])");
            }
        } else {
            this.enforceNoEof("not (" + PseudoLexer.alternativesToString(terminationSet) + ")", false);
        }
        int line = this.input.getLine();
        int column = this.input.getColumn();
        int indexIntoTerminationSet = -1;
        int initialResultTargetBufferLength = resultTargetBuffer.length();
        while (!(this.input.eof() || (indexIntoTerminationSet = PseudoLexer.index(terminationSet, inputChar = this.input.getCurrent())) >= 0 || excludeWhitespace && Character.isWhitespace(inputChar))) {
            this.input.step();
            resultTargetBuffer.append(inputChar);
        }
        if (resultTargetBuffer.length() > initialResultTargetBufferLength || !enforceNonzero) {
            return indexIntoTerminationSet;
        }
        throw new ParseException(line, column, "" + this.input.getCurrent(), "not (" + PseudoLexer.alternativesToString(terminationSet) + " or [whitespace])");
    }

    public String scanQuotedString() throws IOException, ParseException {
        int choice;
        StringBuffer content = new StringBuffer();
        this.scan('\"');
        while ((choice = this.scanLiteral(QUOTE_OR_LBRACE, false, false, content)) != 0) {
            this.scanBracketedString(content, true);
        }
        this.scan('\"');
        return content.toString();
    }

    public void scanBracketedString(StringBuffer targetBuffer, boolean includeOuterBraces) throws ParseException, IOException {
        int choice;
        this.scan('{');
        if (includeOuterBraces) {
            targetBuffer.append('{');
        }
        while ((choice = this.scanLiteral(this.RBRACE_LBRACE, false, false, targetBuffer)) != 0) {
            this.scanBracketedString(targetBuffer, true);
        }
        this.scan('}');
        if (includeOuterBraces) {
            targetBuffer.append("}");
        }
    }

    public String scanEntryTypeName() throws ParseException, IOException {
        this.skipWhitespace();
        if (this.eofToken != null) {
            throw new ParseException(this.eofToken.line, this.eofToken.column, "[EOF]", "[a..z,A..Z]");
        }
        int line = this.input.getLine();
        int column = this.input.getColumn();
        StringBuffer result = new StringBuffer();
        while (true) {
            this.enforceNoEof("[a..z,A..Z]", false);
            char inputChar = this.input.getCurrent();
            if ((inputChar < 'a' || inputChar > 'z') && (inputChar < 'A' || inputChar > 'Z')) break;
            result.append(inputChar);
            this.input.step();
        }
        if (result.length() == 0) {
            throw new ParseException(line, column, "" + this.input.getCurrent(), "[a..z,A..Z]");
        }
        return result.toString();
    }

    public void scan(char expected) throws ParseException, IOException {
        this.skipWhitespace();
        if (this.eofToken != null) {
            throw new ParseException(this.eofToken.line, this.eofToken.column, "[EOF]", "" + expected);
        }
        char encountered = this.input.getCurrent();
        if (encountered != expected) {
            int line = this.input.getLine();
            int column = this.input.getColumn();
            this.input.step();
            throw new ParseException(line, column, "" + encountered, "" + expected);
        }
        this.input.step();
    }

    /*
     * Unable to fully structure code
     */
    public void skipWhitespace() throws IOException {
        if (this.eofToken == null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.input.step();
lbl4:
            // 2 sources

            ** while (!this.input.eof() && Character.isWhitespace((char)this.input.getCurrent()))
        }
lbl5:
        // 1 sources

        if (this.input.eof()) {
            this.eofToken = new Token(-1, null, this.input.getLine(), this.input.getColumn());
        }
    }

    public void enforceNoEof(String expected, boolean skipWhiteSpace) throws ParseException, IOException {
        if (skipWhiteSpace) {
            this.skipWhitespace();
        } else if (this.input.eof()) {
            this.eofToken = new Token(-1, null, this.input.getLine(), this.input.getColumn());
        }
        if (this.eofToken != null) {
            throw new ParseException(this.eofToken.line, this.eofToken.column, "[EOF]", expected);
        }
    }

    public char currentInputChar() {
        return this.input.getCurrent();
    }

    private static String alternativesToString(char[] alternatives) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("one of ");
        int i = 0;
        while (i < alternatives.length) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append('\'');
            buffer.append(alternatives[i]);
            buffer.append('\'');
            ++i;
        }
        return buffer.toString();
    }

    private static String alternativesToString(Object[] alternatives) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("one of ");
        int i = 0;
        while (i < alternatives.length) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append('\'');
            buffer.append(alternatives[i]);
            buffer.append('\'');
            ++i;
        }
        return buffer.toString();
    }

    private static int index(char[] container, char element) {
        int i = 0;
        while (i < container.length) {
            if (container[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static final class Token {
        final int choice;
        final String content;
        final int line;
        final int column;

        Token(int choice, String content, int line, int column) {
            this.choice = choice;
            this.content = content;
            this.line = line;
            this.column = column;
        }
    }
}

