/*
 * Decompiled with CFR 0.152.
 */
package bibtex.expansions;

import bibtex.expansions.ExpansionException;
import java.util.LinkedList;

public abstract class AbstractExpander {
    private final boolean throwAllExpansionExceptions;
    private final LinkedList exceptions;
    private ExpansionException[] exceptionsAsArrays;

    protected AbstractExpander(boolean throwAllExpansionExceptions) {
        this.throwAllExpansionExceptions = throwAllExpansionExceptions;
        this.exceptions = throwAllExpansionExceptions ? null : new LinkedList();
    }

    public ExpansionException[] getExceptions() {
        return this.exceptionsAsArrays;
    }

    protected void finishExpansion() {
        if (this.exceptions == null) {
            return;
        }
        this.exceptionsAsArrays = new ExpansionException[this.exceptions.size()];
        this.exceptions.toArray(this.exceptionsAsArrays);
        this.exceptions.clear();
    }

    protected void throwExpansionException(String message) throws ExpansionException {
        if (this.throwAllExpansionExceptions) {
            throw new ExpansionException(message);
        }
        try {
            throw new ExpansionException(message);
        }
        catch (ExpansionException e) {
            this.exceptions.add(e);
            return;
        }
    }

    protected void throwExpansionException(Exception cause) throws ExpansionException {
        if (this.throwAllExpansionExceptions) {
            throw new ExpansionException(cause);
        }
        try {
            throw new ExpansionException(cause);
        }
        catch (ExpansionException e) {
            this.exceptions.add(e);
            return;
        }
    }
}

