/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STStreamXRefSection;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;

public class XRefStreamParser
extends AbstractXRefParser {
    private int[] wSizeDefault = new int[]{1, 2, 1};
    private int[] wSize;
    private ByteArrayInputStream in;

    public XRefStreamParser(STDocument doc, COSDocumentParser parser) {
        super(doc, parser);
    }

    private void initWBytes(STStreamXRefSection xRef) {
        COSArray w = xRef.getW();
        if (w == null) {
            this.wSize = this.wSizeDefault;
            return;
        }
        this.wSize = new int[3];
        int i = 0;
        while (i < w.size()) {
            this.wSize[i] = ((COSInteger)w.get(i)).intValue();
            ++i;
        }
        i = w.size();
        while (i < 3) {
            this.wSize[i] = 0;
            ++i;
        }
    }

    protected void loadPrevious(IRandomAccess randomAccess, STXRefSection xRefSection) throws IOException, COSLoadException {
        int offset = xRefSection.getPreviousOffset();
        if (offset != -1) {
            XRefStreamParser parser = new XRefStreamParser(this.getDoc(), this.getParser());
            randomAccess.seek((long)offset);
            STXRefSection xrefStream = ((AbstractXRefParser)parser).parse(randomAccess);
            xRefSection.setPrevious(xrefStream);
        }
    }

    public STXRefSection parse(IRandomAccess randomAcces) throws IOException, COSLoadException {
        STXRefSection xRefSection = this.parseXRef(randomAcces);
        this.loadPrevious(randomAcces, xRefSection);
        return xRefSection;
    }

    private void parseStreamContent(STStreamXRefSection section) throws IOException {
        this.initWBytes(section);
        this.in = new ByteArrayInputStream(section.cosGetStream().getDecodedBytes());
        COSArray index = section.getIndex();
        Iterator i = index.iterator();
        while (i.hasNext()) {
            COSNumber cosStart = ((COSObject)i.next()).asNumber();
            if (!i.hasNext()) continue;
            COSNumber cosCount = ((COSObject)i.next()).asNumber();
            if (cosStart == null || cosCount == null) continue;
            int start = cosStart.intValue();
            int count = cosCount.intValue();
            int io = 0;
            while (io < count) {
                int type = this.readType(this.in);
                switch (type) {
                    case 0: {
                        section.addEntry(this.parseType0(this.in, start + io));
                        break;
                    }
                    case 1: {
                        section.addEntry(this.parseType1(this.in, start + io));
                        break;
                    }
                    case 2: {
                        section.addEntry(this.parseType2(this.in, start + io));
                        break;
                    }
                    default: {
                        this.parseTypeUnknown(this.in);
                    }
                }
                ++io;
            }
        }
    }

    private STXRefEntry parseType0(ByteArrayInputStream pIn, int objectNumber) {
        int nextFree = this.read(pIn, this.wSize[1], -1);
        int nextGenNum = this.read(pIn, this.wSize[2], -1);
        return new STXRefEntryFree(objectNumber, nextGenNum, nextFree);
    }

    private STXRefEntry parseType1(ByteArrayInputStream pIn, int objectNumber) {
        int offset = this.read(pIn, this.wSize[1], -1);
        int genNum = this.read(pIn, this.wSize[2], 0);
        return new STXRefEntryOccupied(objectNumber, genNum, offset);
    }

    private STXRefEntry parseType2(ByteArrayInputStream pIn, int objectNumber) {
        int streamObjectNumber = this.read(pIn, this.wSize[1], -1);
        int indexOfObject = this.read(pIn, this.wSize[2], 0);
        return new STXRefEntryCompressed(objectNumber, 0, streamObjectNumber, 0, indexOfObject);
    }

    private void parseTypeUnknown(ByteArrayInputStream pIn) {
        this.read(pIn, this.wSize[1], -1);
        this.read(pIn, this.wSize[1], -1);
    }

    protected STXRefSection parseXRef(IRandomAccess randomAcces) throws IOException, COSLoadException {
        long offset = randomAcces.getOffset();
        COSStream stream = (COSStream)this.getDoc().getParser().parseIndirectObject(randomAcces, null);
        ((COSIndirectObject)stream.containable()).setDirty(false);
        STStreamXRefSection xRefSection = new STStreamXRefSection(this.getDoc(), offset, stream);
        this.parseStreamContent(xRefSection);
        return xRefSection;
    }

    private int read(ByteArrayInputStream pIn, int numBytes, int defaultValue) {
        if (numBytes == 0) {
            return defaultValue;
        }
        int result = 0;
        int i = 0;
        while (i < numBytes) {
            result <<= 8;
            result += pIn.read();
            ++i;
        }
        return result;
    }

    private int readType(ByteArrayInputStream pIn) {
        return this.read(pIn, this.wSize[0], 1);
    }
}

