/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STStreamXRefSection;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.XRefTrailerWriter;
import de.intarsys.pdf.writer.COSWriter;
import java.io.IOException;

public class STTrailerXRefSection
extends STXRefSection {
    private COSDictionary trailerDict;
    private STStreamXRefSection xRefStream;

    public STTrailerXRefSection(STDocument doc) {
        super(doc);
        this.trailerDict = COSDictionary.create();
    }

    public STTrailerXRefSection(STDocument doc, long offset) {
        super(doc, offset);
    }

    public COSDictionary cosGetDict() {
        return this.trailerDict;
    }

    public COSObject cosGetObject() {
        return this.trailerDict;
    }

    public void cosSetDict(COSDictionary pTrailerDict) {
        this.trailerDict = pTrailerDict;
    }

    public STXRefSection createSuccessor() {
        STTrailerXRefSection newXRefSection = new STTrailerXRefSection(this.getDoc());
        COSDictionary newTrailer = (COSDictionary)this.cosGetDict().copyShallow();
        newTrailer.remove(COSTrailer.DK_Prev);
        newTrailer.remove(STXRefSection.DK_XRefStm);
        newXRefSection.cosSetDict(newTrailer);
        newXRefSection.setPrevious(this);
        return newXRefSection;
    }

    public AbstractXRefWriter getWriter(COSWriter cosWriter) {
        return new XRefTrailerWriter(cosWriter);
    }

    public STStreamXRefSection getXRefStream() {
        return this.xRefStream;
    }

    protected boolean isStreamed() {
        return false;
    }

    public COSObject load(int objectNumber, ISystemSecurityHandler securityHandler) throws IOException, COSLoadException {
        COSObject loaded;
        if (this.getXRefStream() != null && (loaded = this.getXRefStream().load(objectNumber, securityHandler)) != null) {
            return loaded;
        }
        return super.load(objectNumber, securityHandler);
    }

    public void setXRefStream(STStreamXRefSection xRefStream) {
        this.xRefStream = xRefStream;
        this.setXRefStmOffset(xRefStream.getOffset());
    }
}

