/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.parser;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSFalse;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.COSTrue;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.COSLoadWarning;
import de.intarsys.pdf.parser.IPDFParserExceptionHandler;
import de.intarsys.pdf.st.STDocType;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.FastByteArrayOutputStream;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class PDFParser {
    public static char CHAR_CR = (char)13;
    public static char CHAR_LF = (char)10;
    public static char CHAR_HT = (char)9;
    public static char CHAR_BS = (char)8;
    public static char CHAR_FF = (char)12;
    public static final byte[] TOKEN_PDFHEADER = "%PDF".getBytes();
    public static final byte[] TOKEN_FDFHEADER = "%FDF".getBytes();
    public static final byte[] TOKEN_EOF = "%%EOF".getBytes();
    public static final byte[] TOKEN_obj = "obj".getBytes();
    public static final byte[] TOKEN_endobj = "endobj".getBytes();
    public static final byte[] TOKEN_false = "false".getBytes();
    public static final byte[] TOKEN_true = "true".getBytes();
    public static final byte[] TOKEN_null = "null".getBytes();
    public static final byte[] TOKEN_startxref = "startxref".getBytes();
    public static final byte[] TOKEN_trailer = "trailer".getBytes();
    public static final byte[] TOKEN_xref = "xref".getBytes();
    public static final byte[] TOKEN_stream = "stream".getBytes();
    public static final byte[] TOKEN_s_tream = "tream".getBytes();
    public static final byte[] TOKEN_endstream = "endstream".getBytes();
    public static final byte[] TOKEN_ndstream = "ndstream".getBytes();
    public static final byte[] TOKEN_R = "R".getBytes();
    public static final String C_WARN_UNEVENHEX = "616a";
    public static final String C_WARN_ILLEGALHEX = "616b";
    public static final String C_WARN_STRINGTOLONG = "ImplLimitString";
    public static final String C_WARN_NAMETOLONG = "ImplLimitName";
    public static final String C_WARN_ARRAYSIZE = "ImplLimitArray";
    public static final String C_WARN_SINGLESPACE = "614a";
    public static final String C_WARN_SINGLEEOL = "614b";
    public static final String C_WARN_STREAMEOL = "617a";
    public static final String C_WARN_ENDSTREAMEOL = "617b";
    public static final String C_WARN_ENDSTREAMCORRUPT = "617c";
    public static final String C_WARN_STREAMEXTERNAL = "617d";
    public static final String C_WARN_STREAMLENGTH = "617e";
    public static final String C_WARN_SINGLESPACE_OBJ = "618a";
    public static final String C_WARN_SINGLEEOL_OBJ = "618b";
    public static final String C_WARN_ENDOBJ_MISSING = "618c";
    public static final String C_WARN_LARGE_INT = "6112a";
    protected static final String C_TOKEN_ADDWSB = "additional whitespace before";
    protected static final String C_TOKEN_WSB = "whitespace before";
    protected static final String C_TOKEN_ADDWSA = "additional whitespace after";
    protected static final String C_TOKEN_ADDWSA2 = "second add whitespace after";
    protected static final String C_TOKEN_COMMENT = "comment";
    protected static final String C_TOKEN_NOWSA = "no whitespace after";
    protected static final byte[] characterClass = new byte[256];
    protected static final byte CHARCLASS_ANY = 0;
    protected static final byte CHARCLASS_DELIMITER = 1;
    protected static final byte CHARCLASS_WHITESPACE = 2;
    protected static final byte CHARCLASS_TOKEN = 3;
    protected static final byte CHARCLASS_DIGIT = 4;
    protected static final byte CHARCLASS_NUMBERSPECIAL = 5;
    public static final byte[] TOKEN_def = "def".getBytes();
    private COSObject[] lookahead = new COSObject[3];
    private int lookaheadCount = 0;
    private ISystemSecurityHandler securityHandler;
    private boolean flushLookahead = false;
    private FastByteArrayOutputStream localStream = new FastByteArrayOutputStream();
    private IPDFParserExceptionHandler exceptionHandler;
    private COSObjectKey objectKey;
    protected boolean check = false;

    static {
        int i = 0;
        while (i < 256) {
            PDFParser.characterClass[i] = 0;
            ++i;
        }
        PDFParser.characterClass[40] = 1;
        PDFParser.characterClass[41] = 1;
        PDFParser.characterClass[60] = 1;
        PDFParser.characterClass[62] = 1;
        PDFParser.characterClass[91] = 1;
        PDFParser.characterClass[93] = 1;
        PDFParser.characterClass[123] = 1;
        PDFParser.characterClass[125] = 1;
        PDFParser.characterClass[47] = 1;
        PDFParser.characterClass[37] = 1;
        PDFParser.characterClass[32] = 2;
        PDFParser.characterClass[9] = 2;
        PDFParser.characterClass[13] = 2;
        PDFParser.characterClass[10] = 2;
        PDFParser.characterClass[12] = 2;
        PDFParser.characterClass[0] = 2;
        PDFParser.characterClass[48] = 4;
        PDFParser.characterClass[49] = 4;
        PDFParser.characterClass[50] = 4;
        PDFParser.characterClass[51] = 4;
        PDFParser.characterClass[52] = 4;
        PDFParser.characterClass[53] = 4;
        PDFParser.characterClass[54] = 4;
        PDFParser.characterClass[55] = 4;
        PDFParser.characterClass[56] = 4;
        PDFParser.characterClass[57] = 4;
        PDFParser.characterClass[46] = 5;
        PDFParser.characterClass[45] = 5;
        PDFParser.characterClass[43] = 5;
        i = 97;
        while (i <= 122) {
            PDFParser.characterClass[i] = 3;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            PDFParser.characterClass[i] = 3;
            ++i;
        }
        PDFParser.characterClass[39] = 3;
        PDFParser.characterClass[34] = 3;
    }

    public static final boolean isDelimiter(int i) {
        return characterClass[i] == 1;
    }

    public static final boolean isDigit(int i) {
        return characterClass[i] == 4;
    }

    public static final boolean isEOL(int i) {
        return i == CHAR_CR || i == CHAR_LF || i == 12;
    }

    public static final boolean isNumberStart(int i) {
        byte cc = characterClass[i];
        return cc == 4 || cc == 5;
    }

    public static final boolean isOctalDigit(int i) {
        return i >= 48 && i <= 55;
    }

    public static final boolean isTokenStart(int i) {
        return characterClass[i] == 3;
    }

    public static final boolean isWhitespace(int i) {
        return characterClass[i] == 2;
    }

    public static COSObject toCOSObject(byte[] data) throws IOException, COSLoadException {
        COSDocumentParser docParser = new COSDocumentParser(null);
        return (COSObject)docParser.parseElement((IRandomAccess)new RandomAccessByteArray(data));
    }

    protected abstract COSIndirectObject createObjectReference(IRandomAccess var1) throws IOException, COSLoadException;

    public IPDFParserExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected COSObjectKey getObjectKey() {
        return this.objectKey;
    }

    protected ISystemSecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public void handleError(COSLoadError error) throws COSLoadException {
        if (this.exceptionHandler == null) {
            throw error;
        }
        this.exceptionHandler.error(error);
    }

    public void handleWarning(COSLoadWarning warning) throws COSLoadException {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.warning(warning);
        }
    }

    protected COSObject lookaheadPop() {
        COSObject result = this.lookahead[0];
        this.lookahead[0] = this.lookahead[1];
        this.lookahead[1] = this.lookahead[2];
        this.lookahead[2] = null;
        --this.lookaheadCount;
        if (this.lookaheadCount <= 0) {
            this.lookaheadCount = 0;
            this.flushLookahead = false;
        }
        return result;
    }

    protected void lookaheadPush(COSObject obj) {
        this.lookahead[this.lookaheadCount++] = obj;
    }

    protected void parseComment(IRandomAccess input) throws IOException {
        int next;
        while ((next = input.read()) != -1 && !PDFParser.isEOL(next)) {
        }
    }

    public Object parseElement(IRandomAccess input) throws IOException, COSLoadException {
        int next;
        while (true) {
            if ((next = input.read()) == -1) {
                return null;
            }
            if (PDFParser.isNumberStart(next)) {
                return this.parseOnObjectNumber(input, next);
            }
            if (next == 40) {
                return this.parseOnObjectString(input);
            }
            if (PDFParser.isTokenStart(next)) {
                byte[] token = this.readTokenElement(input, next);
                if (token.length == 1) {
                    if (token[0] == TOKEN_R[0]) {
                        return TOKEN_R;
                    }
                } else if (token.length == 4) {
                    if (token[0] == TOKEN_true[0] && token[1] == TOKEN_true[1] && token[2] == TOKEN_true[2] && token[3] == TOKEN_true[3]) {
                        return COSTrue.create();
                    }
                    if (token[0] == TOKEN_null[0] && token[1] == TOKEN_null[1] && token[2] == TOKEN_null[2] && token[3] == TOKEN_null[3]) {
                        return COSNull.create();
                    }
                } else if (token.length == 5 && token[0] == TOKEN_false[0] && token[1] == TOKEN_false[1] && token[2] == TOKEN_false[2] && token[3] == TOKEN_false[3] && token[4] == TOKEN_false[4]) {
                    return COSFalse.create();
                }
                return token;
            }
            if (next == 47) {
                return this.parseOnObjectName(input);
            }
            if (next == 32 || PDFParser.isWhitespace(next)) continue;
            if (next != 37) break;
            this.parseComment(input);
        }
        if (this.lookaheadCount > 0) {
            input.seekBy(-1L);
            return null;
        }
        if (next == 60) {
            return this.parseOnObjectStreamOrDictionaryOrHexString(input);
        }
        if (next == 91) {
            return this.parseOnObjectArray(input);
        }
        input.seekBy(-1L);
        return null;
    }

    public STDocType parseHeader(IRandomAccess input) throws IOException, COSLoadException {
        int next;
        boolean errHeader = false;
        while ((next = input.read()) != -1 && next != 37) {
            errHeader = true;
        }
        STDocType docType = new STDocType();
        if (next == -1) {
            COSLoadError e = new COSLoadError("file format error. document must start with %PDF or %FDF");
            this.handleError(e);
        } else {
            byte[] token = new byte[4];
            token[0] = (byte)next;
            input.read(token, 1, 3);
            if (Arrays.equals(token, TOKEN_PDFHEADER)) {
                docType.setTypeName("PDF");
            } else if (Arrays.equals(token, TOKEN_FDFHEADER)) {
                docType.setTypeName("FDF");
            } else {
                input.seekBy((long)(-token.length));
                COSLoadError e = new COSLoadError("file format error. document must start with %PDF or %FDF at character index " + input.getOffset());
                this.handleError(e);
            }
            if (errHeader) {
                COSLoadWarning w = new COSLoadWarning("file format error. document must start with %PDF or %FDF at character index " + input.getOffset());
                this.handleWarning(w);
            }
            input.read();
            byte[] version = this.readToken(input);
            if (version == null) {
                COSLoadError e = new COSLoadError("file format error. no pdf/fdf version info found at character index " + input.getOffset());
                this.handleError(e);
            } else {
                docType.setVersion(StringTools.toString((byte[])version));
            }
        }
        return docType;
    }

    protected COSDocumentElement parseObject(IRandomAccess input) throws IOException, COSLoadException {
        if (this.flushLookahead) {
            return this.lookaheadPop();
        }
        Object parsedElement = this.parseElement(input);
        if (parsedElement == null) {
            this.flushLookahead = true;
            return this.lookaheadPop();
        }
        if (parsedElement instanceof byte[]) {
            if (TOKEN_R == parsedElement) {
                return this.createObjectReference(input);
            }
            input.seekBy(-1L);
            int next = input.read();
            if (next == 32 || PDFParser.isWhitespace(next)) {
                input.seekBy(-1L);
            }
            input.seekBy((long)(-((byte[])parsedElement).length));
            this.flushLookahead = true;
            return this.lookaheadPop();
        }
        COSObject resultObject = (COSObject)parsedElement;
        if (resultObject instanceof COSNumber) {
            this.lookaheadPush(resultObject);
            if (this.lookaheadCount > 2) {
                return this.lookaheadPop();
            }
            return this.parseObject(input);
        }
        if (this.lookaheadCount > 0) {
            this.lookaheadPush(resultObject);
            this.flushLookahead = true;
            return this.lookaheadPop();
        }
        return resultObject;
    }

    protected COSObject parseObjectDictionary(IRandomAccess input) throws IOException, COSLoadException {
        COSLoadError e;
        int next = input.read();
        if (next != 60) {
            input.seekBy(-1L);
            e = new COSLoadError("'<' expected at character index " + input.getOffset());
            this.handleError(e);
        }
        if ((next = input.read()) != 60) {
            input.seekBy(-1L);
            e = new COSLoadError("'<' expected at character index " + input.getOffset());
            this.handleError(e);
        }
        return this.parseOnObjectDictionary(input);
    }

    protected COSObject parseOnObjectArray(IRandomAccess input) throws COSLoadException, IOException {
        try {
            COSArray result = COSArray.create();
            if (this.securityHandler != null) {
                this.securityHandler.pushContextObject(result);
            }
            while (true) {
                COSDocumentElement element;
                if ((element = this.parseObject(input)) == null) {
                    int next = input.read();
                    if (next == -1) {
                        this.unexpectedEndOfInput(input);
                    }
                    if (next == 93) break;
                    byte[] badElement = this.readTokenElement(input, next);
                    if (!this.check) continue;
                    COSLoadWarning pwarn = new COSLoadWarning("bad array element (" + new String(badElement) + ")");
                    pwarn.setHint(result);
                    this.handleWarning(pwarn);
                    continue;
                }
                result.basicAddSilent(element);
            }
            if (this.check && result.size() > 8191) {
                COSLoadWarning pwarn = new COSLoadWarning(C_WARN_ARRAYSIZE);
                pwarn.setHint(result);
                this.handleWarning(pwarn);
            }
            COSArray cOSArray = result;
            return cOSArray;
        }
        finally {
            if (this.securityHandler != null) {
                this.securityHandler.popContextObject();
            }
        }
    }

    protected COSObject parseOnObjectDictionary(IRandomAccess input) throws IOException, COSLoadException {
        try {
            COSLoadError e;
            COSDictionary dict = COSDictionary.create();
            if (this.securityHandler != null) {
                this.securityHandler.pushContextObject(dict);
            }
            try {
                while (true) {
                    COSDocumentElement keyObject;
                    if ((keyObject = this.parseObject(input)) == null) {
                        input.mark();
                        Object tempElement = this.parseElement(input);
                        if (tempElement != null && tempElement instanceof byte[] && Arrays.equals(TOKEN_def, (byte[])tempElement)) continue;
                        input.reset();
                        break;
                    }
                    COSName dictKey = (COSName)keyObject;
                    COSDocumentElement value = this.parseObject(input);
                    if (value == null) {
                        COSLoadError e2 = new COSLoadError("missing value for key '" + keyObject + "' at character index " + input.getOffset());
                        this.handleError(e2);
                        continue;
                    }
                    dict.basicPutSilent(dictKey, value);
                }
            }
            catch (ClassCastException ex) {
                COSLoadError e3 = new COSLoadError("name expected at character index " + input.getOffset());
                this.handleError(e3);
            }
            int next = input.read();
            if (next != 62) {
                e = new COSLoadError("unexpected character (" + (char)next + ") at character index " + input.getOffset());
                this.handleError(e);
            }
            if ((next = input.read()) != 62) {
                e = new COSLoadError("unexpected character (" + (char)next + ") at character index " + input.getOffset());
                this.handleError(e);
            }
            COSDictionary cOSDictionary = dict;
            return cOSDictionary;
        }
        finally {
            if (this.securityHandler != null) {
                this.securityHandler.popContextObject();
            }
        }
    }

    protected COSObject parseOnObjectHexString(IRandomAccess input, int next) throws IOException, COSLoadException {
        COSString result;
        this.localStream.reset();
        boolean secondDigit = false;
        int digitValue = 0;
        int charValue = 0;
        while (true) {
            if ((digitValue = HexTools.hexDigitToInt((char)((char)next))) == -1) {
                if (next == -1 || next == 62) break;
                if (!PDFParser.isWhitespace(next)) {
                    IOException ioe = new IOException("<" + next + "> '" + (char)next + "' not a valid hex char");
                    COSLoadWarning pwarn = new COSLoadWarning(C_WARN_ILLEGALHEX);
                    pwarn.setHint(new Long(input.getOffset()));
                    this.handleWarning(pwarn);
                    throw ioe;
                }
            } else if (secondDigit) {
                charValue = (charValue << 4) + digitValue;
                this.localStream.write(charValue);
                secondDigit = false;
            } else {
                secondDigit = true;
                charValue = digitValue;
            }
            next = input.read();
        }
        if (secondDigit) {
            if (this.check) {
                COSLoadWarning pwarn = new COSLoadWarning(C_WARN_UNEVENHEX);
                pwarn.setHint(new Long(input.getOffset()));
                this.handleWarning(pwarn);
            }
            this.localStream.write(charValue <<= 4);
        }
        if (this.securityHandler == null || this.objectKey == null) {
            result = COSString.createHex(this.localStream.toByteArray());
        } else {
            byte[] bytes = this.localStream.toByteArray();
            try {
                byte[] decrypted = this.securityHandler.decryptString(this.objectKey, bytes);
                result = COSString.createHex(decrypted);
            }
            catch (COSSecurityException e) {
                result = COSString.createHex(bytes);
                COSLoadWarning warning = new COSLoadWarning("error decrypting string " + this.objectKey, e);
                this.handleWarning(warning);
            }
        }
        if (this.check && result.stringValue().length() > 65535) {
            COSLoadWarning pwarn = new COSLoadWarning(C_WARN_STRINGTOLONG);
            pwarn.setHint(result);
            this.handleWarning(pwarn);
        }
        return result;
    }

    protected COSObject parseOnObjectName(IRandomAccess input) throws IOException, COSLoadException {
        int next;
        this.localStream.reset();
        while ((next = input.read()) != -1 && next != 32 && !PDFParser.isWhitespace(next)) {
            if (PDFParser.isDelimiter(next)) {
                input.seekBy(-1L);
                break;
            }
            if (next == 35) {
                int digit2;
                next = input.read();
                int digit1 = HexTools.hexDigitToInt((char)((char)next));
                if (digit1 == -1) {
                    COSLoadError e = new COSLoadError("<" + next + "> not a valid hex char at character index " + input.getOffset());
                    this.handleError(e);
                }
                if ((digit2 = HexTools.hexDigitToInt((char)((char)(next = input.read())))) == -1) {
                    COSLoadError e = new COSLoadError("<" + next + "> not a valid hex char at character index " + input.getOffset());
                    this.handleError(e);
                }
                this.localStream.write((digit1 << 4) + digit2);
                continue;
            }
            this.localStream.write(next);
        }
        byte[] bytes = this.localStream.toByteArray();
        COSName result = COSName.create(bytes);
        if (this.check && result.stringValue().length() > 127) {
            COSLoadWarning pwarn = new COSLoadWarning(C_WARN_NAMETOLONG);
            pwarn.setHint(result);
            this.handleWarning(pwarn);
        }
        return result;
    }

    protected COSObject parseOnObjectNumber(IRandomAccess input, int next) throws IOException, COSLoadException {
        boolean isFixed = false;
        this.localStream.reset();
        isFixed = next == 46;
        this.localStream.write((int)((byte)next));
        while ((next = input.read()) != -1) {
            if (PDFParser.isDigit(next)) {
                this.localStream.write((int)((byte)next));
                continue;
            }
            if (next == 46) {
                isFixed = true;
                this.localStream.write((int)((byte)next));
                continue;
            }
            if (next == 32 || PDFParser.isWhitespace(next)) break;
            input.seekBy(-1L);
            break;
        }
        if (isFixed) {
            COSFixed fixed = COSFixed.create(this.localStream.getBytes(), 0, this.localStream.size());
            return fixed;
        }
        byte[] streamBytes = this.localStream.getBytes();
        int streamSize = this.localStream.size();
        if (this.exceptionHandler != null) {
            COSInteger result = COSInteger.createStrict(streamBytes, 0, streamSize);
            if (result != null) {
                return result;
            }
            COSLoadWarning warning = new COSLoadWarning(C_WARN_LARGE_INT);
            this.handleWarning(warning);
        }
        return COSInteger.create(streamBytes, 0, streamSize);
    }

    protected COSObject parseOnObjectStream(IRandomAccess input, COSDictionary dict) throws IOException, COSLoadException {
        COSLoadWarning pwarn;
        int next;
        COSStream stream = COSStream.create(dict);
        byte[] token = new byte[5];
        input.read(token);
        if (!Arrays.equals(token, TOKEN_s_tream)) {
            input.seekBy((long)(-token.length - 1));
            COSLoadError e = new COSLoadError("file format error. 'stream' expected at character index " + input.getOffset());
            this.handleError(e);
        }
        if ((next = input.read()) == -1) {
            this.unexpectedEndOfInput(input);
        }
        if (next == CHAR_CR) {
            next = input.read();
        }
        if (next != CHAR_LF) {
            if (this.check) {
                COSLoadWarning pwarn2 = new COSLoadWarning(C_WARN_STREAMEOL);
                pwarn2.setHint(new Long(input.getOffset()));
                this.handleWarning(pwarn2);
            }
            input.seekBy(-1L);
        }
        long offset = input.getOffset();
        int length = -1;
        COSInteger cosLength = dict.get(COSStream.DK_Length).asInteger();
        if (cosLength == null) {
            if (this.check) {
                COSLoadWarning pwarn3 = new COSLoadWarning(C_WARN_STREAMLENGTH);
                pwarn3.setHint(new Long(input.getOffset()));
                this.handleWarning(pwarn3);
            }
        } else {
            length = ((COSNumber)cosLength).intValue();
        }
        input.seek(offset);
        byte[] bytes = null;
        if (length < 0) {
            bytes = this.readStream(input);
        } else {
            bytes = new byte[length];
            int count = input.read(bytes);
            if (count < length) {
                if (this.check) {
                    pwarn = new COSLoadWarning(C_WARN_STREAMLENGTH);
                    pwarn.setHint(new Long(input.getOffset()));
                    this.handleWarning(pwarn);
                }
                this.unexpectedEndOfInput(input);
            }
        }
        if (this.check) {
            int test = this.readEOL(input);
            if (test != 1) {
                pwarn = new COSLoadWarning(C_WARN_ENDSTREAMEOL);
                pwarn.setHint(new Long(input.getOffset()));
                this.handleWarning(pwarn);
            }
        } else {
            this.readSpaces(input);
        }
        token = new byte[9];
        input.read(token);
        if (!Arrays.equals(token, TOKEN_endstream)) {
            COSLoadError e;
            input.seekBy((long)(-token.length - 1));
            COSLoadWarning pwarn4 = new COSLoadWarning(C_WARN_ENDSTREAMCORRUPT);
            pwarn4.setHint(new Long(input.getOffset()));
            this.handleWarning(pwarn4);
            if (length > 0) {
                input.seek(offset);
                bytes = this.readStream(input);
                token = new byte[9];
                input.read(token);
                if (!Arrays.equals(token, TOKEN_endstream)) {
                    e = new COSLoadError("file format error. 'endstream' expected at character index " + input.getOffset());
                    this.handleError(e);
                }
            } else {
                e = new COSLoadError("file format error. 'endstream' expected at character index " + input.getOffset());
                this.handleError(e);
            }
        }
        if (this.securityHandler == null || this.objectKey == null) {
            stream.basicSetEncodedBytes(bytes);
        } else {
            try {
                byte[] decrypted = this.securityHandler.decryptStream(this.objectKey, dict, bytes);
                stream.basicSetEncodedBytes(decrypted);
            }
            catch (COSSecurityException e) {
                stream.basicSetEncodedBytes(bytes);
                COSLoadWarning warning = new COSLoadWarning("error decrypting stream " + this.objectKey, e);
                this.handleWarning(warning);
            }
        }
        return stream;
    }

    protected COSObject parseOnObjectStreamOrDictionary(IRandomAccess input) throws IOException, COSLoadException {
        int next;
        COSObject dict = this.parseOnObjectDictionary(input);
        boolean lastWasEOL = false;
        while (true) {
            if ((next = input.read()) == -1) {
                return dict;
            }
            if (next != 32 && !PDFParser.isWhitespace(next)) break;
            if (next == 10 || next == 13) {
                lastWasEOL = true;
                continue;
            }
            lastWasEOL = false;
        }
        if (next == 115) {
            return this.parseOnObjectStream(input, (COSDictionary)dict);
        }
        if (next == 101 && this.check && !lastWasEOL) {
            COSLoadWarning pwarn = new COSLoadWarning(C_WARN_SINGLEEOL_OBJ);
            pwarn.setHint(new Long(input.getOffset()));
            this.handleWarning(pwarn);
        }
        input.seekBy(-1L);
        return dict;
    }

    protected COSObject parseOnObjectStreamOrDictionaryOrHexString(IRandomAccess input) throws IOException, COSLoadException {
        int next = input.read();
        if (next == 60) {
            return this.parseOnObjectStreamOrDictionary(input);
        }
        return this.parseOnObjectHexString(input, next);
    }

    protected COSObject parseOnObjectString(IRandomAccess input) throws IOException, COSLoadException {
        COSString result;
        int paraCount = 0;
        this.localStream.reset();
        while (true) {
            int next;
            if ((next = input.read()) == 92) {
                int c = this.readEscape(input);
                if (c == -1) continue;
                this.localStream.write(c);
                continue;
            }
            if (next == 41) {
                if (paraCount <= 0) break;
                --paraCount;
                this.localStream.write(next);
                continue;
            }
            if (next == CHAR_CR) {
                next = input.read();
                if (next != -1 && next != CHAR_LF) {
                    input.seekBy(-1L);
                }
                this.localStream.write((int)CHAR_LF);
                continue;
            }
            if (next == 40) {
                ++paraCount;
                this.localStream.write(next);
                continue;
            }
            if (next == -1) {
                this.unexpectedEndOfInput(input);
                continue;
            }
            this.localStream.write(next);
        }
        if (this.securityHandler == null || this.objectKey == null) {
            result = COSString.create(this.localStream.toByteArray());
        } else {
            byte[] bytes = this.localStream.toByteArray();
            try {
                byte[] decrypted = this.securityHandler.decryptString(this.objectKey, bytes);
                result = COSString.create(decrypted);
            }
            catch (COSSecurityException e) {
                result = COSString.create(bytes);
                COSLoadWarning warning = new COSLoadWarning("error decrypting string " + this.objectKey, e);
                this.handleWarning(warning);
            }
        }
        if (this.check && result.stringValue().length() > 65535) {
            COSLoadWarning pwarn = new COSLoadWarning(C_WARN_STRINGTOLONG);
            pwarn.setHint(result);
            this.handleWarning(pwarn);
        }
        return result;
    }

    protected int readEOL(IRandomAccess input) throws IOException {
        int next = input.read();
        if (next == -1) {
            return 0;
        }
        if (next == CHAR_CR) {
            next = input.read();
            if (next == -1) {
                return 1;
            }
            if (next == CHAR_LF) {
                next = input.read();
                if (next == -1) {
                    return 1;
                }
                if (PDFParser.isWhitespace(next)) {
                    this.readSpaces(input);
                    return 2;
                }
                input.seekBy(-1L);
                return 1;
            }
            if (PDFParser.isWhitespace(next)) {
                this.readSpaces(input);
                return 2;
            }
            input.seekBy(-1L);
            return 1;
        }
        if (next == CHAR_LF) {
            next = input.read();
            if (next == -1) {
                return 1;
            }
            if (PDFParser.isWhitespace(next)) {
                this.readSpaces(input);
                return 2;
            }
            input.seekBy(-1L);
            return 1;
        }
        if (PDFParser.isWhitespace(next)) {
            this.readSpaces(input);
            return 2;
        }
        input.seekBy(-1L);
        return 0;
    }

    protected int readEscape(IRandomAccess input) throws IOException {
        int next = 0;
        next = input.read();
        if (next == -1) {
            return -1;
        }
        if (PDFParser.isOctalDigit(next)) {
            input.seekBy(-1L);
            return this.readOctalChar(input);
        }
        if (next == CHAR_LF) {
            return -1;
        }
        if (next == CHAR_CR) {
            next = input.read();
            if (next != -1 && next != CHAR_LF) {
                input.seekBy(-1L);
            }
            return -1;
        }
        if (next == 110) {
            return CHAR_LF;
        }
        if (next == 114) {
            return CHAR_CR;
        }
        if (next == 116) {
            return CHAR_HT;
        }
        if (next == 98) {
            return CHAR_BS;
        }
        if (next == 102) {
            return CHAR_FF;
        }
        return next;
    }

    public int readInteger(IRandomAccess input, boolean consumeSpaceAfter) throws IOException {
        int result;
        block6: {
            int next;
            result = 0;
            while (true) {
                if ((next = input.read()) == -1) {
                    return result;
                }
                if (next == 32 || PDFParser.isWhitespace(next)) continue;
                if (next != 37) break;
                this.parseComment(input);
            }
            boolean digitFound = false;
            do {
                if (!PDFParser.isDigit(next)) {
                    if (!digitFound) {
                        throw new IOException("digit expected at " + input.getOffset());
                    }
                    input.seekBy(-1L);
                    break block6;
                }
                digitFound = true;
                result = result * 10 + next - 48;
                next = input.read();
                if (next == -1) break block6;
            } while (next != 32 && !PDFParser.isWhitespace(next));
            if (!consumeSpaceAfter) {
                input.seekBy(-1L);
            }
        }
        return result;
    }

    protected int readOctalChar(IRandomAccess input) throws IOException {
        int result = -1;
        int c = 0;
        c = input.read();
        if (PDFParser.isOctalDigit(c)) {
            result = c - 48;
            c = input.read();
            if (PDFParser.isOctalDigit(c)) {
                result = (result << 3) + c - 48;
                c = input.read();
                if (PDFParser.isOctalDigit(c)) {
                    result = (result << 3) + c - 48;
                } else {
                    if (c == -1) {
                        return result;
                    }
                    input.seekBy(-1L);
                }
            } else {
                if (c == -1) {
                    return result;
                }
                input.seekBy(-1L);
            }
        } else {
            if (c == -1) {
                return result;
            }
            input.seekBy(-1L);
        }
        return result;
    }

    public void readSpaces(IRandomAccess input) throws IOException {
        int next = 0;
        while ((next = input.read()) != -1) {
            if (next == 32 || PDFParser.isWhitespace(next)) continue;
            input.seekBy(-1L);
            break;
        }
    }

    protected byte[] readStream(IRandomAccess input) throws IOException {
        byte[] token = new byte[8];
        this.localStream.reset();
        while (true) {
            int next;
            if ((next = input.read()) == 101) {
                input.read(token);
                if (Arrays.equals(token, TOKEN_ndstream)) {
                    input.seekBy((long)(-TOKEN_endstream.length));
                    return this.localStream.toByteArray();
                }
                input.seekBy((long)(-token.length));
            } else if (next == -1) break;
            this.localStream.write(next);
        }
        if (this.localStream.size() == 0) {
            return null;
        }
        return this.localStream.toByteArray();
    }

    public byte[] readToken(IRandomAccess input) throws IOException {
        int next;
        while (true) {
            if ((next = input.read()) == -1) {
                return null;
            }
            if (next == 32 || PDFParser.isWhitespace(next)) continue;
            if (next != 37) break;
            this.parseComment(input);
        }
        return this.readTokenElement(input, next);
    }

    public byte[] readToken(IRandomAccess input, List messages, boolean strict) throws IOException {
        int next;
        int countWS = 0;
        boolean crEol = false;
        while (true) {
            if ((next = input.read()) == -1) {
                return null;
            }
            if (next == 32 || PDFParser.isWhitespace(next)) {
                if (strict || crEol || next != 32) {
                    ++countWS;
                }
                if (!(countWS <= 1 || crEol && next == 10)) {
                    messages.add(C_TOKEN_ADDWSB);
                    continue;
                }
                if (strict && next == 32) {
                    messages.add(C_TOKEN_WSB);
                    continue;
                }
                if (next == 13) {
                    crEol = true;
                    continue;
                }
                crEol = false;
                continue;
            }
            if (next != 37) break;
            messages.add(C_TOKEN_COMMENT);
            this.parseComment(input);
        }
        return this.readTokenElement(input, next, messages);
    }

    protected byte[] readTokenElement(IRandomAccess input, int next) throws IOException {
        this.localStream.reset();
        this.localStream.write(next);
        while ((next = input.read()) != -1 && next != 32 && !PDFParser.isWhitespace(next)) {
            if (PDFParser.isDelimiter(next)) {
                input.seekBy(-1L);
                break;
            }
            this.localStream.write(next);
        }
        return this.localStream.toByteArray();
    }

    protected byte[] readTokenElement(IRandomAccess input, int next, List messages) throws IOException {
        this.localStream.reset();
        this.localStream.write(next);
        while ((next = input.read()) != -1) {
            if (next == 32 || PDFParser.isWhitespace(next)) {
                if (next == 32) {
                    messages.add(C_TOKEN_ADDWSA);
                }
                if ((next = input.read()) == 32) {
                    messages.add(C_TOKEN_ADDWSA2);
                }
                if (next == -1) break;
                input.seekBy(-1L);
                break;
            }
            if (PDFParser.isDelimiter(next)) {
                messages.add(C_TOKEN_NOWSA);
                input.seekBy(-1L);
                break;
            }
            this.localStream.write(next);
        }
        return this.localStream.toByteArray();
    }

    public void setExceptionHandler(IPDFParserExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        this.check = exceptionHandler != null;
    }

    protected void setObjectKey(COSObjectKey objectKey) {
        this.objectKey = objectKey;
    }

    protected void setSecurityHandler(ISystemSecurityHandler securityHandler) {
        this.securityHandler = securityHandler;
    }

    protected void unexpectedEndOfInput(IRandomAccess input) throws IOException, COSLoadException {
        COSLoadError e = new COSLoadError("file format error. unexpected end of input at character index " + input.getOffset());
        this.handleError(e);
    }
}

