/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.CMapBFCharCodeMap;
import de.intarsys.pdf.font.CMapBFCharNameMap;
import de.intarsys.pdf.font.CMapBFCharStringMap;
import de.intarsys.pdf.font.CMapBFRangeCodeMap;
import de.intarsys.pdf.font.CMapBFRangeNameArrayMap;
import de.intarsys.pdf.font.CMapBFRangeStringArrayMap;
import de.intarsys.pdf.font.CMapBFRangeStringMap;
import de.intarsys.pdf.font.CMapCIDCharCodeMap;
import de.intarsys.pdf.font.CMapCIDRangeCodeMap;
import de.intarsys.pdf.font.CMapCharMap;
import de.intarsys.pdf.font.CMapMap;
import de.intarsys.pdf.font.CMapNotDefRangeMap;
import de.intarsys.pdf.font.CMapOperator;
import de.intarsys.pdf.font.CMapRange;
import de.intarsys.pdf.font.CMapRangeMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class StreamBasedCMap
extends CMap {
    public static final COSName DK_CIDSystemInfo = COSName.constant("CIDSystemInfo");
    public static final COSName DK_CMapName = COSName.constant("CMapName");
    public static final COSName DK_UseCMap = COSName.constant("UseCMap");
    public static final COSName DK_WMode = COSName.constant("WMode");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private Map<COSName, COSObject> definitions = new HashMap<COSName, COSObject>();
    private List maps = new ArrayList();
    private List notdefs = new ArrayList();
    private CMapRange[][] ranges = new CMapRange[4][0];

    protected StreamBasedCMap(COSObject object) {
        super(object);
    }

    protected void addDefinition(COSName key, COSObject value) {
        this.definitions.put(key, value);
    }

    protected void addMap(CMapMap map) {
        this.maps.add(map);
    }

    protected void addNotdef(CMapMap notdef) {
        this.notdefs.add(notdef);
    }

    protected void addRange(CMapRange range) {
        int count = range.getByteCount();
        CMapRange[] rangeArray = this.ranges[count];
        CMapRange[] tempArray = new CMapRange[rangeArray.length + 1];
        System.arraycopy(rangeArray, 0, tempArray, 0, rangeArray.length);
        tempArray[rangeArray.length] = range;
        this.ranges[count] = tempArray;
    }

    protected boolean checkPrefix(byte[] bytes, int count) {
        int k = 0;
        while (k < this.ranges.length) {
            CMapRange[] rangeArray = this.ranges[k];
            int i = 0;
            while (i < rangeArray.length) {
                CMapRange range = rangeArray[i];
                if (range.checkPrefix(bytes, count)) {
                    return true;
                }
                ++i;
            }
            ++k;
        }
        return false;
    }

    protected boolean checkRange(byte[] bytes, int count) {
        if (count >= this.ranges.length) {
            return false;
        }
        CMapRange[] rangeArray = this.ranges[count];
        int i = 0;
        while (i < rangeArray.length) {
            CMapRange range = rangeArray[i];
            if (range.checkRange(bytes, count)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void do_beginbfchar(CSOperation operation) {
    }

    protected void do_beginbfrange(CSOperation operation) {
    }

    protected void do_begincidchar(CSOperation operation) {
    }

    protected void do_begincidrange(CSOperation operation) {
    }

    protected void do_begincmap(CSOperation operation) {
    }

    protected void do_begincodespacerange(CSOperation operation) {
    }

    protected void do_beginnotdefchar(CSOperation operation) {
    }

    protected void do_beginnotdefrange(CSOperation operation) {
    }

    protected void do_def(CSOperation operation) {
        COSDictionary dict;
        Iterator it = operation.getOperands();
        COSObject operand = COSNull.NULL;
        if (it.hasNext()) {
            operand = (COSObject)it.next();
        }
        if ((dict = operand.asDictionary()) == null) {
            COSName key = operand.asName();
            if (key == null) {
                return;
            }
            COSObject value = COSNull.NULL;
            if (it.hasNext()) {
                value = (COSObject)it.next();
            }
            this.addDefinition(key, value);
        } else {
            Iterator eit = dict.entryIterator();
            while (eit.hasNext()) {
                Map.Entry entry = (Map.Entry)eit.next();
                COSName key = (COSName)entry.getKey();
                COSObject value = (COSObject)entry.getValue();
                this.addDefinition(key, value);
            }
        }
    }

    protected void do_endbfchar(CSOperation operation) {
        Iterator it = operation.getOperands();
        while (it.hasNext()) {
            byte[] destBytes;
            COSString start = (COSString)it.next();
            COSObject destination = (COSObject)it.next();
            CMapCharMap map = destination instanceof COSString ? ((destBytes = ((COSString)destination).byteValue()).length > 2 ? new CMapBFCharStringMap(start.byteValue(), destBytes) : new CMapBFCharCodeMap(start.byteValue(), destBytes)) : new CMapBFCharNameMap(start.byteValue(), (COSName)destination);
            this.addMap(map);
        }
    }

    protected void do_endbfrange(CSOperation operation) {
        Iterator it = operation.getOperands();
        while (it.hasNext()) {
            COSArray array;
            byte[] destBytes;
            COSString start = (COSString)it.next();
            COSString end = (COSString)it.next();
            COSObject destination = (COSObject)it.next();
            CMapRangeMap map = destination instanceof COSString ? ((destBytes = ((COSString)destination).byteValue()).length > 2 ? new CMapBFRangeStringMap(start.byteValue(), end.byteValue(), ((COSString)destination).byteValue()) : new CMapBFRangeCodeMap(start.byteValue(), end.byteValue(), ((COSString)destination).byteValue())) : ((array = destination.asArray()).get(0) instanceof COSString ? new CMapBFRangeStringArrayMap(start.byteValue(), end.byteValue(), (COSArray)destination) : new CMapBFRangeNameArrayMap(start.byteValue(), end.byteValue(), (COSArray)destination));
            this.addMap(map);
        }
    }

    protected void do_endcidchar(CSOperation operation) {
        Iterator it = operation.getOperands();
        while (it.hasNext()) {
            COSString start = (COSString)it.next();
            COSInteger destination = (COSInteger)it.next();
            CMapCIDCharCodeMap map = new CMapCIDCharCodeMap(start.byteValue(), destination.intValue());
            this.addMap(map);
        }
    }

    protected void do_endcidrange(CSOperation operation) {
        Iterator it = operation.getOperands();
        while (it.hasNext()) {
            COSString start = (COSString)it.next();
            COSString end = (COSString)it.next();
            COSInteger destination = (COSInteger)it.next();
            CMapCIDRangeCodeMap map = new CMapCIDRangeCodeMap(start.byteValue(), end.byteValue(), destination.intValue());
            this.addMap(map);
        }
    }

    protected void do_endcmap(CSOperation operation) {
    }

    protected void do_endcodespacerange(CSOperation operation) {
        Iterator it = operation.getOperands();
        while (it.hasNext()) {
            COSString startString = (COSString)it.next();
            if (!it.hasNext()) break;
            COSString endString = (COSString)it.next();
            CMapRange range = new CMapRange(startString.byteValue(), endString.byteValue());
            this.addRange(range);
        }
    }

    protected void do_endnotdefchar(CSOperation operation) {
        Iterator it = operation.getOperands();
        while (it.hasNext()) {
            COSString start = (COSString)it.next();
            COSInteger destination = (COSInteger)it.next();
            CMapCIDCharCodeMap map = new CMapCIDCharCodeMap(start.byteValue(), destination.intValue());
            this.addNotdef(map);
        }
    }

    protected void do_endnotdefrange(CSOperation operation) {
        Iterator it = operation.getOperands();
        while (it.hasNext()) {
            COSString start = (COSString)it.next();
            COSString end = (COSString)it.next();
            COSInteger destination = (COSInteger)it.next();
            CMapNotDefRangeMap map = new CMapNotDefRangeMap(start.byteValue(), end.byteValue(), destination.intValue());
            this.addNotdef(map);
        }
    }

    protected void do_usecmap(CSOperation operation) {
    }

    protected void do_usefont(CSOperation operation) {
    }

    public char[] getChars(int codepoint) {
        for (CMapMap map : this.maps) {
            char[] result = map.toChars(codepoint);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int getDecoded(int codepoint) {
        for (CMapMap map : this.maps) {
            int result = map.toCID(codepoint);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public COSObject getDefinition(COSName key) {
        COSObject result = this.definitions.get(key);
        if (result == null) {
            return COSNull.NULL;
        }
        return result;
    }

    public int getEncoded(int character) {
        for (CMapMap map : this.maps) {
            int result = map.toCodepoint(character);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public int getNextDecoded(InputStream is) throws IOException {
        return this.getDecoded(this.getNextEncoded(is));
    }

    public int getNextEncoded(InputStream is) throws IOException {
        int nextByte;
        is.mark(4);
        byte[] bytes = new byte[4];
        int count = 0;
        while (count < 4) {
            nextByte = is.read();
            if (nextByte == -1) {
                return -1;
            }
            bytes[count++] = (byte)nextByte;
            if (!this.checkRange(bytes, count)) continue;
            return StreamBasedCMap.toInt(bytes, 0, count);
        }
        is.reset();
        bytes = new byte[4];
        count = 0;
        while (count < 4) {
            is.mark(1);
            nextByte = is.read();
            if (nextByte == -1) {
                return -1;
            }
            bytes[count++] = (byte)nextByte;
            if (this.checkPrefix(bytes, count)) continue;
            is.reset();
            return StreamBasedCMap.toInt(bytes, 0, --count);
        }
        return -1;
    }

    protected void initializeFromContent(CSContent content) {
        int len = content.size();
        int i = 0;
        while (i < len) {
            CSOperation operation = content.getOperation(i);
            this.initializeFromOperation(operation);
            ++i;
        }
    }

    protected void initializeFromOperation(CSOperation operation) {
        if (operation.matchesOperator(CMapOperator.CMO_beginbfchar)) {
            this.do_beginbfchar(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_beginbfrange)) {
            this.do_beginbfrange(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_begincidchar)) {
            this.do_begincidchar(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_begincidrange)) {
            this.do_begincidrange(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_begincmap)) {
            this.do_begincmap(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_begincodespacerange)) {
            this.do_begincodespacerange(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_beginnotdefchar)) {
            this.do_beginnotdefchar(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_beginnotdefrange)) {
            this.do_beginnotdefrange(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_endbfchar)) {
            this.do_endbfchar(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_endbfrange)) {
            this.do_endbfrange(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_endcidchar)) {
            this.do_endcidchar(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_endcidrange)) {
            this.do_endcidrange(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_endcmap)) {
            this.do_endcmap(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_endcodespacerange)) {
            this.do_endcodespacerange(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_endnotdefchar)) {
            this.do_endnotdefchar(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_endnotdefrange)) {
            this.do_endnotdefrange(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_usecmap)) {
            this.do_usecmap(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_usefont)) {
            this.do_usefont(operation);
        } else if (operation.matchesOperator(CMapOperator.CMO_def)) {
            this.do_def(operation);
        }
    }

    public void putNextDecoded(OutputStream os, int character) throws IOException {
        os.write(character >> 8 & 0xFF);
        os.write(character & 0xFF);
    }

    public void putNextEncoded(OutputStream os, int codepoint) throws IOException {
        os.write(codepoint >> 8 & 0xFF);
        os.write(codepoint & 0xFF);
    }

    public static class MetaClass
    extends CMap.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }
    }
}

