/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.CMapEncoding;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.font.CIDFont;
import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.IdentityCMap;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDGlyphs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PDFontType0
extends PDFont {
    public static final COSName DK_DescendantFonts = COSName.constant("DescendantFonts");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private CMap cachedMap;
    private Map<Integer, PDGlyphs> cachedGlyphs = new HashMap<Integer, PDGlyphs>();

    public PDFontType0(COSObject object) {
        super(object);
    }

    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Type0;
    }

    protected Encoding createEncoding() {
        CMap map = this.getCMap();
        return new CMapEncoding(map);
    }

    public CMap getCMap() {
        if (this.cachedMap == null) {
            this.cachedMap = (CMap)CMap.META.createFromCos(this.cosGetField(DK_Encoding));
        }
        return this.cachedMap;
    }

    public CIDFont getDescendantFont() {
        COSArray fonts = this.cosGetField(DK_DescendantFonts).asArray();
        if (fonts == null || fonts.size() == 0) {
            return null;
        }
        COSObject font = fonts.get(0);
        return (CIDFont)PDFont.META.createFromCos(font);
    }

    public PDFontDescriptor getFontDescriptor() {
        return this.getDescendantFont().getFontDescriptor();
    }

    public String getFontFamilyName() {
        return this.getDescendantFont().getFontFamilyName();
    }

    public String getFontName() {
        return this.getDescendantFont().getFontName();
    }

    public String getFontNameNormalized() {
        return this.getDescendantFont().getFontNameNormalized();
    }

    public PDFontStyle getFontStyle() {
        return this.getDescendantFont().getFontStyle();
    }

    public String getFontType() {
        return this.getDescendantFont().getFontType();
    }

    public int getGlyphIndex(int cid) {
        return this.getDescendantFont().getGlyphIndex(cid);
    }

    public PDGlyphs getGlyphsEncoded(int codepoint) {
        PDGlyphs glyphs = this.cachedGlyphs.get(codepoint);
        if (glyphs == null) {
            glyphs = new PDGlyphs(this, codepoint);
            this.cachedGlyphs.put(codepoint, glyphs);
        }
        return glyphs;
    }

    public int getGlyphWidthEncoded(int codePoint) {
        int cid = this.getCMap().getDecoded(codePoint);
        if (cid == -1) {
            return 0;
        }
        return this.getDescendantFont().getGlyphWidthCID(cid);
    }

    public PDGlyphs getNextGlyphsEncoded(ByteArrayInputStream is) throws IOException {
        int codepoint = this.getCMap().getNextEncoded(is);
        if (codepoint == -1) {
            return null;
        }
        return this.getGlyphsEncoded(codepoint);
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(PDFont.DK_Encoding, IdentityCMap.CN_Identity_H);
    }

    public void setDescendantFont(CIDFont font) {
        if (font == null) {
            this.cosRemoveField(DK_DescendantFonts);
            return;
        }
        COSArray fonts = this.cosGetField(DK_DescendantFonts).asArray();
        if (fonts == null) {
            fonts = COSArray.create();
            this.cosSetField(DK_DescendantFonts, fonts);
        }
        if (fonts.size() == 0) {
            fonts.add(font.cosGetObject());
        } else {
            fonts.set(0, font.cosGetObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetaClass
    extends PDFont.MetaClass {
        protected MetaClass(Class<?> instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDFontType0(object);
        }
    }
}

