/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.tools.collection.ByteArrayTools;

public class PDFontDescriptorEmbedded
extends PDFontDescriptor {
    public static final COSName DK_Ascent = COSName.constant("Ascent");
    public static final COSName DK_AvgWidth = COSName.constant("AvgWidth");
    public static final COSName DK_CapHeight = COSName.constant("CapHeight");
    public static final COSName DK_CharSet = COSName.constant("CharSet");
    public static final COSName DK_CIDSet = COSName.constant("CIDSet");
    public static final COSName DK_Descent = COSName.constant("Descent");
    public static final COSName DK_FD = COSName.constant("FD");
    public static final COSName DK_Flags = COSName.constant("Flags");
    public static final COSName DK_FontBBox = COSName.constant("FontBBox");
    public static final COSName DK_FontFamily = COSName.constant("FontFamily");
    public static final COSName DK_FontFile = COSName.constant("FontFile");
    public static final COSName DK_FontFile2 = COSName.constant("FontFile2");
    public static final COSName DK_FontFile3 = COSName.constant("FontFile3");
    public static final COSName DK_FontName = COSName.constant("FontName");
    public static final COSName DK_FontStretch = COSName.constant("FontStretch");
    public static final COSName DK_FontWeight = COSName.constant("FontWeight");
    public static final COSName DK_ItalicAngle = COSName.constant("ItalicAngle");
    public static final COSName DK_Lang = COSName.constant("Lang");
    public static final COSName DK_Leading = COSName.constant("Leading");
    public static final COSName DK_Length1 = COSName.constant("Length1");
    public static final COSName DK_Length2 = COSName.constant("Length2");
    public static final COSName DK_Length3 = COSName.constant("Length3");
    public static final COSName DK_MaxWidth = COSName.constant("MaxWidth");
    public static final COSName DK_MissingWidth = COSName.constant("MissingWidth");
    public static final COSName DK_StemH = COSName.constant("StemH");
    public static final COSName DK_StemV = COSName.constant("StemV");
    public static final COSName DK_Style = COSName.constant("Style");
    public static final COSName DK_XHeight = COSName.constant("XHeight");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    protected PDFontDescriptorEmbedded(COSObject object) {
        super(object);
    }

    public COSStream cosGetFontFile() {
        return this.cosGetField(DK_FontFile).asStream();
    }

    public COSStream cosGetFontFile2() {
        return this.cosGetField(DK_FontFile2).asStream();
    }

    public COSStream cosGetFontFile3() {
        return this.cosGetField(DK_FontFile3).asStream();
    }

    public float getAscent() {
        return this.getFieldFixed(DK_Ascent, 0.0f);
    }

    public float getAvgWidth() {
        return this.getFieldFixed(DK_AvgWidth, 0.0f);
    }

    public float getCapHeight() {
        return this.getFieldFixed(DK_CapHeight, 0.0f);
    }

    public String getCharSet() {
        return this.getFieldString(DK_CharSet, null);
    }

    public float getDescent() {
        return this.getFieldFixed(DK_Descent, 0.0f);
    }

    public int getFlagsValue() {
        return this.getFieldInt(DK_Flags, 0);
    }

    public CDSRectangle getFontBB() {
        COSArray array = this.cosGetField(DK_FontBBox).asArray();
        if (array == null) {
            return null;
        }
        return CDSRectangle.createFromCOS(array);
    }

    public String getFontFamily() {
        COSString ff = this.cosGetField(DK_FontFamily).asString();
        return ff == null ? null : ff.stringValue();
    }

    public byte[] getFontFile() {
        COSStream stream = this.cosGetField(DK_FontFile).asStream();
        if (stream == null) {
            return null;
        }
        return stream.getDecodedBytes();
    }

    public byte[] getFontFile2() {
        COSStream stream = this.cosGetField(DK_FontFile2).asStream();
        if (stream == null) {
            return null;
        }
        return stream.getDecodedBytes();
    }

    public byte[] getFontFile3() {
        COSStream stream = this.cosGetField(DK_FontFile3).asStream();
        if (stream == null) {
            return null;
        }
        return stream.getDecodedBytes();
    }

    public String getFontName() {
        COSName fn = this.cosGetField(DK_FontName).asName();
        return fn == null ? null : fn.stringValue();
    }

    public String getFontStretch() {
        return this.getFieldString(DK_FontStretch, null);
    }

    public int getFontWeight() {
        return this.getFieldInt(DK_FontWeight, 400);
    }

    public float getItalicAngle() {
        return this.getFieldFixed(DK_ItalicAngle, 0.0f);
    }

    public int getLeading() {
        return this.getFieldInt(DK_Leading, 0);
    }

    public int getMaxWidth() {
        return this.getFieldInt(DK_MaxWidth, 0);
    }

    public int getMissingWidth() {
        return this.getFieldInt(DK_MissingWidth, 0);
    }

    public int getStemH() {
        return this.getFieldInt(DK_StemH, 0);
    }

    public int getStemV() {
        return this.getFieldInt(DK_StemV, 0);
    }

    public float getXHeight() {
        return this.getFieldInt(DK_XHeight, 0);
    }

    public void removeFontFile2() {
        this.cosGetDict().remove(DK_FontFile2);
    }

    public void setAscent(int value) {
        this.setFieldInt(DK_Ascent, value);
    }

    public void setAvgWidth(int value) {
        this.setFieldInt(DK_AvgWidth, value);
    }

    public void setCapHeight(int value) {
        this.setFieldInt(DK_CapHeight, value);
    }

    public void setCharSet(String charset) {
        this.setFieldString(DK_CharSet, charset);
    }

    public void setDescent(int value) {
        this.setFieldInt(DK_Descent, value);
    }

    public void setFlags(int value) {
        this.setFieldInt(DK_Flags, value);
    }

    public void setFlagsValue(int value) {
        this.setFieldInt(DK_Flags, value);
    }

    public void setFontBB(CDSRectangle rect) {
        this.setFieldObject(DK_FontBBox, rect);
    }

    public void setFontFamily(String value) {
        this.setFieldName(DK_FontFamily, value);
    }

    public void setFontFile(byte[] data) {
        COSStream cosStream = COSStream.create(null);
        this.setLengths(cosStream, data);
        cosStream.setDecodedBytes(data);
        cosStream.addFilter(Filter.CN_Filter_FlateDecode);
        this.cosSetField(DK_FontFile, cosStream);
    }

    public void setFontFile2(byte[] data) {
        COSStream cosStream = COSStream.create(null);
        cosStream.getDict().put(DK_Length1, COSInteger.create(data.length));
        cosStream.addFilter(Filter.CN_Filter_FlateDecode);
        cosStream.setDecodedBytes(data);
        this.cosSetField(DK_FontFile2, cosStream);
    }

    public void setFontFile3(byte[] data) {
        COSStream cosStream = COSStream.create(null);
        cosStream.setDecodedBytes(data);
        this.cosSetField(DK_FontFile3, cosStream);
    }

    public void setFontName(String value) {
        this.setFieldName(DK_FontName, value);
    }

    public void setFontStretch(String stretch) {
        this.setFieldString(DK_FontStretch, stretch);
    }

    public void setFontWeight(int weight) {
        this.setFieldInt(DK_FontWeight, weight);
    }

    public void setItalicAngle(float value) {
        this.setFieldFixed(DK_ItalicAngle, value);
    }

    public void setLeading(int value) {
        this.setFieldInt(DK_Leading, value);
    }

    protected void setLengths(COSStream cosStream, byte[] data) {
        int index2;
        int length1 = 0;
        int length2 = 0;
        int length3 = 0;
        byte[] pattern = "currentfile eexec".getBytes();
        int index1 = ByteArrayTools.indexOf((byte[])data, (int)0, (int)data.length, (byte[])pattern, (int)0, (int)pattern.length, (int)0);
        if (index1 != -1) {
            length1 = index1 + pattern.length;
        }
        if ((index2 = ByteArrayTools.indexOf((byte[])data, (int)0, (int)data.length, (byte[])(pattern = "0000000000000000000000000000000000000000000000000000000000000000".getBytes()), (int)0, (int)pattern.length, (int)0)) == -1) {
            length2 = data.length - length1;
        } else {
            length2 = index2 - length1;
            length3 = data.length - index2;
        }
        cosStream.getDict().put(DK_Length1, COSInteger.create(length1));
        cosStream.getDict().put(DK_Length2, COSInteger.create(length2));
        cosStream.getDict().put(DK_Length3, COSInteger.create(length3));
    }

    public void setMaxWidth(int value) {
        this.setFieldInt(DK_MaxWidth, value);
    }

    public void setMissingWidth(int value) {
        this.setFieldInt(DK_MissingWidth, value);
    }

    public void setStemH(int value) {
        this.setFieldInt(DK_StemH, value);
    }

    public void setStemV(int value) {
        this.setFieldInt(DK_StemV, value);
    }

    public void setXHeight(int value) {
        this.setFieldInt(DK_XHeight, value);
    }

    public static class MetaClass
    extends PDFontDescriptor.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDFontDescriptorEmbedded(object);
        }
    }
}

