/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.CIDWidthMapEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CIDWidthMap
extends COSBasedObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private List entries;

    protected CIDWidthMap(COSObject object) {
        super(object);
    }

    public void addWidth(int cid, int width) {
        this.entries.add(new CIDWidthMapEntry(cid, cid, width));
        this.cosGetArray().add(COSInteger.create(cid));
        this.cosGetArray().add(COSInteger.create(cid));
        this.cosGetArray().add(COSInteger.create(width));
    }

    protected void createMap(COSArray array) {
        this.entries = new ArrayList();
        if (array != null) {
            Iterator itMap = array.iterator();
            while (itMap.hasNext()) {
                int start;
                COSNumber element1 = ((COSObject)itMap.next()).asNumber();
                if (element1 == null || !itMap.hasNext()) break;
                COSObject element2 = (COSObject)itMap.next();
                int stop = start = element1.intValue();
                if (element2 instanceof COSNumber) {
                    stop = ((COSNumber)element2).intValue();
                    if (!itMap.hasNext()) break;
                    COSObject element3 = (COSObject)itMap.next();
                    int width = ((COSNumber)element3).intValue();
                    this.entries.add(new CIDWidthMapEntry(start, stop, width));
                    continue;
                }
                if (!(element2 instanceof COSArray)) continue;
                COSArray widths = (COSArray)element2;
                Iterator itWidths = widths.iterator();
                while (itWidths.hasNext()) {
                    COSNumber widthObject = ((COSObject)itWidths.next()).asNumber();
                    int width = 0;
                    if (widthObject != null) {
                        width = widthObject.intValue();
                    }
                    this.entries.add(new CIDWidthMapEntry(start, stop, width));
                    ++start;
                    ++stop;
                }
            }
        }
    }

    public int getWidth(int cid) {
        for (CIDWidthMapEntry entry : this.entries) {
            if (entry.getStart() > cid || entry.getStop() < cid) continue;
            return entry.getWidth();
        }
        return -1;
    }

    protected void initializeFromCos() {
        super.initializeFromCos();
        this.createMap(this.cosGetArray());
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.entries = new ArrayList();
    }

    public static class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new CIDWidthMap(object);
        }

        protected COSObject doCreateCOSObject() {
            return COSArray.create();
        }
    }
}

