/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.filter.PNGPrediction;

public class PNGPaethPrediction
extends PNGPrediction {
    public PNGPaethPrediction(COSDictionary options) {
        super(options);
    }

    public void decodeRow(byte[] source, int sourceOffset, byte[] result, int resultOffset) {
        int upperLeft;
        int above;
        int left;
        int raw;
        int colors = this.getColors();
        if (this.getBitsPerComponent() != 8) {
            return;
        }
        if (++sourceOffset == 1) {
            int c = 0;
            while (c < colors) {
                result[resultOffset + c] = source[sourceOffset + c];
                ++c;
            }
            int x = 1;
            while (x < this.getResultRowSize()) {
                int raw2 = source[sourceOffset + x] & 0xFF;
                int left2 = result[resultOffset + x - colors] & 0xFF;
                int above2 = 0;
                int upperLeft2 = 0;
                result[resultOffset + x] = (byte)(raw2 + this.paethPredictor(left2, above2, upperLeft2) & 0xFF);
                ++x;
            }
            return;
        }
        int c = 0;
        while (c < colors) {
            raw = source[sourceOffset + c] & 0xFF;
            left = 0;
            above = result[resultOffset + c - this.getResultRowSize()] & 0xFF;
            upperLeft = 0;
            result[resultOffset + c] = (byte)(raw + this.paethPredictor(left, above, upperLeft) & 0xFF);
            ++c;
        }
        int x = 1;
        while (x < this.getResultRowSize()) {
            raw = source[sourceOffset + x] & 0xFF;
            left = result[resultOffset + x - colors] & 0xFF;
            above = result[resultOffset + x - this.getResultRowSize()] & 0xFF;
            upperLeft = result[resultOffset + x - this.getResultRowSize() - colors] & 0xFF;
            result[resultOffset + x] = (byte)(raw + this.paethPredictor(left, above, upperLeft) & 0xFF);
            ++x;
        }
    }

    private int paethPredictor(int left, int above, int upperLeft) {
        int p = left + above - upperLeft;
        int pa = Math.abs(p - left);
        int pb = Math.abs(p - above);
        int pc = Math.abs(p - upperLeft);
        if (pa <= pb && pa <= pc) {
            return left;
        }
        if (pb <= pc) {
            return above;
        }
        return upperLeft;
    }
}

