/*
 * Decompiled with CFR 0.152.
 */
package splmm.Validator;

import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import splmm.SciPloreUtils;

public class XmlValidator {
    public static boolean validate(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", "freemind.xsd");
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        Document doc = null;
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            XmlErrorHandler errorHandler = new XmlErrorHandler();
            parser.setErrorHandler(errorHandler);
            String newXml = SciPloreUtils.encodeToUnicodeStandard(xml);
            doc = parser.parse(new InputSource(new StringReader(newXml)));
        }
        catch (ParserConfigurationException e) {
            SciPloreUtils.logException(XmlErrorHandler.class.getName(), e, Level.ALL);
            return false;
        }
        catch (SAXException e) {
            return false;
        }
        catch (IOException e) {
            SciPloreUtils.logException(XmlErrorHandler.class.getName(), e, Level.ALL);
            return false;
        }
        return true;
    }

    static class XmlErrorHandler
    implements ErrorHandler {
        XmlErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            System.out.println("Fatal XML Error:" + e.toString());
            SciPloreUtils.logException(XmlErrorHandler.class.getName(), e, Level.ALL);
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            System.out.println("XML Error: " + e.toString());
            SciPloreUtils.logException(XmlErrorHandler.class.getName(), e, Level.WARNING);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            System.out.println("XML Warning: " + e.toString());
        }
    }
}

