/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.NodeAdapter;
import java.util.Date;

public class SplmmAttributes {
    public static final String XML_NODE_BOOKMARKS_UPDATED = "BOOKMARKS_UPDATED";
    public static final String XML_NODE_LINK_TYPE = "LINK_TYPE";
    private Long bookmarksUpdated;
    private LinkType linkType;

    public Date getBookmarksUpdated() {
        if (this.bookmarksUpdated != null) {
            return new Date(this.bookmarksUpdated);
        }
        return null;
    }

    public void setBookmarksUpdated(Date date) {
        this.bookmarksUpdated = date.getTime();
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(LinkType linkType) {
        this.linkType = linkType;
    }

    public void saveToXML(XMLElement node) {
        if (this.getBookmarksUpdated() != null) {
            node.setAttribute(XML_NODE_BOOKMARKS_UPDATED, Tools.dateToString(this.getBookmarksUpdated()));
        }
        if (this.linkType != null) {
            node.setAttribute(XML_NODE_LINK_TYPE, this.linkType.toString());
        }
    }

    public static Boolean loadFromXML(String name, String sValue, NodeAdapter node) {
        if (name.equals(XML_NODE_BOOKMARKS_UPDATED)) {
            if (node.getSPLMMAttributes() == null) {
                node.setSPLMMAttributes(new SplmmAttributes());
            }
            node.getSPLMMAttributes().setBookmarksUpdated(Tools.xmlToDate(sValue));
            return true;
        }
        if (name.equals(XML_NODE_LINK_TYPE)) {
            if (node.getSPLMMAttributes() == null) {
                node.setSPLMMAttributes(new SplmmAttributes());
            }
            if (sValue.equals(LinkType.bookmark.toString())) {
                node.getSPLMMAttributes().setLinkType(LinkType.bookmark);
                return true;
            }
            if (sValue.equals(LinkType.comment.toString())) {
                node.getSPLMMAttributes().setLinkType(LinkType.comment);
                return true;
            }
            if (sValue.equals(LinkType.highlightedtext.toString())) {
                node.getSPLMMAttributes().setLinkType(LinkType.highlightedtext);
                return true;
            }
            if (sValue.equals(LinkType.document.toString())) {
                node.getSPLMMAttributes().setLinkType(LinkType.document);
                return true;
            }
            return true;
        }
        return false;
    }

    public static enum LinkType {
        bookmark,
        comment,
        highlightedtext,
        document;

    }
}

