/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXB;
import org.jetbrains.annotations.NonNls;
import org.sciplore.xml.XmlApplication;
import splmm.Gui.Transferable.TitleLinkPair;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.Preferences.UserDataState;
import splmm.SciPloreUtils;

@NonNls
public class SciPloreWebClient {
    private static Client CLIENT = Client.create();
    private static Client RECOMMENDATION_CLIENT;
    private static Date lastRecommendationsShown;
    private static WebResource RECOMMENDATION_WEBRESOURCE;
    private static WebResource WEBRESOURCE;
    private static final String PASSWORD = "password";
    private static final String USER_NAME = "userName";
    private static final String ALLOW_IR = "allowIR";
    private static final String BACKUP = "backup";
    private static final String REC = "rec";
    private static final String MIND_MAP = "mindMap";
    private static final String USER_TYPE = "userType";
    private static final String ANONYMOUS_USER_TYPE = "3";
    private static final String FILENAME = "filename";

    public static String postMindMap(String mindmap, String fileName) {
        try {
            byte[] data = SciPloreUtils.zip(mindmap);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.field(MIND_MAP, (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            String username = SciPloreWebClient.getUserName();
            if (username == null) {
                return null;
            }
            formDataMultiPart.field(USER_NAME, username);
            formDataMultiPart.field(ALLOW_IR, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonMM()));
            formDataMultiPart.field(BACKUP, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowBackup()));
            formDataMultiPart.field(REC, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowRecommendations()));
            formDataMultiPart.field(FILENAME, fileName);
            if (UserDataState.getCurrentState() == 1) {
                formDataMultiPart.field(PASSWORD, (Object)SplmmPreferences.getPassword(), MediaType.TEXT_PLAIN_TYPE);
            }
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user/" + username + "/mindmaps").type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, (Object)formDataMultiPart);
            String mindmapID = (String)response.getEntity(String.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && mindmapID.matches("[\\w]{8}-[\\w]{4}-[\\w]{4}-[\\w]{4}-[\\w]{12}")) {
                return mindmapID;
            }
            if (response.getClientResponseStatus() == ClientResponse.Status.UNAUTHORIZED && UserDataState.getCurrentState() == 1) {
                SciPloreWebClient.validateUserData(SciPloreWebClient.getUserName(), SplmmPreferences.getPassword());
            }
        }
        catch (ClientHandlerException e) {
            String msg = "Could not post Mindmap: filename: " + fileName + "; Username: " + SplmmPreferences.getUserName() + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
        }
        return null;
    }

    public static void putMindMap(String mindmap, String mindmapID, String fileName) {
        if (SplmmPreferences.getUserName() == null || SplmmPreferences.getUserName().isEmpty() || SplmmPreferences.getUserName().equalsIgnoreCase(LocalizationSupport.message("anonymous"))) {
            return;
        }
        try {
            byte[] data = SciPloreUtils.zip(mindmap);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.field(MIND_MAP, (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            String username = SciPloreWebClient.getUserName();
            if (username == null) {
                return;
            }
            formDataMultiPart.field(USER_NAME, username);
            formDataMultiPart.field(ALLOW_IR, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonMM()));
            formDataMultiPart.field(BACKUP, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowBackup()));
            formDataMultiPart.field(REC, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowRecommendations()));
            formDataMultiPart.field(FILENAME, fileName);
            if (UserDataState.getCurrentState() == 1) {
                formDataMultiPart.field(PASSWORD, (Object)SplmmPreferences.getPassword(), MediaType.TEXT_PLAIN_TYPE);
            }
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user/" + username + "/mindmaps/" + mindmapID).type(MediaType.MULTIPART_FORM_DATA_TYPE).put(ClientResponse.class, (Object)formDataMultiPart);
            String string = (String)response.getEntity(String.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.UNAUTHORIZED && UserDataState.getCurrentState() == 1) {
                SciPloreWebClient.validateUserData(SciPloreWebClient.getUserName(), SplmmPreferences.getPassword());
            }
        }
        catch (ClientHandlerException e) {
            String msg = "Could not put Mindmap: filename: " + fileName + "; Username: " + SplmmPreferences.getUserName() + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
        }
    }

    public static ValidationState validateUserData(String username, String password) {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)USER_NAME, (Object)username);
        formParams.add((Object)PASSWORD, (Object)password);
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user").put(ClientResponse.class, (Object)formParams);
            switch (response.getClientResponseStatus()) {
                case BAD_REQUEST: {
                    JOptionPane.showMessageDialog(null, LocalizationSupport.message("user.name.is.not.allowed.to.be.empty"), LocalizationSupport.message("error"), 0);
                    return ValidationState.NOT_VALID;
                }
                case UNAUTHORIZED: {
                    JOptionPane.showMessageDialog(null, LocalizationSupport.message("user.name.or.password.wrong"), LocalizationSupport.message("error"), 0);
                    return ValidationState.NOT_VALID;
                }
                case OK: {
                    username = (String)response.getEntity(String.class);
                    SplmmPreferences.setCredentialsValidated(true);
                    return ValidationState.VALID;
                }
            }
            return ValidationState.EXCEPTION;
        }
        catch (ClientHandlerException e) {
            String msg = "Could not validate Userdata:  Username: " + username + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
            if (SciPloreWebClient.isInternetReachable()) {
                return ValidationState.SERVICE_DOWN;
            }
            return ValidationState.CONNECTION_PROBLEM;
        }
    }

    public static Boolean createAnonymousUser(String username) {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)USER_NAME, (Object)username);
        formParams.add((Object)USER_TYPE, (Object)ANONYMOUS_USER_TYPE);
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user/" + username).post(ClientResponse.class, (Object)formParams);
            ClientResponse.Status status = response.getClientResponseStatus();
            if (status != null) {
                switch (status) {
                    case BAD_REQUEST: {
                        return false;
                    }
                    case OK: {
                        SplmmPreferences.setCredentialsValidated(true);
                        return true;
                    }
                }
                return true;
            }
            return false;
        }
        catch (ClientHandlerException e) {
            String msg = "Could not create Anonymous User: Username: " + username + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
            return true;
        }
    }

    public static XmlApplication checkVersion() {
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/versioncheck/" + SciPloreUtils.APP_ID + "/current").get(ClientResponse.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && response.hasEntity()) {
                String entity = (String)response.getEntity(String.class);
                byte[] bytes = entity.getBytes();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                if (is != null) {
                    XmlApplication app = (XmlApplication)JAXB.unmarshal((InputStream)is, XmlApplication.class);
                    System.out.println(app.getName() + " " + app.getVersion() + " " + app.getReleaseNote() + " " + app.getVersionStatusAsString() + "\n\n");
                    return app;
                }
                return null;
            }
        }
        catch (Exception e) {
            String msg = "Could not check Version: Application ID: " + SciPloreUtils.APP_ID + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
        }
        return null;
    }

    public static List<TitleLinkPair> getRecommendations(String searchValue) {
        try {
            Date now = new Date();
            if (lastRecommendationsShown != null && now.getTime() - lastRecommendationsShown.getTime() < 3000L || SciPloreUtils.MonDirReadingActive || !SciPloreUtils.RecommenderVisible) {
                return new ArrayList<TitleLinkPair>();
            }
            lastRecommendationsShown = now;
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"keyword", (Object)searchValue);
            queryParams.add((Object)"limit", (Object)"20");
            List response = (List)RECOMMENDATION_WEBRESOURCE.path("search").queryParams((MultivaluedMap)queryParams).get((GenericType)new GenericType<List<TitleLinkPair>>(){});
            return response;
        }
        catch (Exception e) {
            String msg = "Could not get Recommendations...";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
            return null;
        }
    }

    public static boolean sendEvent(short event, String eventData) {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)"version", (Object)SciPloreUtils.APP_VERSION_SHORT);
        String username = SciPloreWebClient.getUserName();
        if (username != null) {
            formParams.add((Object)"username", (Object)username);
        } else {
            SplmmPreferences.createUUID();
            username = SplmmPreferences.getAnonymousUserName();
            if (username != null) {
                formParams.add((Object)"username", (Object)username);
            } else {
                return false;
            }
        }
        formParams.add((Object)"eventdata", (Object)eventData);
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/stats/usage/" + SciPloreUtils.APP_ID + "/" + event).post(ClientResponse.class, (Object)formParams);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
                return true;
            }
            String msg = "Could not send Event: Application ID: " + SciPloreUtils.APP_ID + "; Event ID: " + event + "; Username: " + SplmmPreferences.getUserName() + "; Event Data: " + eventData + "; ";
            return false;
        }
        catch (ClientHandlerException e) {
            String msg = "Could not send Event: Application ID: " + SciPloreUtils.APP_ID + "; Event ID: " + event + "; Username: " + SplmmPreferences.getUserName() + "; Event Data: " + eventData + "; ";
            return false;
        }
    }

    public static Integer sendRecommenderEvent(short event, String eventData, int splmmRank, String keyword, TitleLinkPair titleLinkPair) {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)"version", (Object)SciPloreUtils.APP_VERSION_SHORT);
        String username = SciPloreWebClient.getUserName();
        if (username != null) {
            formParams.add((Object)"username", (Object)username);
        } else {
            SplmmPreferences.createUUID();
            username = SplmmPreferences.getAnonymousUserName();
            if (username != null) {
                formParams.add((Object)"username", (Object)username);
            } else {
                return null;
            }
        }
        formParams.add((Object)"eventdata", (Object)eventData);
        formParams.add((Object)"source", (Object)titleLinkPair.getSource().toString());
        formParams.add((Object)"algorithm", (Object)titleLinkPair.getAlgorithm().toString());
        formParams.add((Object)"originalRank", (Object)titleLinkPair.getOriginal_rank().toString());
        formParams.add((Object)"splmmRank", (Object)("" + splmmRank));
        formParams.add((Object)"title", (Object)titleLinkPair.getTitle());
        formParams.add((Object)"keyword", (Object)keyword);
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/stats/usage/" + SciPloreUtils.APP_ID + "/" + event).post(ClientResponse.class, (Object)formParams);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
                String id = (String)response.getEntity(String.class);
                try {
                    return Integer.parseInt(id);
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
            String msg = "Could not send Event: Application ID: " + SciPloreUtils.APP_ID + "; Event ID: " + event + "; Username: " + SplmmPreferences.getUserName() + "; Event Data: " + eventData + "; ";
            return null;
        }
        catch (ClientHandlerException e) {
            String msg = "Could not send Event: Application ID: " + SciPloreUtils.APP_ID + "; Event ID: " + event + "; Username: " + SplmmPreferences.getUserName() + "; Event Data: " + eventData + "; ";
            return null;
        }
    }

    public static boolean isWebServiceOutDated() {
        try {
            XmlApplication app;
            String entity;
            byte[] bytes;
            ByteArrayInputStream is;
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/versioncheck/" + SciPloreUtils.WEBSERVICE_APP_ID + "/current").get(ClientResponse.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && response.hasEntity() && (is = new ByteArrayInputStream(bytes = (entity = (String)response.getEntity(String.class)).getBytes())) != null && (app = (XmlApplication)JAXB.unmarshal((InputStream)is, XmlApplication.class)) != null && app.getVersion() != null && !app.getVersion().equalsIgnoreCase(SciPloreUtils.WEBSERVICE_VERSION_SHORT)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isInternetReachable() {
        try {
            URL url = new URL("http://www.google.com");
            HttpURLConnection urlConnect = (HttpURLConnection)url.openConnection();
            urlConnect.setConnectTimeout(1000);
            Object object = urlConnect.getContent();
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static String getUserName() {
        switch (UserDataState.getCurrentState()) {
            case 1: {
                if (SplmmPreferences.getUserName() == null || SplmmPreferences.getUserName().isEmpty() || SplmmPreferences.getUserName().equalsIgnoreCase(LocalizationSupport.message("anonymous"))) {
                    return null;
                }
                return SplmmPreferences.getUserName();
            }
            case 2: {
                if (SplmmPreferences.getAnonymousUserName() == null || SplmmPreferences.getAnonymousUserName().isEmpty() || SplmmPreferences.getAnonymousUserName().equalsIgnoreCase(LocalizationSupport.message("anonymous"))) {
                    return null;
                }
                return SplmmPreferences.getAnonymousUserName();
            }
        }
        return null;
    }

    static {
        CLIENT.setConnectTimeout(Integer.valueOf(1000));
        CLIENT.setReadTimeout(Integer.valueOf(7000));
        RECOMMENDATION_CLIENT = Client.create();
        CLIENT.setConnectTimeout(Integer.valueOf(10000));
        CLIENT.setReadTimeout(Integer.valueOf(70000));
        lastRecommendationsShown = new Date();
        RECOMMENDATION_WEBRESOURCE = RECOMMENDATION_CLIENT.resource("http://api.sciplore.org/rest/");
        WEBRESOURCE = CLIENT.resource("http://api.sciplore.org/rest/");
    }

    public static enum ValidationState {
        VALID,
        NOT_VALID,
        EXCEPTION,
        CONNECTION_PROBLEM,
        SERVICE_DOWN;

    }
}

