/*
 * Decompiled with CFR 0.152.
 */
package splmm.Listeners;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnyAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutlineItem;
import de.intarsys.pdf.pd.PDOutlineNode;
import de.intarsys.pdf.pd.PDTextAnnotation;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.NodeView;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import splmm.BookmarkMindMapNode;
import splmm.FileFilter.PdfFileFilter;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;

public class SplmmNodeSelectionListener
implements ModeController.NodeSelectionListener {
    private MindMapController controller;
    private String oldNodeText;

    public SplmmNodeSelectionListener(MindMapController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdateNodeHook(MindMapNode node) {
        if (node instanceof BookmarkMindMapNode) {
            BookmarkMindMapNode bookmarkMindMapNode = (BookmarkMindMapNode)node;
            bookmarkMindMapNode.setName(node.getText());
        }
        if (SciPloreUtils.MonDirReadingActive || !SplmmPreferences.getRenameBookmarks() && !SplmmPreferences.getRenameComments()) {
            return;
        }
        if (SciPloreUtils.getLink(node, this.controller.getController()) != null && !SciPloreUtils.getLink(node, this.controller.getController()).isEmpty()) {
            String link = SciPloreUtils.getLink(node, this.controller.getController());
            File file = SciPloreUtils.getFileFromLink(link);
            PdfFileFilter pdfFileFilter = new PdfFileFilter();
            if (file != null && file.exists() && pdfFileFilter.accept(file)) {
                PDDocument document = null;
                try {
                    FileLocator locator = new FileLocator(file.getPath());
                    document = PDDocument.createFromLocator((ILocator)locator);
                    PDOutline object = document.getOutline();
                    if (object instanceof PDOutline) {
                        List annotations;
                        PDAnnotation annotation;
                        PDOutline outline;
                        PDOutlineItem bookmark;
                        if (SplmmPreferences.getRenameBookmarks() && (bookmark = this.searchBookmark((PDOutlineNode)(outline = object))) != null) {
                            bookmark.setTitle(node.getText());
                            document.save();
                            return;
                        }
                        if (SplmmPreferences.getRenameComments() && (annotation = this.searchComment(annotations = document.getAnnotations())) != null) {
                            annotation.setContents(node.getText());
                            document.save();
                            return;
                        }
                    }
                }
                catch (COSLoadException e) {
                    SciPloreUtils.log(this.getClass().getName(), "Could not manipulate PDF because of COSLoadException:" + file.getName(), Level.WARNING);
                }
                catch (IOException e) {
                    SciPloreUtils.log(this.getClass().getName(), "Could not manipulate PDF because of IOException:" + file.getName(), Level.WARNING);
                }
                finally {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (IOException e) {
                            SciPloreUtils.log(this.getClass().getName(), "Could not close PDF because of IOException:" + file.getName(), Level.WARNING);
                        }
                    }
                }
            }
        }
    }

    private PDAnnotation searchComment(List<PDAnnotation> annotations) {
        String lastAnnotationContent = "";
        for (PDAnnotation annotation : annotations) {
            if (annotation == null || annotation.getContents() == null || annotation.getContents().isEmpty() || annotation.getContents().equals(lastAnnotationContent)) continue;
            lastAnnotationContent = annotation.getContents();
            if (annotation.getPage() != null) {
                if (annotation.getPage().getMediaBox() == null || annotation.getRectangle() == null) continue;
                CDSRectangle page_rec = annotation.getPage().getMediaBox();
                CDSRectangle anno_rec = annotation.getRectangle();
                if (anno_rec.getLowerLeftX() > page_rec.getUpperRightX() || anno_rec.getLowerLeftY() > page_rec.getUpperRightY() || anno_rec.getUpperRightX() < page_rec.getLowerLeftX() || anno_rec.getUpperRightY() < page_rec.getLowerLeftY()) continue;
            }
            if (annotation.getClass() != PDAnyAnnotation.class && annotation.getClass() != PDTextAnnotation.class || annotation.getContents().compareTo(this.oldNodeText) != 0) continue;
            return annotation;
        }
        return null;
    }

    private PDOutlineItem searchBookmark(PDOutlineNode parent) {
        List children = parent.getChildren();
        for (PDOutlineItem child : children) {
            if (child.getTitle().compareTo(this.oldNodeText) == 0) {
                return child;
            }
            PDOutlineItem result = this.searchBookmark((PDOutlineNode)child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void onSelectHook(NodeView node) {
        this.oldNodeText = node.getText();
        this.controller.UpdateMonitoringActions();
        this.controller.UpdateImportActions();
        this.controller.UpdateReferenceActions();
    }

    @Override
    public void onDeselectHook(NodeView node) {
    }

    @Override
    public void onSaveNode(MindMapNode node) {
    }
}

