/*
 * Decompiled with CFR 0.152.
 */
package splmm.Listeners;

import freemind.modes.MindMapNode;
import freemind.view.mindmapview.NodeView;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import splmm.Gui.MonDirJTree;
import splmm.SciPloreUtils;

public class NodeListener
extends NodeView {
    private MonDirJTree tree;

    public NodeListener(MonDirJTree tree) {
        this.tree = tree;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        MindMapNode root = (MindMapNode)model.getRoot();
        List children = root.getChildren();
        for (MindMapNode child : children) {
            TreePath childPath = child.getPath();
            if (!childPath.isDescendant(treeModelEvent.getTreePath())) continue;
            TreeModelEvent newEvent = this.getTreeModelEvent(treeModelEvent);
            for (TreeModelListener listener : model.getTreeModelListeners()) {
                listener.treeNodesChanged(newEvent);
            }
            this.tree.updatePath();
            return;
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        MindMapNode root = (MindMapNode)model.getRoot();
        List children = root.getChildren();
        for (MindMapNode child : children) {
            TreePath childPath = child.getPath();
            if (!childPath.isDescendant(treeModelEvent.getTreePath())) continue;
            TreeModelEvent newEvent = this.getTreeModelEvent(treeModelEvent);
            for (TreeModelListener listener : model.getTreeModelListeners()) {
                listener.treeNodesInserted(newEvent);
            }
            this.tree.updatePath();
            return;
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        MindMapNode root = (MindMapNode)model.getRoot();
        List children = root.getChildren();
        for (MindMapNode child : children) {
            TreePath childPath = child.getPath();
            if (!childPath.isDescendant(treeModelEvent.getTreePath())) continue;
            TreeModelEvent newEvent = this.getTreeModelEvent(treeModelEvent);
            for (TreeModelListener listener : model.getTreeModelListeners()) {
                listener.treeNodesRemoved(newEvent);
            }
            this.tree.updatePath();
            return;
        }
        for (Object child : treeModelEvent.getChildren()) {
            if (!SciPloreUtils.isMonitoringNode((MindMapNode)child)) continue;
            root.remove((MindMapNode)child);
            this.tree.updateUI();
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        MindMapNode root = (MindMapNode)model.getRoot();
        List children = root.getChildren();
        for (MindMapNode child : children) {
            TreePath childPath = child.getPath();
            if (!childPath.isDescendant(treeModelEvent.getTreePath())) continue;
            TreeModelEvent newEvent = this.getTreeModelEvent(treeModelEvent);
            for (TreeModelListener listener : model.getTreeModelListeners()) {
                listener.treeStructureChanged(newEvent);
            }
            this.tree.updatePath();
            return;
        }
    }

    private TreeModelEvent getTreeModelEvent(TreeModelEvent treeModelEvent) {
        TreePath eventPath = this.tree.getPath((MindMapNode)treeModelEvent.getTreePath().getLastPathComponent());
        Object[] children = this.tree.getChildren(eventPath, treeModelEvent.getChildren());
        int[] childIndices = this.tree.getChildIndices(eventPath, children);
        return new TreeModelEvent(treeModelEvent.getSource(), eventPath, childIndices, children);
    }
}

