/*
 * Decompiled with CFR 0.152.
 */
package splmm.Gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import freemind.controller.Controller;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import splmm.Gui.RecommenderPanel;
import splmm.Gui.VerticalButton;
import splmm.Gui.WatchFolderPanel;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public class SplmmToolbar
extends JPanel {
    private VerticalButton buttonShow;
    private Controller controller;
    private boolean isShown = false;
    private WatchFolderPanel watchFolderPanel;
    private RecommenderPanel recommenderPanel;

    public SplmmToolbar(Controller controller) {
        this.init();
        this.controller = controller;
        this.buttonShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplmmToolbar.this.onShow();
            }
        });
    }

    public void onShow() {
        if (this.isShown) {
            if (this.controller.getRecommendationBar() != null) {
                this.controller.getRecommendationBar().unregisterTreeListener(this.watchFolderPanel.getTree());
            }
            this.controller.getFrame().removeHorizontalSplitPane();
            this.recommenderPanel = null;
            this.watchFolderPanel = null;
            if (this.controller.getModeController() != null) {
                this.controller.getModeController().deregisterNodeSelectionListener(SciPloreUtils.NewMonDirButtonListener);
                this.controller.getModeController().deregisterNodeSelectionListener(SciPloreUtils.MonDirNodeSelectionListener);
            }
        } else {
            SciPloreUtils.RecommenderVisible = true;
            this.watchFolderPanel = new WatchFolderPanel(this.controller.getModeController());
            this.recommenderPanel = new RecommenderPanel(this.controller);
            this.recommenderPanel.getPanelMain().add((Component)this.watchFolderPanel, "Center");
            this.controller.getFrame().insertComponentIntoHorizontalSplitPane(this.recommenderPanel);
            if (this.controller.getRecommendationBar() != null) {
                this.controller.getRecommendationBar().registerTreeListener(this.watchFolderPanel.getTree());
            }
        }
        this.isShown = !this.isShown;
        new EventSenderThread(SciPloreUtils.EVENT_INCOMING_WINDOW_SHOWN, "" + SciPloreUtils.parseBoolean(this.isShown));
    }

    public void hideToolbar() {
        this.setVisible(false);
        this.controller.getFrame().removeHorizontalSplitPane();
        this.recommenderPanel = null;
        this.watchFolderPanel = null;
    }

    public void showToolbar() {
        this.setVisible(true);
        if (this.isShown) {
            this.watchFolderPanel = new WatchFolderPanel(this.controller.getModeController());
            this.recommenderPanel = new RecommenderPanel(this.controller);
            this.recommenderPanel.getPanelMain().add((Component)this.watchFolderPanel, "Center");
            this.controller.getFrame().insertComponentIntoHorizontalSplitPane(this.recommenderPanel);
        }
    }

    public WatchFolderPanel getWatchFolderPanel() {
        return this.watchFolderPanel;
    }

    private void init() {
        this.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.add((Component)panel5, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.buttonShow = new VerticalButton("Incoming Folders", true);
        panel5.add((Component)this.buttonShow, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null, 0, false));
    }

    public void update() {
        if (this.watchFolderPanel != null) {
            this.watchFolderPanel.update(this.controller.getModeController());
        }
        if (this.recommenderPanel != null) {
            this.recommenderPanel.update(this.controller);
        }
    }
}

