/*
 * Decompiled with CFR 0.152.
 */
package splmm.Gui;

import freemind.controller.Controller;
import freemind.modes.MindMapNode;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import splmm.Gui.Transferable.NodeTransferable;
import splmm.SciPloreUtils;

public class MonDirJTree
extends JTree
implements DragSourceListener,
DragGestureListener {
    List<MouseListener> standardMouseListeners = new ArrayList<MouseListener>();
    DragGestureRecognizer recognizer;
    MouseEvent mouseEvent;
    boolean isSingleClickInSelection = false;
    private Controller controller;

    public MonDirJTree(Controller controller) {
        this.controller = controller;
        DragSource dragSource = DragSource.getDefaultDragSource();
        this.recognizer = dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(renderer.getLeafIcon());
        renderer.setClosedIcon(renderer.getLeafIcon());
        renderer.setDisabledIcon(renderer.getLeafIcon());
        renderer.setIcon(renderer.getLeafIcon());
        this.setCellRenderer(renderer);
        this.standardMouseListeners = new ArrayList<MouseListener>();
        for (MouseListener mouseListener : this.getMouseListeners()) {
            this.standardMouseListeners.add(mouseListener);
            this.removeMouseListener(mouseListener);
        }
        this.addMouseListener(new JTreeMouseListener(this));
        this.addMouseMotionListener(new JTreeMouseMotionListener(this));
        this.setCellEditor(new TreeCellEditor(this, renderer));
    }

    public MonDirJTree(TreeNode node) {
        super(node);
    }

    public void updatePath() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        MindMapNode root = (MindMapNode)model.getRoot();
        this.updatePath(root);
        this.updateUI();
    }

    private void updatePath(MindMapNode parent) {
        List children = parent.getChildren();
        for (MindMapNode child : children) {
            TreePath childpath = this.getPath(child);
            if (child.isFolded()) {
                this.collapsePath(childpath);
                continue;
            }
            this.expandPath(childpath);
            this.updatePath(child);
        }
    }

    public TreePath getPath(MindMapNode node) {
        Vector pathVector = new Vector();
        this.createPath(node, pathVector);
        TreePath childpath = new TreePath(pathVector.toArray());
        return childpath;
    }

    private void createPath(MindMapNode node, Vector pathVector) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        MindMapNode root = (MindMapNode)model.getRoot();
        pathVector.add(0, node);
        if (root.getChildren().contains(node)) {
            pathVector.add(0, root);
        } else {
            this.createPath(node.getParentNode(), pathVector);
        }
    }

    public Object[] getChildren(TreePath eventPath, Object[] children) {
        if (children == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        MindMapNode parent = (MindMapNode)eventPath.getLastPathComponent();
        block0: for (Object child : children) {
            for (Object parentChild : parent.getChildren()) {
                MindMapNode childNode = (MindMapNode)child;
                MindMapNode parentChildNode = (MindMapNode)parentChild;
                if (!parentChildNode.getText().equals(childNode.getText())) continue;
                result.add(parentChild);
                continue block0;
            }
        }
        return result.toArray();
    }

    public int[] getChildIndices(TreePath eventPath, Object[] children) {
        if (children == null) {
            return null;
        }
        ArrayList<Integer> temp = new ArrayList<Integer>();
        MindMapNode parent = (MindMapNode)eventPath.getLastPathComponent();
        for (Object child : children) {
            temp.add(parent.getChildPosition((MindMapNode)child));
        }
        int[] result = new int[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            result[i] = (Integer)temp.get(i);
        }
        return result;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        dragSourceDragEvent.getDragSourceContext().setCursor(this.getCursorByAction(dragSourceDragEvent.getUserAction()));
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.requestFocus();
        if (dragSourceDropEvent.getDropAction() == 2) {
            TreePath path = this.getClosestPathForLocation(this.mouseEvent.getX(), this.mouseEvent.getY());
            this.addSelectionPath(path);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        ArrayList<MindMapNode> nodes = new ArrayList<MindMapNode>();
        for (TreePath treePath : this.getSelectionPaths()) {
            nodes.add((MindMapNode)treePath.getLastPathComponent());
        }
        dragGestureEvent.startDrag(this.getCursorByAction(dragGestureEvent.getDragAction()), new NodeTransferable(nodes), this);
    }

    public Cursor getCursorByAction(int dragAction) {
        switch (dragAction) {
            case 1: {
                return DragSource.DefaultCopyDrop;
            }
            case 0x40000000: {
                return DragSource.DefaultLinkDrop;
            }
        }
        return DragSource.DefaultMoveDrop;
    }

    private class TreeCellEditor
    extends DefaultTreeCellEditor {
        JTree tree;
        DefaultTreeCellRenderer renderer;

        public TreeCellEditor(JTree jTree, DefaultTreeCellRenderer renderer) {
            super(jTree, new DefaultTreeCellRenderer());
            this.tree = jTree;
            this.renderer = renderer;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.tree.hasFocus();
        }

        @Override
        protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (this.renderer != null) {
                this.editingIcon = this.renderer.getLeafIcon();
                this.offset = this.renderer.getIconTextGap() + this.editingIcon.getIconWidth();
            } else {
                this.editingIcon = null;
                this.offset = 0;
            }
        }
    }

    private class JTreeMouseMotionListener
    implements MouseMotionListener {
        MonDirJTree tree;

        private JTreeMouseMotionListener(MonDirJTree tree) {
            this.tree = tree;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MonDirJTree.this.isSingleClickInSelection = false;
            for (MouseListener mouseListener : MonDirJTree.this.standardMouseListeners) {
                mouseListener.mousePressed(MonDirJTree.this.mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class JTreeMouseListener
    implements MouseListener {
        MonDirJTree tree;
        TreePath[] oldSelPaths;
        Integer DoubleClickTime = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        Timer timer = null;
        short clickCount = 0;

        private JTreeMouseListener(MonDirJTree tree) {
            this.tree = tree;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.getButton() != 1) {
                return;
            }
            if (event.isControlDown()) {
                TreePath selPath = this.tree.getPathForLocation(event.getX(), event.getY());
                this.tree.getSelectionModel().addSelectionPath(selPath);
                event.consume();
                return;
            }
            if (event.isShiftDown()) {
                int selRow = this.tree.getRowForLocation(event.getX(), event.getY());
                int leadRow = this.tree.getSelectionModel().getLeadSelectionRow();
                if (leadRow >= 0) {
                    TreePath[] selPaths = this.tree.getPathBetweenRows(leadRow, selRow);
                    this.tree.getSelectionModel().addSelectionPaths(selPaths);
                } else {
                    TreePath[] selPaths = this.tree.getPathBetweenRows(0, selRow);
                    this.tree.getSelectionModel().addSelectionPaths(selPaths);
                }
                event.consume();
                return;
            }
            MonDirJTree.this.mouseEvent = event;
            if (this.timer == null) {
                this.timer = new Timer(this.DoubleClickTime, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        switch (JTreeMouseListener.this.clickCount) {
                            case 1: {
                                JTreeMouseListener.this.processSingleClick();
                                break;
                            }
                            case 2: {
                                JTreeMouseListener.this.processDoubleClick();
                                break;
                            }
                            case 3: {
                                JTreeMouseListener.this.processTripleClick();
                            }
                        }
                        JTreeMouseListener.this.clickCount = 0;
                    }
                });
                this.timer.setRepeats(false);
            } else {
                this.timer.start();
            }
            this.tree.requestFocus();
            TreePath selPath = this.tree.getPathForLocation(event.getX(), event.getY());
            if (selPath != null) {
                event.consume();
                if (this.tree.getSelectionPaths() != null) {
                    for (TreePath path : this.tree.getSelectionPaths()) {
                        if (!path.equals(selPath)) continue;
                        MonDirJTree.this.isSingleClickInSelection = true;
                    }
                }
                if (!MonDirJTree.this.isSingleClickInSelection) {
                    this.tree.setSelectionPath(selPath);
                }
            }
            if (!event.isConsumed()) {
                for (MouseListener mouseListener : MonDirJTree.this.standardMouseListeners) {
                    mouseListener.mousePressed(event);
                }
            }
        }

        private void processTripleClick() {
            TreePath selPath = this.tree.getPathForLocation(MonDirJTree.this.mouseEvent.getX(), MonDirJTree.this.mouseEvent.getY());
            if (this.tree.isCollapsed(selPath)) {
                this.tree.expandPath(selPath);
            } else {
                this.tree.collapsePath(selPath);
            }
            this.oldSelPaths = this.tree.getSelectionPaths();
        }

        private void processSingleClick() {
            TreePath selPath = this.tree.getPathForLocation(MonDirJTree.this.mouseEvent.getX(), MonDirJTree.this.mouseEvent.getY());
            this.tree.setSelectionPath(selPath);
            if (this.oldSelPaths != null && this.oldSelPaths.length == 1) {
                for (TreePath path : this.oldSelPaths) {
                    if (!path.equals(selPath)) continue;
                    this.tree.startEditingAtPath(selPath);
                }
            }
            this.oldSelPaths = this.tree.getSelectionPaths();
        }

        private void processDoubleClick() {
            File file;
            TreePath selPath = this.tree.getPathForLocation(MonDirJTree.this.mouseEvent.getX(), MonDirJTree.this.mouseEvent.getY());
            MindMapNode node = (MindMapNode)selPath.getLastPathComponent();
            String path = SciPloreUtils.getLink(node, MonDirJTree.this.controller);
            if (path != null && !path.isEmpty() && (file = new File(path)).exists()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.open(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.oldSelPaths = this.tree.getSelectionPaths();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            if (!mouseEvent.isConsumed()) {
                for (MouseListener mouseListener : MonDirJTree.this.standardMouseListeners) {
                    mouseListener.mouseClicked(mouseEvent);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            if (this.timer.isRunning()) {
                this.clickCount = (short)(this.clickCount + 1);
            }
            TreePath selPath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (MonDirJTree.this.isSingleClickInSelection) {
                this.tree.setSelectionPath(selPath);
                MonDirJTree.this.isSingleClickInSelection = false;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

