/*
 * Decompiled with CFR 0.152.
 */
package splmm.Gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import splmm.Listeners.PreferencesMouseListener;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;

public class IrNotfication {
    private JCheckBox usageMiningCheckBox;
    private JLabel usageMiningInfoLabel;
    private JCheckBox ironmmCheckBox;
    private JLabel ironmmInfoLabel;
    private JCheckBox ironldCheckBox;
    private JLabel ironldInfoLabel;
    private JPanel notificationPanel;
    private JLabel linkLabel;
    private JButton privacyButton;

    public IrNotfication() {
        this.$$$setupUI$$$();
        this.usageMiningCheckBox.setSelected(SplmmPreferences.getAllowUsageMining());
        this.ironmmCheckBox.setSelected(SplmmPreferences.getAllowIRonMM());
        this.ironldCheckBox.setSelected(SplmmPreferences.getAllowIRonLD());
        this.linkLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    SciPloreUtils.openURL(SciPloreUtils.ABOUT_URL);
                }
            }
        });
        this.privacyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IrNotfication.this.onPrivacy();
            }
        });
        this.usageMiningInfoLabel.addMouseListener(new PreferencesMouseListener(this.notificationPanel, "splmm_preferences_usageMiningInfoText"));
        this.ironmmInfoLabel.addMouseListener(new PreferencesMouseListener(this.notificationPanel, "splmm_preferences_ironmmInfoText"));
        this.ironldInfoLabel.addMouseListener(new PreferencesMouseListener(this.notificationPanel, "splmm_preferences_ironldInfoText"));
    }

    public void show(JFrame frame) {
        Object[] options = new Object[]{LocalizationSupport.message("splmm_update_ok"), LocalizationSupport.message("splmm_update_cancel")};
        int result = JOptionPane.showOptionDialog(frame, this.notificationPanel, "", 0, 1, null, options, options[0]);
        if (result == 0) {
            SplmmPreferences.setAllowUsageMining(this.usageMiningCheckBox.isSelected());
            SplmmPreferences.setAllowIRonMM(this.ironmmCheckBox.isSelected());
            SplmmPreferences.setAllowIRonMM(this.ironldCheckBox.isSelected());
        }
    }

    private void onPrivacy() {
        SciPloreUtils.openURL(SciPloreUtils.PRIVACY_URL);
    }

    private void $$$setupUI$$$() {
        this.notificationPanel = new JPanel();
        this.notificationPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(5, 40, 5, 5), -1, -1));
        Spacer spacer1 = new Spacer();
        this.notificationPanel.add((Component)spacer1, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.notificationPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, new Dimension(-1, 10), null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.notificationPanel.add((Component)panel1, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.usageMiningCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.usageMiningCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_prferences_usageMining"));
        this.usageMiningCheckBox.setToolTipText("");
        panel1.add((Component)this.usageMiningCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.usageMiningInfoLabel = new JLabel();
        this.usageMiningInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.usageMiningInfoLabel.setText("");
        panel1.add((Component)this.usageMiningInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel1.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.notificationPanel.add((Component)panel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.ironmmCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.ironmmCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_informationMindMaps"));
        this.ironmmCheckBox.setToolTipText("");
        panel2.add((Component)this.ironmmCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.ironmmInfoLabel = new JLabel();
        this.ironmmInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.ironmmInfoLabel.setText("");
        panel2.add((Component)this.ironmmInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        panel2.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.notificationPanel.add((Component)panel3, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.ironldCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.ironldCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_informationLinkedData"));
        this.ironldCheckBox.setToolTipText("");
        panel3.add((Component)this.ironldCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.ironldInfoLabel = new JLabel();
        this.ironldInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.ironldInfoLabel.setText("");
        panel3.add((Component)this.ironldInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer5 = new Spacer();
        panel3.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, new Dimension(10, -1), null, null, 0, false));
        this.privacyButton = new JButton();
        this.$$$loadButtonText$$$(this.privacyButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_moreInfo"));
        panel3.add((Component)this.privacyButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer6 = new Spacer();
        panel3.add((Component)spacer6, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, new Dimension(-1, 10), null, null, 0, false));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("splmm/Localization/splmm").getString("ir_notification_text3"));
        this.notificationPanel.add((Component)label1, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.notificationPanel.add((Component)panel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.linkLabel = new JLabel();
        this.linkLabel.setHorizontalAlignment(4);
        this.linkLabel.setHorizontalTextPosition(4);
        this.$$$loadLabelText$$$(this.linkLabel, ResourceBundle.getBundle("splmm/Localization/splmm").getString("ir_notification_text1"));
        panel4.add((Component)this.linkLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 1, 0, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        panel4.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setHorizontalAlignment(2);
        label2.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("splmm/Localization/splmm").getString("ir_notification_text2"));
        panel4.add((Component)label2, new GridConstraints(0, 1, 1, 1, 8, 0, 4, 0, null, null, null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.notificationPanel;
    }
}

