/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnyAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDHighlightAnnotation;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutlineItem;
import de.intarsys.pdf.pd.PDOutlineNode;
import de.intarsys.pdf.pd.PDTextAnnotation;
import de.intarsys.pdf.pd.PDTextMarkupAnnotation;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import freemind.controller.Controller;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.attributes.Attribute;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.view.mindmapview.NodeView;
import java.awt.FontMetrics;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import splmm.BibTex;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;
import splmm.SplmmAttributes;

public class BookmarkMindMapNode
extends MindMapNodeModel {
    private String name;

    public BookmarkMindMapNode(File file, String name, Controller c, SplmmAttributes.LinkType linkType) {
        super(c.getFrame(), c.getMap());
        this.initMindMapNode(file, name, c, linkType);
    }

    public BookmarkMindMapNode(File file, String name, HashMap<String, Collection<BibTex>> bibTexMap, Controller c, SplmmAttributes.LinkType linkType) {
        super(c.getFrame(), c.getMap());
        this.initMindMapNode(file, name, c, linkType);
        BibTex.addBibtexData(this, bibTexMap);
    }

    private void initMindMapNode(File file, String name, Controller c, SplmmAttributes.LinkType linkType) {
        this.name = name;
        if (c.getProperty("links").equalsIgnoreCase("absolute")) {
            this.setLink(file.getAbsolutePath());
        } else {
            try {
                if (this.getMap().getFile() == null) {
                    JOptionPane.showMessageDialog(this.getFrame().getContentPane(), LocalizationSupport.message("the.mindmap.has.to.be.saved.first.before.you.can.add.relative.links.to.the.mindmap"), "FreeMind", 2);
                }
                URL link = Tools.fileToUrl(file);
                String relative = Tools.toRelativeURL(Tools.fileToUrl(this.getMap().getFile()), link);
                this.setLink(relative);
            }
            catch (MalformedURLException ex) {
                c.errorMessage(c.getModeController().getText("url_error"));
            }
        }
        this.setText(name);
        this.getSPLMMAttributes().setLinkType(linkType);
    }

    public String getName() {
        return this.name;
    }

    public String setName(String name) {
        this.name = name;
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static MindMapNode getBookmarksFromFile(File file, Controller c, HashMap<String, Collection<BibTex>> bibTexMap) {
        BookmarkMindMapNode node = new BookmarkMindMapNode(file, file.getName(), bibTexMap, c, SplmmAttributes.LinkType.document);
        try {
            FileLocator locator = new FileLocator(file.getPath());
            PDDocument document = PDDocument.createFromLocator((ILocator)locator);
            if (SplmmPreferences.getImportBookmarks()) {
                node = BookmarkMindMapNode.getBookmarks(node, file, document, bibTexMap, c);
            }
            node = BookmarkMindMapNode.getAnnotations(node, file, document, bibTexMap, c, SplmmPreferences.getImportComments(), SplmmPreferences.getImportHighlights());
            document.close();
        }
        catch (COSLoadException e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            SciPloreUtils.logException(className, (Exception)((Object)e), Level.WARNING);
            System.out.println("Could not import pdf: " + file.getName() + "\nCaused by Exception: " + ((Object)((Object)e)).getClass().getName());
            SciPloreUtils.log(className, "Could not import pdf: " + file.getName(), Level.WARNING);
        }
        catch (IOException e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            System.out.println("Could not import pdf: " + file.getName() + "\nCaused by Exception: " + e.getClass().getName());
            SciPloreUtils.log(className, "Could not import pdf: " + file.getName(), Level.WARNING);
            SciPloreUtils.logException(className, e, Level.WARNING);
        }
        catch (Exception e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            System.out.println("Could not import pdf: " + file.getName() + "\nCaused by Exception: " + e.getClass().getName());
            SciPloreUtils.log(className, "Could not import pdf: " + file.getName(), Level.WARNING);
            SciPloreUtils.logException(className, e, Level.WARNING);
        }
        if (node == null) {
            node = new BookmarkMindMapNode(file, file.getName(), bibTexMap, c, SplmmAttributes.LinkType.document);
        }
        node.getSPLMMAttributes().setBookmarksUpdated(new Date());
        return node;
    }

    public static BookmarkMindMapNode getBookmarks(BookmarkMindMapNode node, File file, PDDocument document, HashMap<String, Collection<BibTex>> bibTexMap, Controller c) {
        try {
            PDOutline outline = null;
            PDOutline object = document.getOutline();
            if (object instanceof PDOutline) {
                outline = object;
            }
            if (outline != null) {
                node = BookmarkMindMapNode.helpGetBookmarks(file, (PDOutlineNode)outline, node, bibTexMap, c);
            }
            node.getSPLMMAttributes().setBookmarksUpdated(new Date());
        }
        catch (COSRuntimeException e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            SciPloreUtils.logException(className, (Exception)((Object)e), Level.WARNING);
        }
        catch (ClassCastException e) {
        }
        catch (Exception e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            SciPloreUtils.logException(className, e, Level.WARNING);
        }
        return node;
    }

    public static BookmarkMindMapNode getAnnotations(BookmarkMindMapNode node, File file, PDDocument document, HashMap<String, Collection<BibTex>> bibTexMap, Controller c, boolean comments, boolean highlights) {
        if (!comments && !highlights) {
            return node;
        }
        List annos = document.getAnnotations();
        int size = annos.size();
        ListIterator it = annos.listIterator();
        String last_string = "";
        while (it.hasNext()) {
            BookmarkMindMapNode childNode;
            PDAnnotation anno = (PDAnnotation)it.next();
            if (anno.getContents().equals("") || anno.getContents().equals(last_string)) continue;
            last_string = anno.getContents();
            if (anno.getPage() != null) {
                if (anno.getPage().getMediaBox() == null || anno.getRectangle() == null) continue;
                CDSRectangle page_rec = anno.getPage().getMediaBox();
                CDSRectangle anno_rec = anno.getRectangle();
                if (anno_rec.getLowerLeftX() > page_rec.getUpperRightX() || anno_rec.getLowerLeftY() > page_rec.getUpperRightY() || anno_rec.getUpperRightX() < page_rec.getLowerLeftX() || anno_rec.getUpperRightY() < page_rec.getLowerLeftY()) continue;
            }
            if ((anno.getClass() == PDAnyAnnotation.class || anno.getClass() == PDTextAnnotation.class) && comments) {
                childNode = new BookmarkMindMapNode(file, anno.getContents(), bibTexMap, c, SplmmAttributes.LinkType.comment);
                childNode.getSPLMMAttributes().setBookmarksUpdated(new Date());
                node.insert(childNode, node.getChildCount());
                continue;
            }
            if (anno.getClass() != PDTextMarkupAnnotation.class && anno.getClass() != PDHighlightAnnotation.class || !highlights) continue;
            childNode = new BookmarkMindMapNode(file, anno.getContents(), bibTexMap, c, SplmmAttributes.LinkType.highlightedtext);
            childNode.getSPLMMAttributes().setBookmarksUpdated(new Date());
            node.insert(childNode, node.getChildCount());
        }
        node.getSPLMMAttributes().setBookmarksUpdated(new Date());
        return node;
    }

    private static BookmarkMindMapNode helpGetBookmarks(File file, PDOutlineNode parent, BookmarkMindMapNode node, HashMap<String, Collection<BibTex>> bibTexMap, Controller c) {
        List children = parent.getChildren();
        for (PDOutlineItem child : children) {
            BookmarkMindMapNode childNode = new BookmarkMindMapNode(file, child.getTitle(), bibTexMap, c, SplmmAttributes.LinkType.bookmark);
            childNode.getSPLMMAttributes().setBookmarksUpdated(new Date());
            childNode = BookmarkMindMapNode.helpGetBookmarks(file, (PDOutlineNode)child, childNode, bibTexMap, c);
            node.insert(childNode, node.getChildCount());
        }
        node.getSPLMMAttributes().setBookmarksUpdated(new Date());
        return node;
    }

    public static HashMap<String, Collection<BibTex>> ReadBibtexFile() {
        HashMap<String, Collection<BibTex>> bibTexMap = new HashMap<String, Collection<BibTex>>();
        if (SplmmPreferences.getJabRefPath() != null && !SplmmPreferences.getJabRefPath().equals("")) {
            File f = new File(SplmmPreferences.getJabRefPath());
            BibTex bib = new BibTex();
            bibTexMap = bib.readBibtex(f);
        }
        return bibTexMap;
    }

    public static void SetOptimalColumnWidth(MindMapNode node) {
        if (node.getAttributeKeyList().size() == 0) {
            return;
        }
        ModeController controller = node.getMap().getModeController();
        NodeView nodeView = controller.getNodeView(controller.getSelected());
        FontMetrics fontMetrics = nodeView.getFontMetrics(nodeView.getTextFont());
        int optCellWidthLeft = fontMetrics.stringWidth(BookmarkMindMapNode.GetLongestAttributeKey(node) + "O");
        int optCellWidthRight = fontMetrics.stringWidth(BookmarkMindMapNode.GetLongestAttributeValue(node) + "O");
        if (optCellWidthLeft > 350) {
            optCellWidthLeft = 350;
        }
        if (optCellWidthRight > 350) {
            optCellWidthRight = 350;
        }
        node.getAttributes().setColumnWidth(0, optCellWidthLeft);
        node.getAttributes().setColumnWidth(1, optCellWidthRight);
    }

    private static String GetLongestAttributeKey(MindMapNode node) {
        String longest = "";
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (a.getName().length() <= longest.length()) continue;
            longest = a.getName();
        }
        return longest;
    }

    private static String GetLongestAttributeValue(MindMapNode node) {
        String longest = "";
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (a.getValue().length() <= longest.length()) continue;
            longest = a.getValue();
        }
        return longest;
    }
}

