/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import splmm.Actions.SplmmAbstractAction;
import splmm.Gui.WaitDialog;
import splmm.Listeners.SplmmWindowsFocusListener;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public abstract class AbstractMonitoringAction
extends SplmmAbstractAction {
    protected File directory;
    protected Task task;

    public AbstractMonitoringAction(String name, MindMapController controller) {
        super(name, controller);
    }

    protected int ShowFileChooser(File directory) {
        JFileChooser fileChooser = new JFileChooser();
        if (directory != null && directory.exists()) {
            fileChooser = new JFileChooser(directory);
        }
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(LocalizationSupport.message("choose.a.directory.with.pdf.files"));
        int result = fileChooser.showOpenDialog(this.controller.getFrame().getJFrame());
        if (result == 0) {
            if (this.controller.getController().getProperty("links").equalsIgnoreCase("absolute")) {
                this.directory = fileChooser.getSelectedFile();
            } else {
                try {
                    if (this.controller.getMap().getFile() == null || Tools.fileToUrl(this.controller.getMap().getFile()) == null) {
                        JOptionPane.showMessageDialog(this.controller.getFrame().getContentPane(), LocalizationSupport.message("the.mindmap.has.to.be.saved.first.before.you.can.add.relative.links.to.the.mindmap"), "FreeMind", 2);
                    }
                    URL link = Tools.fileToUrl(fileChooser.getSelectedFile());
                    String relative = Tools.toRelativeURL(Tools.fileToUrl(this.controller.getMap().getFile()), link);
                    if (!relative.startsWith(".")) {
                        relative = "./" + relative;
                    }
                    relative = relative.replace("%20", " ");
                    this.directory = new File(relative);
                }
                catch (MalformedURLException ex) {
                    this.controller.getController().errorMessage(this.controller.getModeController().getText("url_error"));
                }
            }
        }
        return result;
    }

    protected void ExecuteMyTask(Task myTask, Action action) {
        try {
            WaitDialog waitDialog = new WaitDialog(this.controller.getFrame(), this.task);
            waitDialog.setTitle(action.getValue("Name").toString());
            this.task = myTask;
            this.task.addPropertyChangeListener(waitDialog);
            action.addPropertyChangeListener(waitDialog);
            waitDialog.addPropertyChangeListener(this.task);
            waitDialog.addWindowFocusListener(new SplmmWindowsFocusListener());
            waitDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    if (AbstractMonitoringAction.this.task.name != null && AbstractMonitoringAction.this.task.name == "update") {
                        new EventSenderThread(SciPloreUtils.EVENT_ABORT_READ_MON_DIR, "" + AbstractMonitoringAction.this.newFileCounter);
                    }
                    AbstractMonitoringAction.this.task.cancel(true);
                }
            });
            SciPloreUtils.MonDirReadingActive = true;
            this.task.execute();
            waitDialog.pack();
            waitDialog.setVisible(true);
            while (!this.task.isDone()) {
            }
            this.task.canceled = true;
            System.out.println("Task is done...");
            SciPloreUtils.MonDirReadingActive = false;
            System.out.println("Task State:" + this.task.getState().toString());
        }
        catch (Exception e) {
            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
        }
    }

    protected void deleteMonitoredPdfFiles(MindMapNode selected, String path) throws FileNotFoundException {
        File directory = new File(path);
        if (directory.exists()) {
            ArrayList<MindMapNode> nodesToRemove = this.getNodesToRemove(selected, directory, null);
            for (MindMapNode node : nodesToRemove) {
                this.controller.deleteNode(node);
            }
        } else {
            JOptionPane.showMessageDialog(this.controller.getFrame().getJFrame(), LocalizationSupport.message("directory.not.found"), LocalizationSupport.message("error.while.removing.the.nodes"), 0);
            throw new FileNotFoundException();
        }
    }

    protected ArrayList<MindMapNode> getNodesToRemove(MindMapNode selected, File oldDirectory, File newDirectory) {
        ArrayList<MindMapNode> nodesToRemove = new ArrayList<MindMapNode>();
        ListIterator childrenIterator = selected.childrenUnfolded();
        while (childrenIterator.hasNext()) {
            MindMapNode child = (MindMapNode)childrenIterator.next();
            if (child.getLink() == null) continue;
            String oldDirPath = oldDirectory.getPath();
            String linkPath = SciPloreUtils.getLink(child, this.controller.getController());
            if (linkPath == null) continue;
            if (newDirectory != null) {
                String newDirPath = newDirectory.getPath();
                if (!linkPath.contains(oldDirPath) || linkPath.contains(newDirPath)) continue;
                nodesToRemove.add(child);
                continue;
            }
            if (!linkPath.contains(oldDirPath)) continue;
            nodesToRemove.add(child);
        }
        return nodesToRemove;
    }

    protected void AddMonitoringAtrributes(MindMapNode node) {
        if (node.getAttributeTableLength() == 0) {
            node.createAttributeTableModel();
        }
        node.getAttributes().addRowNoUndo(new Attribute(SciPloreUtils.SPLMM_DIRMON_PATH, this.directory.getPath()));
        node.getAttributes().addRowNoUndo(new Attribute(SciPloreUtils.SPLMM_DIRMON_AUTO, "2"));
        node.getAttributes().addRowNoUndo(new Attribute(SciPloreUtils.SPLMM_DIRMON_SUBDIRS, "2"));
    }

    protected void RemoveMonitoringAtrributes(MindMapNode selected) {
        NodeAttributeTableModel attributes = selected.getAttributes();
        attributes.removeRow(selected.getAttributePosition(SciPloreUtils.SPLMM_DIRMON_PATH));
        attributes.removeRow(selected.getAttributePosition(SciPloreUtils.SPLMM_DIRMON_AUTO));
        attributes.removeRow(selected.getAttributePosition(SciPloreUtils.SPLMM_DIRMON_SUBDIRS));
    }

    protected boolean isNotUnsavedMapWithRelativePathes() {
        if (this.selected.getMap().getModeController().getController().getProperty("links").equalsIgnoreCase("absolute")) {
            return true;
        }
        if (this.selected.getMap().getFile() == null) {
            JOptionPane.showMessageDialog(this.controller.getFrame().getContentPane(), LocalizationSupport.message("the.mindmap.has.to.be.saved.first.before.you.can.add.relative.links.to.the.mindmap"), "FreeMind", 2);
            return false;
        }
        File file = this.controller.getMap().getFile();
        return true;
    }

    public abstract class Task
    extends SwingWorker<Void, Void>
    implements PropertyChangeListener {
        public String name;
        public boolean canceled = false;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("canceled")) {
                System.out.println("Received Property Change Cancel");
                this.cancel(true);
            }
        }
    }
}

