/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions.xml;

import freemind.controller.actions.generated.instance.HookContentNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.PermanentNodeHook;
import freemind.extensions.StatefulNodeHook;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.util.logging.Logger;

public class NodeHookUndoableContentActor
implements ActorXml {
    MindMapController controller;
    private static Logger logger;

    public MindMapController getController() {
        return this.controller;
    }

    public NodeHookUndoableContentActor(MindMapController controller) {
        this.controller = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void performAction(MindMapNode focussed, String hookName, String attributeName, String content) {
        String oldContent = this.findHook(focussed, hookName).getContent(attributeName);
        if (oldContent.equals(content)) {
            return;
        }
        HookContentNodeAction doAction = this.createHookContentNodeAction(focussed, hookName, attributeName, content);
        HookContentNodeAction undoAction = this.createHookContentNodeAction(focussed, hookName, attributeName, oldContent);
        this.getController().getActionFactory().startTransaction(this.getClass().getName());
        this.getController().getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        this.getController().getActionFactory().endTransaction(this.getClass().getName());
    }

    public void performAction(MindMapNode focussed, String hookName, String content) {
        this.performAction(focussed, hookName, null, content);
    }

    private void invoke(MindMapNode node, String hookName, String attributeName, String content) {
        logger.finest("invoke(selecteds) called.");
        this.findHook(node, hookName).setContent(attributeName, content);
    }

    private StatefulNodeHook findHook(MindMapNode node, String hookName) {
        for (PermanentNodeHook permhook : node.getActivatedHooks()) {
            if (!(permhook instanceof StatefulNodeHook) || !permhook.getName().equals(hookName)) continue;
            StatefulNodeHook hook = (StatefulNodeHook)permhook;
            return hook;
        }
        throw new RuntimeException("hook not found");
    }

    public HookContentNodeAction createHookContentNodeAction(MindMapNode focussed, String hookName, String attributeName, String content) {
        HookContentNodeAction hookContentNodeAction = new HookContentNodeAction();
        hookContentNodeAction.setNode(focussed.getObjectId(this.getController()));
        hookContentNodeAction.setHookName(hookName);
        hookContentNodeAction.setAttributeName(attributeName);
        hookContentNodeAction.setContent(content);
        return hookContentNodeAction;
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof HookContentNodeAction) {
            HookContentNodeAction hookContentNodeAction = (HookContentNodeAction)action;
            NodeAdapter selected = this.getController().getNodeFromID(hookContentNodeAction.getNode());
            this.invoke(selected, hookContentNodeAction.getHookName(), hookContentNodeAction.getAttributeName(), hookContentNodeAction.getContent());
        }
    }

    @Override
    public Class getDoActionClass() {
        return HookContentNodeAction.class;
    }
}

