/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions.xml;

import freemind.controller.Controller;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.modes.mindmapmode.actions.xml.ActionFilter;
import freemind.modes.mindmapmode.actions.xml.ActionHandler;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import freemind.modes.mindmapmode.actions.xml.UndoActionHandler;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;

public class ActionFactory {
    private Controller controller;
    private Vector registeredHandler;
    private Vector registeredFilters;
    private HashMap registeredActors;
    private UndoActionHandler undoActionHandler;
    private static Logger logger = null;

    public ActionFactory(Controller c) {
        this.controller = c;
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.registeredHandler = new Vector();
        this.registeredFilters = new Vector();
        this.registeredActors = new HashMap();
    }

    public void registerHandler(ActionHandler newHandler) {
        if (!this.registeredHandler.contains(newHandler)) {
            this.registeredHandler.remove(newHandler);
        }
        this.registeredHandler.add(0, newHandler);
    }

    public void deregisterHandler(ActionHandler newHandler) {
        this.registeredHandler.remove(newHandler);
    }

    public void registerFilter(ActionFilter newFilter) {
        if (!this.registeredFilters.contains(newFilter)) {
            if (newFilter instanceof ActionFilter.FinalActionFilter) {
                this.registeredFilters.insertElementAt(newFilter, this.registeredFilters.size());
            } else {
                this.registeredFilters.add(newFilter);
            }
        }
    }

    public void deregisterFilter(ActionFilter newFilter) {
        this.registeredFilters.remove(newFilter);
    }

    public void startTransaction(String name) {
        for (ActionHandler handler : this.registeredHandler) {
            handler.startTransaction(name);
        }
    }

    public void endTransaction(String name) {
        for (ActionHandler handler : this.registeredHandler) {
            handler.endTransaction(name);
        }
    }

    public boolean executeAction(ActionPair pair) {
        if (pair == null) {
            return false;
        }
        boolean returnValue = true;
        ActionPair filteredPair = pair;
        for (ActionFilter filter : this.registeredFilters) {
            filteredPair = filter.filterAction(filteredPair);
        }
        if (this.undoActionHandler != null) {
            try {
                this.undoActionHandler.executeAction(filteredPair);
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
                returnValue = false;
            }
        }
        Object[] aArray = this.registeredHandler.toArray();
        for (int i = 0; i < aArray.length; ++i) {
            ActionHandler handler = (ActionHandler)aArray[i];
            try {
                handler.executeAction(filteredPair.getDoAction());
                continue;
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
                returnValue = false;
            }
        }
        return returnValue;
    }

    public Controller getController() {
        return this.controller;
    }

    public void registerActor(ActorXml actor, Class action) {
        this.registeredActors.put(action, actor);
    }

    public void deregisterActor(Class action) {
        this.registeredActors.remove(action);
    }

    public ActorXml getActor(XmlAction action) {
        for (Class actorClass : this.registeredActors.keySet()) {
            if (!actorClass.isInstance(action)) continue;
            return (ActorXml)this.registeredActors.get(actorClass);
        }
        throw new IllegalArgumentException("No actor present for xmlaction" + action.getClass());
    }

    public void registerUndoHandler(UndoActionHandler undoActionHandler) {
        this.undoActionHandler = undoActionHandler;
    }
}

