/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.AddIconAction;
import freemind.controller.actions.generated.instance.RemoveIconXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.controller.filter.condition.IconContainedCondition;
import freemind.main.Tools;
import freemind.modes.IconInformation;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.RemoveIconAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class IconAction
extends FreemindAction
implements ActorXml,
IconInformation {
    public MindIcon icon;
    private final MindMapController modeController;
    private final RemoveIconAction removeLastIconAction;

    public IconAction(MindMapController controller, MindIcon _icon, RemoveIconAction removeLastIconAction) {
        super(_icon.getDescription(), _icon.getIcon(), controller);
        this.modeController = controller;
        this.removeLastIconAction = removeLastIconAction;
        this.putValue("ShortDescription", _icon.getDescription());
        this.icon = _icon;
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getID() == 1001 && (e.getModifiers() & 1 & 0xFFFFFFFD & 0xFFFFFFF7) != 0) {
            this.removeAllIcons();
            this.addLastIcon();
            return;
        }
        if (e == null || (e.getModifiers() & 0xA) == 0) {
            this.addLastIcon();
            return;
        }
        if ((e.getModifiers() & 0xFFFFFFFE & 0xFFFFFFFD & 8) != 0) {
            this.removeIcon(false);
            return;
        }
        if ((e.getModifiers() & 0xFFFFFFFE & 2 & 0xFFFFFFF7) != 0) {
            this.removeIcon(true);
            return;
        }
    }

    private void addLastIcon() {
        ListIterator it = this.modeController.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.addIcon(selected, this.icon);
        }
    }

    private void removeIcon(boolean removeFirst) {
        ListIterator it = this.modeController.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.removeIcon(selected, this.icon, removeFirst);
        }
    }

    private void toggleIcon() {
        ListIterator it = this.modeController.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.toggleIcon(selected, this.icon);
        }
    }

    private void removeAllIcons() {
        ListIterator it = this.modeController.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            if (selected.getIcons().size() <= 0) continue;
            this.modeController.removeAllIcons(selected);
        }
    }

    public void addIcon(MindMapNode node, MindIcon icon) {
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(this.getAddLastIconActionPair(node, icon));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private void toggleIcon(MindMapNode node, MindIcon icon) {
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(this.getToggleIconActionPair(node, icon));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private void removeIcon(MindMapNode node, MindIcon icon, boolean removeFirst) {
        ActionPair removeIconActionPair = this.getRemoveIconActionPair(node, icon, removeFirst);
        if (removeIconActionPair == null) {
            return;
        }
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(removeIconActionPair);
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private ActionPair getAddLastIconActionPair(MindMapNode node, MindIcon icon) {
        int iconIndex = -1;
        return this.getAddIconActionPair(node, icon, iconIndex);
    }

    private ActionPair getAddIconActionPair(MindMapNode node, MindIcon icon, int iconIndex) {
        AddIconAction doAction = this.createAddIconAction(node, icon, iconIndex);
        RemoveIconXmlAction undoAction = this.removeLastIconAction.createRemoveIconXmlAction(node, iconIndex);
        return new ActionPair((XmlAction)doAction, (XmlAction)undoAction);
    }

    private ActionPair getToggleIconActionPair(MindMapNode node, MindIcon icon) {
        int iconIndex = IconContainedCondition.iconFirstIndex(node, icon.getName());
        if (iconIndex == -1) {
            return this.getAddLastIconActionPair(node, icon);
        }
        return this.getRemoveIconActionPair(node, icon, iconIndex);
    }

    private ActionPair getRemoveIconActionPair(MindMapNode node, MindIcon icon, boolean removeFirst) {
        int iconIndex = removeFirst ? IconContainedCondition.iconFirstIndex(node, icon.getName()) : IconContainedCondition.iconLastIndex(node, icon.getName());
        return iconIndex >= 0 ? this.getRemoveIconActionPair(node, icon, iconIndex) : null;
    }

    private ActionPair getRemoveIconActionPair(MindMapNode node, MindIcon icon, int iconIndex) {
        RemoveIconXmlAction doAction = this.removeLastIconAction.createRemoveIconXmlAction(node, iconIndex);
        AddIconAction undoAction = this.createAddIconAction(node, icon, iconIndex);
        return new ActionPair((XmlAction)doAction, (XmlAction)undoAction);
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof AddIconAction) {
            AddIconAction iconAction = (AddIconAction)action;
            NodeAdapter node = this.modeController.getNodeFromID(iconAction.getNode());
            String iconName = iconAction.getIconName();
            int position = iconAction.getIconPosition();
            MindIcon icon = MindIcon.factory(iconName);
            node.addIcon(icon, position);
            this.modeController.nodeChanged(node);
        }
    }

    @Override
    public Class getDoActionClass() {
        return AddIconAction.class;
    }

    public AddIconAction createAddIconAction(MindMapNode node, MindIcon icon, int iconPosition) {
        AddIconAction action = new AddIconAction();
        action.setNode(node.getObjectId(this.modeController));
        action.setIconName(icon.getName());
        action.setIconPosition(iconPosition);
        return action;
    }

    public MindIcon getMindIcon() {
        return this.icon;
    }

    @Override
    public KeyStroke getKeyStroke() {
        String keystrokeResourceName = this.icon.getKeystrokeResourceName();
        String keyStrokeDescription = this.getMindMapController().getFrame().getAdjustableProperty(keystrokeResourceName);
        return Tools.getKeyStroke(keyStrokeDescription);
    }

    @Override
    public String getDescription() {
        return this.icon.getDescription();
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon.getIcon();
    }

    @Override
    public String getKeystrokeResourceName() {
        return this.icon.getKeystrokeResourceName();
    }
}

