/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.actions;

import freemind.main.HtmlTools;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public class FindAction
extends AbstractAction {
    private final ControllerAdapter controller;
    private ArrayList findNodesUnfoldedByLastFind;
    private MindMapNode findFromNode;
    private String searchTerm;
    private Collection subterms;
    private boolean findCaseSensitive;
    private LinkedList findNodeQueue;

    public Collection getSubterms() {
        return this.subterms;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public String getFindFromText() {
        String plainNodeText = HtmlTools.htmlToPlain(((Object)this.findFromNode).toString()).replaceAll("\n", " ");
        return plainNodeText.length() <= 30 ? plainNodeText : plainNodeText.substring(0, 30) + "...";
    }

    public FindAction(ControllerAdapter controller) {
        super(controller.getText("find"), new ImageIcon(controller.getResource("images/filefind.png")));
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String what = JOptionPane.showInputDialog(this.controller.getView().getSelected(), this.controller.getText("find_what"), this.controller.getText("find"), 3);
        if (what == null || what.equals("")) {
            return;
        }
        Collection subterms = this.breakSearchTermIntoSubterms(what);
        this.searchTerm = what;
        boolean found = this.find(this.controller.getSelected(), subterms, false);
        this.controller.getView().repaint();
        if (!found) {
            String messageText = this.controller.getText("no_found_from");
            String searchTerm = messageText.startsWith("<html>") ? HtmlTools.toXMLEscapedText(this.getSearchTerm()) : this.getSearchTerm();
            this.controller.getController().informationMessage(messageText.replaceAll("\\$1", searchTerm).replaceAll("\\$2", this.getFindFromText()), this.controller.getView().getSelected());
        }
    }

    public boolean find(MindMapNode node, Collection subterms, boolean caseSensitive) {
        ArrayList<String> finalizedSubterms;
        this.findNodesUnfoldedByLastFind = new ArrayList();
        LinkedList<MindMapNode> nodes = new LinkedList<MindMapNode>();
        nodes.addFirst(node);
        this.findFromNode = node;
        if (!caseSensitive) {
            finalizedSubterms = new ArrayList<String>();
            Iterator i = subterms.iterator();
            while (i.hasNext()) {
                finalizedSubterms.add(((String)i.next()).toLowerCase());
            }
        } else {
            finalizedSubterms = subterms;
        }
        return this.find(nodes, finalizedSubterms, caseSensitive);
    }

    private boolean find(LinkedList nodes, Collection subterms, boolean caseSensitive) {
        boolean thereWereNodesToBeFolded;
        boolean bl = thereWereNodesToBeFolded = !this.findNodesUnfoldedByLastFind.isEmpty();
        if (!this.findNodesUnfoldedByLastFind.isEmpty()) {
            ListIterator i = this.findNodesUnfoldedByLastFind.listIterator(this.findNodesUnfoldedByLastFind.size());
            while (i.hasPrevious()) {
                MindMapNode node = (MindMapNode)i.previous();
                try {
                    this.controller.setFolded(node, true);
                }
                catch (Exception e) {}
            }
            this.findNodesUnfoldedByLastFind = new ArrayList();
        }
        while (!nodes.isEmpty()) {
            MindMapNode node = (MindMapNode)nodes.removeFirst();
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                nodes.addLast(i.next());
            }
            if (!node.isVisible()) continue;
            String nodeText = caseSensitive ? ((Object)node).toString() : ((Object)node).toString().toLowerCase();
            this.subterms = subterms;
            this.findCaseSensitive = caseSensitive;
            this.findNodeQueue = nodes;
            boolean found = true;
            Iterator i2 = subterms.iterator();
            while (i2.hasNext()) {
                if (nodeText.indexOf((String)i2.next()) >= 0) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.displayNode(node, this.findNodesUnfoldedByLastFind);
            this.centerNode(node);
            return true;
        }
        this.centerNode(this.findFromNode);
        return false;
    }

    private Collection breakSearchTermIntoSubterms(String searchTerm) {
        ArrayList<String> subterms = new ArrayList<String>();
        StringBuffer subterm = new StringBuffer();
        int len = searchTerm.length();
        int previousChar = 97;
        boolean withinQuotes = false;
        for (int i = 0; i < len; ++i) {
            char myChar = searchTerm.charAt(i);
            if (myChar == ' ' && withinQuotes) {
                subterm.append(myChar);
            } else if (myChar == ' ' && !withinQuotes) {
                subterms.add(subterm.toString());
                subterm.setLength(0);
            } else if (myChar == '\"' && i > 0 && i < len - 1 && searchTerm.charAt(i - 1) != ' ' && searchTerm.charAt(i + 1) != ' ') {
                subterm.append(myChar);
            } else if (myChar == '\"' && withinQuotes) {
                withinQuotes = false;
            } else if (myChar == '\"' && !withinQuotes) {
                withinQuotes = true;
            } else {
                subterm.append(myChar);
            }
            previousChar = myChar;
        }
        subterms.add(subterm.toString());
        return subterms;
    }

    public void displayNode(MindMapNode node, ArrayList nodesUnfoldedByDisplay) {
        TreeNode[] path = this.controller.getMap().getPathToRoot(node);
        for (int i = 0; i < path.length - 1; ++i) {
            MindMapNode nodeOnPath = (MindMapNode)path[i];
            if (!nodeOnPath.isFolded()) continue;
            if (nodesUnfoldedByDisplay != null) {
                nodesUnfoldedByDisplay.add(nodeOnPath);
            }
            this.controller.setFolded(nodeOnPath, false);
        }
    }

    public boolean findNext() {
        if (this.subterms != null) {
            if (this.findNodeQueue.isEmpty()) {
                return this.find(this.controller.getSelected(), this.subterms, this.findCaseSensitive);
            }
            return this.find(this.findNodeQueue, this.subterms, this.findCaseSensitive);
        }
        return false;
    }

    private void centerNode(MindMapNode node) {
        this.controller.centerNode(node);
    }

    public static class FindNextAction
    extends AbstractAction {
        private final ControllerAdapter controller;
        private final FindAction find;

        public FindNextAction(ControllerAdapter controller, FindAction find) {
            super(controller.getText("find_next"));
            this.controller = controller;
            this.find = find;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection subterms = this.find.getSubterms();
            if (subterms == null) {
                this.controller.getController().informationMessage(this.controller.getText("no_previous_find"), this.controller.getView().getSelected());
                return;
            }
            boolean found = this.find.findNext();
            this.controller.getView().repaint();
            if (!found) {
                String messageText = this.controller.getText("no_more_found_from");
                String searchTerm = messageText.startsWith("<html>") ? HtmlTools.toXMLEscapedText(this.find.getSearchTerm()) : this.find.getSearchTerm();
                this.controller.getController().informationMessage(messageText.replaceAll("\\$1", searchTerm).replaceAll("\\$2", this.find.getFindFromText()), this.controller.getView().getSelected());
            }
        }
    }
}

