/*
 * Decompiled with CFR 0.152.
 */
package bibtex;

import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexString;
import bibtex.parser.BibtexParser;
import bibtex.parser.ParseException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;

public class ExtractAuthors {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: ExtractAuthors <bibtexFile>");
            return;
        }
        try {
            FileReader in = new FileReader(args[0]);
            BibtexParser parser = new BibtexParser(false);
            BibtexFile file = new BibtexFile();
            parser.parse(file, in);
            Iterator it = file.getEntries().iterator();
            while (it.hasNext()) {
                BibtexEntry entry;
                BibtexString authorString;
                Object potentialEntry = it.next();
                if (!(potentialEntry instanceof BibtexEntry) || (authorString = (BibtexString)(entry = (BibtexEntry)potentialEntry).getFieldValue("author")) == null) continue;
                String content = authorString.getContent();
                String[] tokens = content.split("\\s++");
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].toLowerCase().equals("and")) {
                        System.out.println();
                    } else if (!tokens[i].toLowerCase().equals("others")) {
                        System.out.print(String.valueOf(tokens[i]) + " ");
                    }
                    ++i;
                }
                System.out.println();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File '" + args[0] + "' not found.");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

