/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDTransformMethod;
import de.intarsys.pdf.pd.PDTransformParams;

public class PDSignatureReference
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_SigRef = COSName.constant("SigRef");
    public static final COSName DK_TransformMethod = COSName.constant("TransformMethod");
    public static final COSName DK_TransformParams = COSName.constant("TransformParams");
    public static final COSName DK_Data = COSName.constant("Data");
    public static final COSName DK_DigestMethod = COSName.constant("DigestMethod");
    public static final COSName DK_DigestValue = COSName.constant("DigestValue");
    public static final COSName DK_DigestLocation = COSName.constant("DigestLocation");
    public static final String DIGESTMETHOD_MD5 = "MD5";
    public static final String DIGESTMETHOD_SHA1 = "SHA1";
    private static final String DEFAULT_DIGESTMETHOD = "MD5";

    protected PDSignatureReference(COSObject object) {
        super(object);
    }

    public COSObject cosGetData() {
        COSObject data = this.cosGetField(DK_Data);
        return data.isNull() ? null : data;
    }

    public COSArray cosGetDigestLocation() {
        return this.cosGetField(DK_DigestLocation).asArray();
    }

    protected COSName cosGetExpectedType() {
        return CN_Type_SigRef;
    }

    public void cosSetData(COSObject data) {
        this.cosSetField(DK_Data, data);
    }

    public String getDigestMethod() {
        COSName cosDigestMethod = this.cosGetField(DK_DigestMethod).asName();
        if (cosDigestMethod == null) {
            return "MD5";
        }
        return cosDigestMethod.stringValue();
    }

    public byte[] getDigestValue() {
        COSString cosDigestValue = this.cosGetField(DK_DigestValue).asString();
        if (cosDigestValue == null) {
            return null;
        }
        return cosDigestValue.byteValue();
    }

    public PDTransformMethod getTransformMethod() {
        return (PDTransformMethod)PDTransformMethod.META.createFromCos(this.cosGetField(DK_TransformMethod));
    }

    public PDTransformParams getTransformParams() {
        return (PDTransformParams)PDTransformParams.META.createFromCos(this.cosGetField(DK_TransformParams));
    }

    public void setDigestMethod(String digestMethod) {
        COSName cosDigestMethod = null;
        if (digestMethod != null) {
            cosDigestMethod = COSName.create(digestMethod);
        }
        this.cosSetField(DK_DigestMethod, cosDigestMethod);
    }

    public void setDigestValue(byte[] digest) {
        COSString cosDigestValue = null;
        if (digest != null) {
            cosDigestValue = COSString.create(digest);
        }
        this.cosSetField(DK_DigestValue, cosDigestValue);
    }

    public void setTransformMethod(PDTransformMethod method) {
        COSObject cosMethod = null;
        if (method != null) {
            cosMethod = method.cosGetObject();
        }
        this.cosSetField(DK_TransformMethod, cosMethod);
    }

    public void setTransformParams(PDTransformParams params) {
        COSObject cosParams = null;
        if (params != null) {
            cosParams = params.cosGetObject();
        }
        this.cosSetField(DK_TransformParams, cosParams);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDSignatureReference(object);
        }
    }
}

