/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.parser;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class CSContentParser
extends PDFParser {
    private static final COSObject[] EMPTY_OPERANDS = new COSObject[0];
    private Object[] operands = new Object[10];
    private int size = 0;

    protected static boolean accepts(CSOperation operation) {
        byte[] token = operation.getOperatorToken();
        switch (token[0]) {
            case 113: {
                return token.length == 1;
            }
            case 81: {
                return token.length == 1;
            }
            case 84: {
                switch (token[1]) {
                    case 106: {
                        return token.length == 2;
                    }
                    case 74: {
                        return token.length == 2;
                    }
                    case 102: {
                        return token.length == 2;
                    }
                    case 100: {
                        return token.length == 2;
                    }
                    case 76: {
                        return token.length == 2;
                    }
                    case 68: {
                        return token.length == 2;
                    }
                    case 99: {
                        return token.length == 2;
                    }
                    case 109: {
                        return token.length == 2;
                    }
                    case 114: {
                        return token.length == 2;
                    }
                    case 115: {
                        return token.length == 2;
                    }
                    case 119: {
                        return token.length == 2;
                    }
                    case 122: {
                        return token.length == 2;
                    }
                    case 42: {
                        return token.length == 2;
                    }
                }
                break;
            }
            case 110: {
                return token.length == 1;
            }
            case 115: {
                if (token.length == 1) {
                    return true;
                }
                switch (token[1]) {
                    case 99: {
                        if (token.length == 2) {
                            return true;
                        }
                        return token.length == 3;
                    }
                    case 104: {
                        return token.length == 2;
                    }
                }
                break;
            }
            case 103: {
                if (token.length == 1) {
                    return true;
                }
                return token.length == 2;
            }
            case 114: {
                switch (token[1]) {
                    case 101: {
                        return token.length == 2;
                    }
                    case 103: {
                        return token.length == 2;
                    }
                    case 105: {
                        return token.length == 2;
                    }
                }
                break;
            }
            case 82: {
                return token.length == 2;
            }
            case 109: {
                return token.length == 1;
            }
            case 108: {
                return token.length == 1;
            }
            case 102: {
                if (token.length == 1) {
                    return true;
                }
                return token.length == 2;
            }
            case 66: {
                if (token.length == 1) {
                    return true;
                }
                switch (token[1]) {
                    case 42: {
                        return token.length == 2;
                    }
                    case 84: {
                        return token.length == 2;
                    }
                    case 77: {
                        return token.length == 3;
                    }
                    case 68: {
                        return token.length == 3;
                    }
                    case 73: {
                        return token.length == 2;
                    }
                    case 88: {
                        return token.length == 2;
                    }
                }
                break;
            }
            case 98: {
                if (token.length == 1) {
                    return true;
                }
                return token.length == 2;
            }
            case 83: {
                if (token.length == 1) {
                    return true;
                }
                if (token.length == 2) {
                    return true;
                }
                return token.length == 3;
            }
            case 104: {
                return token.length == 1;
            }
            case 87: {
                if (token.length == 1) {
                    return true;
                }
                return token.length == 2;
            }
            case 99: {
                if (token.length == 1) {
                    return true;
                }
                switch (token[1]) {
                    case 109: {
                        return token.length == 2;
                    }
                    case 115: {
                        return token.length == 2;
                    }
                }
                break;
            }
            case 69: {
                switch (token[1]) {
                    case 84: {
                        return token.length == 2;
                    }
                    case 77: {
                        return token.length == 3;
                    }
                    case 73: {
                        return token.length == 2;
                    }
                    case 88: {
                        return token.length == 2;
                    }
                }
                break;
            }
            case 71: {
                return token.length == 1;
            }
            case 39: {
                return token.length == 1;
            }
            case 34: {
                return token.length == 1;
            }
            case 67: {
                return token.length == 2;
            }
            case 100: {
                if (token.length == 1) {
                    return true;
                }
                switch (token[1]) {
                    case 48: {
                        return token.length == 2;
                    }
                    case 49: {
                        return token.length == 2;
                    }
                }
                break;
            }
            case 68: {
                switch (token[1]) {
                    case 111: {
                        return token.length == 2;
                    }
                    case 80: {
                        return token.length == 2;
                    }
                }
                break;
            }
            case 70: {
                return token.length == 1;
            }
            case 105: {
                return token.length == 1;
            }
            case 73: {
                return token.length == 2;
            }
            case 106: {
                return token.length == 1;
            }
            case 74: {
                return token.length == 1;
            }
            case 75: {
                return token.length == 1;
            }
            case 107: {
                return token.length == 1;
            }
            case 77: {
                if (token.length == 1) {
                    return true;
                }
                return token.length == 2;
            }
            case 118: {
                return token.length == 1;
            }
            case 119: {
                return token.length == 1;
            }
            case 121: {
                return token.length == 1;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    protected COSIndirectObject createObjectReference(IRandomAccess input) throws IOException, COSLoadException {
        COSLoadError e = new COSLoadError("indirect objects not allowed in streams at character index " + input.getOffset());
        this.handleError(e);
        return null;
    }

    protected void parseImageData(IRandomAccess input, COSStream cosStream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int next = input.read();
        while (next != -1) {
            if (next == 10 || next == 13 || next == 32) {
                long mark = input.getOffset();
                try {
                    CSOperation tempOperation;
                    int tempNext = input.read();
                    if (tempNext == 69 && (tempNext = input.read()) == 73 && ((tempOperation = this.parseOperation(input)) == null || CSContentParser.accepts(tempOperation))) {
                        break;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    input.seek(mark);
                }
            }
            bos.write(next);
            next = input.read();
        }
        cosStream.setEncodedBytes(bos.toByteArray());
    }

    protected CSOperation parseOperation(IRandomAccess input) throws IOException, COSLoadException {
        while (true) {
            Object element;
            if ((element = this.parseElement(input)) instanceof byte[]) {
                COSObject[] copyOperands;
                if (this.size == 0) {
                    copyOperands = EMPTY_OPERANDS;
                } else {
                    copyOperands = new COSObject[this.size];
                    System.arraycopy(this.operands, 0, copyOperands, 0, this.size);
                }
                this.size = 0;
                return new CSOperation((byte[])element, copyOperands);
            }
            if (element == null) {
                int next = input.read();
                if (next != -1 && next != 4) {
                    input.seekBy(-1L);
                    COSLoadError e = new COSLoadError("unexpected char (" + (char)next + ") at character index " + input.getOffset());
                    this.handleError(e);
                }
                this.size = 0;
                return null;
            }
            if (this.size >= this.operands.length) {
                Object[] newOperands = new Object[this.size << 2];
                System.arraycopy(this.operands, 0, newOperands, 0, this.size);
                this.operands = newOperands;
            }
            this.operands[this.size++] = element;
        }
    }

    protected CSOperation parseOperationEI(IRandomAccess input, COSDictionary parameters) throws IOException, COSLoadException {
        COSStream cosStream = COSStream.create(parameters);
        this.parseImageData(input, cosStream);
        this.operands[this.size++] = cosStream;
        Object element = this.parseElement(input);
        if (!(element instanceof byte[])) {
            COSLoadError e = new COSLoadError("EI expected at character index " + input.getOffset());
            this.handleError(e);
        }
        COSObject[] copy = new COSObject[this.size];
        System.arraycopy(this.operands, 0, copy, 0, this.size);
        CSOperation op = new CSOperation((byte[])element, copy);
        this.size = 0;
        return op;
    }

    public CSContent parseStream(byte[] data) throws IOException, COSLoadException {
        return this.parseStream((IRandomAccess)new RandomAccessByteArray(data));
    }

    public CSContent parseStream(IRandomAccess input) throws IOException, COSLoadException {
        CSContent streamContent = CSContent.createNew();
        CSOperation op;
        while ((op = this.parseOperation(input)) != null) {
            byte[] operatorToken = op.getOperatorToken();
            if (operatorToken.length == 2 && operatorToken[0] == 73 && operatorToken[1] == 68) {
                COSDictionary parameters = COSDictionary.create();
                Iterator iterator = op.getOperands();
                while (iterator.hasNext()) {
                    parameters.put(((COSObject)iterator.next()).asName(), ((COSObject)iterator.next()).copyShallow());
                }
                op = this.parseOperationEI(input, parameters);
                if (op == null) continue;
                streamContent.addOperation(op);
                continue;
            }
            streamContent.addOperation(op);
        }
        return streamContent;
    }
}

