/*
 * Decompiled with CFR 0.152.
 */
package splmm.Gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import freemind.controller.Controller;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.view.mindmapview.NodeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import splmm.Gui.Transferable.TitleLinkPair;
import splmm.SciPloreUtils;
import splmm.SciPloreWebClient;
import splmm.Thread.EventSenderThread;

public class RecommenderPanel {
    private JPanel panelMain;
    private JLabel labelMoreInfo;
    private JLabel labelFirstRecommTitle;
    private JLabel labelSecondRecommTitle;
    private JLabel labelThirdRecommTitle;
    private JPanel panelRecommendations;
    private JLabel labelHeader;
    private JPanel panelWait;
    private JLabel labelWait;
    private Controller controller;
    private String labelFirstRecommTitleText;
    private String labelSecondRecommTitleText;
    private String labelThirdRecommTitleText;
    private RecommenderTask task;
    private URL labelFirstRecommLink;
    private URL labelSecondRecommLink;
    private URL labelThirdRecommLink;
    private List<Integer> recommEventIDs;

    public RecommenderPanel(Controller c) {
        this.$$$setupUI$$$();
        this.controller = c;
        this.setListeners();
        this.labelMoreInfo.setCursor(Cursor.getPredefinedCursor(12));
        this.labelMoreInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    RecommenderPanel.this.controller.getFrame().openDocument(new URL("http://www.sciplore.org/rec_splmm_en.php"));
                    new EventSenderThread(SciPloreUtils.EVENT_MORE_INFO_RECOMM, "");
                }
                catch (Exception e1) {
                    SciPloreUtils.logException(this.getClass().getName(), e1, Level.WARNING);
                }
            }
        });
        this.labelFirstRecommTitle.setCursor(Cursor.getPredefinedCursor(12));
        this.labelFirstRecommTitle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (RecommenderPanel.this.recommEventIDs.get(0) != null) {
                        new EventSenderThread(SciPloreUtils.EVENT_RANDOM_RECOMMENDATION_CLICKED, ((Integer)RecommenderPanel.this.recommEventIDs.get(0)).toString());
                    }
                    RecommenderPanel.this.controller.getFrame().openDocument(RecommenderPanel.this.labelFirstRecommLink);
                }
                catch (Exception e1) {
                    SciPloreUtils.logException(this.getClass().getName(), e1, Level.WARNING);
                }
            }
        });
        this.labelSecondRecommTitle.setCursor(Cursor.getPredefinedCursor(12));
        this.labelSecondRecommTitle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (RecommenderPanel.this.recommEventIDs.get(1) != null) {
                        new EventSenderThread(SciPloreUtils.EVENT_RANDOM_RECOMMENDATION_CLICKED, ((Integer)RecommenderPanel.this.recommEventIDs.get(1)).toString());
                    }
                    RecommenderPanel.this.controller.getFrame().openDocument(RecommenderPanel.this.labelSecondRecommLink);
                }
                catch (Exception e1) {
                    SciPloreUtils.logException(this.getClass().getName(), e1, Level.WARNING);
                }
            }
        });
        this.labelThirdRecommTitle.setCursor(Cursor.getPredefinedCursor(12));
        this.labelThirdRecommTitle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (RecommenderPanel.this.recommEventIDs.get(2) != null) {
                        new EventSenderThread(SciPloreUtils.EVENT_RANDOM_RECOMMENDATION_CLICKED, ((Integer)RecommenderPanel.this.recommEventIDs.get(2)).toString());
                    }
                    RecommenderPanel.this.controller.getFrame().openDocument(RecommenderPanel.this.labelThirdRecommLink);
                }
                catch (Exception e1) {
                    SciPloreUtils.logException(this.getClass().getName(), e1, Level.WARNING);
                }
            }
        });
        this.labelWait.setIcon(new ImageIcon(this.controller.getResource("images/ajax-loader.gif")));
        this.panelWait.setVisible(false);
        MindMapNode node = this.controller.getModeController().getSelected();
        if (node != null) {
            this.task = new RecommenderTask(node);
            this.task.execute();
        } else {
            this.panelRecommendations.setVisible(false);
        }
    }

    private void setListeners() {
        this.controller.getModeController().registerNodeSelectionListener(new RecommenderNodeSelectionListener());
    }

    public void update(Controller controller) {
        this.controller = controller;
        this.setListeners();
    }

    public void updateRecommendationLabels() {
        this.setTitleLabelsWidth();
        this.labelFirstRecommTitle.setText(this.getOptimalString(this.labelFirstRecommTitle, this.labelFirstRecommTitleText));
        this.labelFirstRecommTitle.setToolTipText(this.labelFirstRecommTitleText);
        this.labelSecondRecommTitle.setText(this.getOptimalString(this.labelSecondRecommTitle, this.labelSecondRecommTitleText));
        this.labelSecondRecommTitle.setToolTipText(this.labelSecondRecommTitleText);
        this.labelThirdRecommTitle.setText(this.getOptimalString(this.labelThirdRecommTitle, this.labelThirdRecommTitleText));
        this.labelThirdRecommTitle.setToolTipText(this.labelThirdRecommTitleText);
    }

    public JPanel getPanelMain() {
        return this.panelMain;
    }

    private String getOptimalString(Component c, String s) {
        if (s == null || c == null) {
            return null;
        }
        boolean addDots = false;
        boolean addSecondLine = false;
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int width = fm.stringWidth(s);
        String temp = s;
        while (width > c.getWidth() && s.length() > 1) {
            addSecondLine = true;
            s = s.substring(0, s.length() - 2);
            width = fm.stringWidth(s);
        }
        if (addSecondLine) {
            String secondLine = temp.substring(s.length(), temp.length());
            width = fm.stringWidth(secondLine);
            while (width > c.getWidth() && secondLine.length() > 1) {
                addDots = true;
                secondLine = secondLine.substring(0, secondLine.length() - 2);
                width = fm.stringWidth(secondLine + "...");
            }
            s = addDots ? s + "<br>" + secondLine + "..." : s + "<br>" + secondLine;
        }
        s = "<html><u>" + s + "</u><html>";
        return s;
    }

    private void setTitleLabelsWidth() {
        this.panelRecommendations.setSize(this.panelMain.getWidth() - 18, this.panelRecommendations.getHeight());
        int width = this.panelRecommendations.getWidth() - 20;
        this.labelFirstRecommTitle.setSize(width, this.labelFirstRecommTitle.getHeight());
        this.labelSecondRecommTitle.setSize(width, this.labelSecondRecommTitle.getHeight());
        this.labelThirdRecommTitle.setSize(width, this.labelThirdRecommTitle.getHeight());
    }

    public int getMinimumWidth() {
        FontMetrics fm = this.labelHeader.getFontMetrics(this.labelHeader.getFont());
        return fm.stringWidth(this.labelHeader.getText() + "OOO");
    }

    public void executeWait(int n) {
        long t1;
        long t0 = System.currentTimeMillis();
        while ((t1 = System.currentTimeMillis()) - t0 < (long)n) {
        }
    }

    private void $$$setupUI$$$() {
        this.panelMain = new JPanel();
        this.panelMain.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 3, 0, 3), -1, -1));
        this.panelMain.add((Component)panel1, "South");
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), null));
        this.panelRecommendations = new JPanel();
        this.panelRecommendations.setLayout(new BorderLayout(0, 0));
        this.panelRecommendations.setBackground(new Color(-1));
        panel1.add((Component)this.panelRecommendations, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.panelRecommendations.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel2.setBackground(new Color(-1));
        this.panelRecommendations.add((Component)panel2, "Center");
        this.labelSecondRecommTitle = new JLabel();
        this.labelSecondRecommTitle.setFont(new Font("SansSerif", this.labelSecondRecommTitle.getFont().getStyle(), 10));
        this.labelSecondRecommTitle.setForeground(new Color(-16776961));
        this.labelSecondRecommTitle.setText("");
        panel2.add((Component)this.labelSecondRecommTitle, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, 30), null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel3.setBackground(new Color(-1));
        this.panelRecommendations.add((Component)panel3, "North");
        this.labelFirstRecommTitle = new JLabel();
        this.labelFirstRecommTitle.setFont(new Font("SansSerif", this.labelFirstRecommTitle.getFont().getStyle(), 10));
        this.labelFirstRecommTitle.setForeground(new Color(-16776961));
        this.labelFirstRecommTitle.setText("");
        panel3.add((Component)this.labelFirstRecommTitle, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, 30), null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel4.setBackground(new Color(-1));
        this.panelRecommendations.add((Component)panel4, "South");
        this.labelThirdRecommTitle = new JLabel();
        this.labelThirdRecommTitle.setFont(new Font("SansSerif", this.labelThirdRecommTitle.getFont().getStyle(), 10));
        this.labelThirdRecommTitle.setForeground(new Color(-16776961));
        this.labelThirdRecommTitle.setText("");
        panel4.add((Component)this.labelThirdRecommTitle, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, 30), null, null, 0, false));
        this.labelHeader = new JLabel();
        this.labelHeader.setFont(new Font(this.labelHeader.getFont().getName(), 1, 12));
        this.labelHeader.setText("These papers might be of interest");
        panel1.add((Component)this.labelHeader, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.labelMoreInfo = new JLabel();
        this.labelMoreInfo.setFont(new Font(this.labelMoreInfo.getFont().getName(), this.labelMoreInfo.getFont().getStyle(), 11));
        this.labelMoreInfo.setForeground(new Color(-16776961));
        this.labelMoreInfo.setHorizontalAlignment(10);
        this.labelMoreInfo.setHorizontalTextPosition(10);
        this.$$$loadLabelText$$$(this.labelMoreInfo, ResourceBundle.getBundle("splmm/Localization/splmm").getString("more.information"));
        panel1.add((Component)this.labelMoreInfo, new GridConstraints(5, 0, 1, 1, 4, 0, 5, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, new Dimension(-1, 3), null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 4, new Dimension(-1, 3), null, null, 0, false));
        this.panelWait = new JPanel();
        this.panelWait.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panelWait.setBackground(new Color(-1));
        panel1.add((Component)this.panelWait, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 90), new Dimension(-1, 90), null, 0, false));
        this.panelWait.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.labelWait = new JLabel();
        this.labelWait.setText("");
        this.panelWait.add((Component)this.labelWait, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, new Dimension(-1, 90), new Dimension(-1, 90), null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panelMain;
    }

    public class RecommenderTask
    extends SwingWorker<Void, Void> {
        MindMapNode node;
        List<TitleLinkPair> documents;

        public RecommenderTask(MindMapNode node) {
            this.node = node;
        }

        @Override
        protected Void doInBackground() throws Exception {
            String searchText = this.node.getText();
            searchText = this.replaceFileExtension(searchText);
            searchText = searchText.replace("(", " ");
            searchText = searchText.replace(")", " ");
            searchText = searchText.replace("or", " ");
            searchText = searchText.replace("-", " ");
            searchText = searchText.replace("+", " ");
            searchText = searchText.replace("$", " ");
            searchText = searchText.replace("site:", " ");
            searchText = searchText.replaceAll("[0-9]", " ");
            searchText = searchText.replace("_", " ");
            this.documents = SciPloreWebClient.getRecommendations(this.node.getText());
            this.documents = this.getCleanedList(this.documents);
            this.documents = this.randomizeList();
            if (this.documents != null && this.documents.size() >= 3) {
                RecommenderPanel.this.recommEventIDs = new ArrayList();
                for (TitleLinkPair document : this.documents) {
                    Integer id = SciPloreWebClient.sendRecommenderEvent(SciPloreUtils.EVENT_RANDOM_RECOMMENDATION, null, this.documents.indexOf(document) + 1, this.node.getText(), document);
                    RecommenderPanel.this.recommEventIDs.add(id);
                }
            }
            return null;
        }

        private String replaceFileExtension(String searchText) {
            if (!searchText.contains(".")) {
                return searchText;
            }
            String fileExtension = searchText.substring(searchText.lastIndexOf("."));
            int extensionLength = fileExtension.substring(1).length();
            if (extensionLength == 3 || extensionLength == 4) {
                searchText = searchText.substring(0, searchText.lastIndexOf("."));
            }
            return searchText;
        }

        private List<TitleLinkPair> getCleanedList(List<TitleLinkPair> documents) {
            MindMapController mindMapController = (MindMapController)RecommenderPanel.this.controller.getModeController();
            Set<String> cleanTitleSet = this.getCleanTitlesSet(mindMapController.getRootNode());
            ArrayList<TitleLinkPair> doubleEntries = new ArrayList<TitleLinkPair>();
            for (TitleLinkPair document : documents) {
                if (!cleanTitleSet.contains(this.generateCleanTitle(document.getTitle()))) continue;
                doubleEntries.add(document);
            }
            documents.removeAll(doubleEntries);
            return documents;
        }

        private List<TitleLinkPair> randomizeList() {
            ArrayList<TitleLinkPair> result = new ArrayList<TitleLinkPair>();
            if (this.documents != null && this.documents.size() >= 3) {
                if (this.documents.size() > 10) {
                    List<TitleLinkPair> list1 = this.documents.subList(0, 9);
                    List<TitleLinkPair> list2 = this.documents.subList(10, this.documents.size() - 1);
                    Collections.shuffle(list1);
                    Collections.shuffle(list2);
                    result.add(list1.get(0));
                    result.add(list1.get(1));
                    result.add(list2.get(0));
                } else {
                    Collections.shuffle(this.documents);
                    result.add(this.documents.get(0));
                    result.add(this.documents.get(1));
                    result.add(this.documents.get(2));
                }
                Collections.shuffle(result);
                return result;
            }
            return null;
        }

        protected Set<String> getCleanTitlesSet(MindMapNode node) {
            HashSet<String> result = new HashSet<String>();
            if (this.isLinkedToFile(node) && node.getLink() != null && !node.getLink().isEmpty()) {
                String bibtexTitle;
                File linkedFile = SciPloreUtils.getFileFromLink(node);
                String filename = this.getFileName(linkedFile);
                if (filename != null) {
                    result.add(this.generateCleanTitle(filename));
                }
                if (!node.getText().equalsIgnoreCase(linkedFile.getName())) {
                    result.add(this.generateCleanTitle(node.getText()));
                }
                if ((bibtexTitle = this.getBibtexTitle(node)) != null && !bibtexTitle.isEmpty()) {
                    result.add(this.generateCleanTitle(bibtexTitle));
                }
            }
            List children = node.getChildren();
            for (MindMapNode child : children) {
                result.addAll(this.getCleanTitlesSet(child));
            }
            return result;
        }

        private String getBibtexTitle(MindMapNode node) {
            if (node.getAttributeTableLength() > 0) {
                List keys = node.getAttributeKeyList();
                if (keys.contains("splmm_reftitle")) {
                    return node.getAttribute("splmm_reftitle");
                }
                return null;
            }
            return null;
        }

        protected boolean isLinkedToFile(MindMapNode node) {
            String link = SciPloreUtils.getLink(node, RecommenderPanel.this.controller);
            if (link == null) {
                return false;
            }
            File file = SciPloreUtils.getFileFromLink(node);
            return file != null && file.exists();
        }

        private String getFileName(File file) {
            if (file != null && file.exists()) {
                String filename = file.getName();
                if (!filename.contains(".")) {
                    return null;
                }
                filename = filename.substring(0, filename.lastIndexOf("."));
                return filename;
            }
            return null;
        }

        public String generateCleanTitle(String title) {
            if (title == null) {
                return "";
            }
            if ((title = title.toLowerCase().replaceAll("[^A-Za-z0-9]", "")).length() > 1024) {
                title = title.substring(0, 1023);
            }
            return title;
        }

        @Override
        protected void done() {
            super.done();
            RecommenderPanel.this.setTitleLabelsWidth();
            if (this.documents != null && this.documents.size() >= 3) {
                RecommenderPanel.this.labelFirstRecommTitleText = this.documents.get(0).getTitle();
                RecommenderPanel.this.labelSecondRecommTitleText = this.documents.get(1).getTitle();
                RecommenderPanel.this.labelThirdRecommTitleText = this.documents.get(2).getTitle();
                RecommenderPanel.this.labelFirstRecommTitle.setText(RecommenderPanel.this.getOptimalString(RecommenderPanel.this.labelFirstRecommTitle, RecommenderPanel.this.labelFirstRecommTitleText));
                RecommenderPanel.this.labelSecondRecommTitle.setText(RecommenderPanel.this.getOptimalString(RecommenderPanel.this.labelSecondRecommTitle, RecommenderPanel.this.labelSecondRecommTitleText));
                RecommenderPanel.this.labelThirdRecommTitle.setText(RecommenderPanel.this.getOptimalString(RecommenderPanel.this.labelThirdRecommTitle, RecommenderPanel.this.labelThirdRecommTitleText));
                RecommenderPanel.this.labelFirstRecommLink = this.documents.get(0).getLink();
                RecommenderPanel.this.labelSecondRecommLink = this.documents.get(1).getLink();
                RecommenderPanel.this.labelThirdRecommLink = this.documents.get(2).getLink();
            }
            RecommenderPanel.this.panelMain.updateUI();
            RecommenderPanel.this.task = null;
        }
    }

    private class RecommenderNodeSelectionListener
    implements ModeController.NodeSelectionListener {
        private RecommenderNodeSelectionListener() {
        }

        @Override
        public void onUpdateNodeHook(MindMapNode node) {
            MindMapMapModel model = (MindMapMapModel)node.getMap();
            if (model.getAutomaticSaveLock()) {
                return;
            }
            if (node.getText() == null || node.getText().isEmpty()) {
                return;
            }
            if (RecommenderPanel.this.task != null) {
                RecommenderPanel.this.task.cancel(true);
            }
            RecommenderPanel.this.task = new RecommenderTask(node);
            RecommenderPanel.this.task.execute();
        }

        @Override
        public void onSelectHook(NodeView node) {
            MindMapMapModel model = (MindMapMapModel)node.getModel().getMap();
            if (model.getAutomaticSaveLock()) {
                return;
            }
            if (node.getModel().getText() == null || node.getModel().getText().isEmpty()) {
                return;
            }
            if (RecommenderPanel.this.task != null) {
                RecommenderPanel.this.task.cancel(true);
            }
            RecommenderPanel.this.task = new RecommenderTask(node.getModel());
            RecommenderPanel.this.task.execute();
        }

        @Override
        public void onDeselectHook(NodeView node) {
        }

        @Override
        public void onSaveNode(MindMapNode node) {
        }
    }
}

