/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import splmm.BookmarkMindMapNode;
import splmm.SciPloreUtils;

public class BibTex {
    private String key;
    private String path;
    private String title;
    private String authors;
    private String year;
    private String journal;
    private String booktitle;

    public BibTex() {
    }

    public BibTex(String key, String path) {
        this.key = key;
        this.path = path;
    }

    public BibTex(String key, String path, String title) {
        this.key = key;
        this.path = path;
        this.title = title;
    }

    public String getBooktitle() {
        return this.booktitle;
    }

    public void setBooktitle(String booktitle) {
        this.booktitle = booktitle;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getJournal() {
        return this.journal;
    }

    public void setJournal(String journal) {
        this.journal = journal;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return this.key + " " + this.path;
    }

    public HashMap<String, Collection<BibTex>> readBibtex(File file) {
        HashMap<String, Collection<BibTex>> bibTexMap = new HashMap<String, Collection<BibTex>>();
        if (file != null && file.exists() && file.getName().endsWith("bib")) {
            try {
                String charset = Charset.defaultCharset().name();
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                CharsetDetector cd = new CharsetDetector();
                cd.setText((InputStream)bis);
                CharsetMatch cm = cd.detect();
                if (cm != null) {
                    charset = cm.getName();
                }
                bis.close();
                ParserResult result = OpenDatabaseAction.loadDatabase((File)file, (String)charset);
                BibtexDatabase db = result.getDatabase();
                for (BibtexEntry entry : db.getEntries()) {
                    String[] paths;
                    String files = entry.getField("file");
                    if (files == null || files.isEmpty()) continue;
                    for (String path : paths = files.split("(?<!\\\\);")) {
                        if ((path = this.parsePath(path)) == null) continue;
                        if (this.isRelativePath(path)) {
                            path = this.CreateAbsolutePath(file, path);
                        } else if (path.contains("\\:")) {
                            path = path.replace("\\:", ":");
                        }
                        String title = this.parseTitle(entry.getField("title"));
                        BibTex bib = new BibTex(entry.getCiteKey(), path, title);
                        bib.setAuthors(entry.getField("author"));
                        bib.setYear(entry.getField("year"));
                        bib.setJournal(this.parseJournal(entry.getField("journal")));
                        bib.setBooktitle(entry.getField("booktitle"));
                        Collection<BibTex> values = bibTexMap.get(path);
                        if (values == null) {
                            values = new ArrayList<BibTex>();
                            bibTexMap.put(path, values);
                        }
                        values.add(bib);
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bibTexMap;
    }

    private String parseJournal(String journal) {
        if (journal == null) {
            return null;
        }
        journal = journal.replace("{", "");
        journal = journal.replace("}", "");
        return journal;
    }

    private String parseTitle(String title) {
        if (title != null) {
            title = title.replaceAll("\\{", "");
            title = title.replaceAll("\\}", "");
            title = title.replaceAll("\t", " ");
            title = title.replaceAll("\r\n", "");
            return title;
        }
        return null;
    }

    private String parsePath(String path) {
        if (path != null) {
            String fileType = "";
            try {
                if (path.matches("[^:]*:([a-zA-Z]\\\\:){1}[^:]*:[pP][dD][fF]")) {
                    int splitIndex = path.lastIndexOf(":");
                    fileType = path.substring(splitIndex + 1);
                    path = path.substring(path.indexOf(":") + 1, splitIndex);
                } else if (path.matches("([a-zA-Z]\\\\:){1}[^:]*:[pP][dD][fF]")) {
                    int splitIndex = path.lastIndexOf(":");
                    fileType = path.substring(splitIndex + 1);
                    path = path.substring(0, splitIndex);
                } else if (!path.matches("([a-zA-Z]\\\\:).*") && path.matches("[^:]*:[^:]*:[pP][dD][fF]")) {
                    int splitIndex = path.lastIndexOf(":");
                    fileType = path.substring(splitIndex + 1);
                    path = path.substring(path.indexOf(":") + 1, splitIndex);
                } else if (!path.matches("([a-zA-Z]\\\\:).*") && path.matches("[^:]*:[pP][dD][fF]")) {
                    int splitIndex = path.lastIndexOf(":");
                    fileType = path.substring(splitIndex + 1);
                    path = path.substring(0, splitIndex);
                } else if (path.endsWith(".pdf") || path.endsWith(".PDF")) {
                    fileType = "pdf";
                    if (path.matches("[^:]*:([a-zA-Z]\\\\:).*")) {
                        path = path.substring(path.indexOf(":") + 1);
                    } else if (!path.matches("([a-zA-Z]\\\\:).*") && path.matches("[^:]*:.*")) {
                        path = path.substring(path.indexOf(":") + 1);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                return null;
            }
            if (path.contains("backslash") || path.matches("([a-zA-Z]\\\\:/).*")) {
                path = this.parseMendely(path);
            }
            path = path.replaceAll("\\\\;", ";");
            path = path.replaceAll("\r\n", "");
            path = path.replaceAll("\t", " ");
            path = path.replace("\\\\", "\\");
            if (fileType.equalsIgnoreCase("pdf")) {
                return path;
            }
        }
        return null;
    }

    private String parseMendely(String path) {
        path = path.replace("$\\backslash$", "");
        path = path.replace("\\", "");
        if ((path = path.replace('/', '\\')).contains("\"{o}")) {
            path = path.replace("\"{o}", "\u00c3\u00b6");
        }
        if (path.contains("\"{u}")) {
            path = path.replace("\"{u}", "\u00c3\u00bc");
        }
        if (path.contains("\"{a}")) {
            path = path.replace("\"{a}", "\u00c3\u00a4");
        }
        if (path.contains("\"{O}")) {
            path = path.replace("\"{O}", "\u00c3\u2013");
        }
        if (path.contains("\"{U}")) {
            path = path.replace("\"{U}", "\u00c3\u0153");
        }
        if (path.contains("\"{A}")) {
            path = path.replace("\"{A}", "\u00c3\u201e");
        }
        return path;
    }

    private String CreateAbsolutePath(File file, String path) {
        try {
            File parentFolder = new File(file.getParent());
            File pdf = new File(parentFolder, path);
            return pdf.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            String absolutePath = file.getAbsolutePath();
            absolutePath = absolutePath.replace(file.getName(), "");
            return absolutePath + path;
        }
    }

    private boolean isRelativePath(String path) {
        return !path.contains(":");
    }

    public static RefKeyState addBibtexData(MindMapNode node, HashMap<String, Collection<BibTex>> bibTexMap) {
        String link = SciPloreUtils.getLink(node, node.getMap().getModeController().getController());
        if (link != null && !link.isEmpty()) {
            Iterator<BibTex> i$;
            File file = new File(link);
            Collection<BibTex> values = bibTexMap.get(link);
            if (values != null && values.size() >= 1 && (i$ = values.iterator()).hasNext()) {
                BibTex bib = i$.next();
                RefKeyState state = BibTex.setAttribute(node, bib.getKey(), SciPloreUtils.SPLMM_REFKEY_NAME);
                BibTex.setAttribute(node, bib.getTitle(), "splmm_reftitle");
                BibTex.setAttribute(node, bib.getAuthors(), "splmm_refauthors");
                BibTex.setAttribute(node, bib.getYear(), "splmm_refyear");
                BibTex.setAttribute(node, bib.getJournal(), "splmm_publishedin");
                BibTex.setAttribute(node, bib.getBooktitle(), "splmm_publishedin");
                return state;
            }
        }
        return RefKeyState.noRefkey;
    }

    private static RefKeyState setAttribute(MindMapNode node, String value, String attributeKey) {
        if (node == null || attributeKey == null || attributeKey.isEmpty()) {
            return RefKeyState.noRefkey;
        }
        if (value == null && attributeKey.equals(SciPloreUtils.SPLMM_REFKEY_NAME)) {
            value = "";
        }
        if (value == null && !attributeKey.equals(SciPloreUtils.SPLMM_REFKEY_NAME)) {
            return RefKeyState.noRefkey;
        }
        Attribute pAttribute = new Attribute(attributeKey, value);
        if (node.getAttributeKeyList().size() == 0) {
            node.createAttributeTableModel();
        }
        if (BibTex.HasSplmmAttribute(attributeKey, node)) {
            Attribute splmmAttribute = BibTex.GetSplmmAttribute(attributeKey, node);
            splmmAttribute.setValue(value);
            node.getMap().getModeController().nodeChanged(node);
            BookmarkMindMapNode.SetOptimalColumnWidth(node);
            if (attributeKey.equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME) && splmmAttribute.getValue().equalsIgnoreCase(value)) {
                return RefKeyState.oldRefkey;
            }
            if (attributeKey.equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME) && !splmmAttribute.getValue().equalsIgnoreCase(value)) {
                return RefKeyState.newRefkey;
            }
        } else {
            node.getAttributes().addRowNoUndo(pAttribute);
            node.getMap().getModeController().nodeChanged(node);
            BookmarkMindMapNode.SetOptimalColumnWidth(node);
            if (attributeKey.equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME)) {
                return RefKeyState.newRefkey;
            }
        }
        return RefKeyState.noRefkey;
    }

    private static Attribute GetSplmmAttribute(String attributeKey, MindMapNode node) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attributeKey)) continue;
            return a;
        }
        return null;
    }

    private static boolean HasSplmmAttribute(String attributeKey, MindMapNode node) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attributeKey)) continue;
            return true;
        }
        return false;
    }

    public static enum RefKeyState {
        noRefkey,
        oldRefkey,
        newRefkey;

    }
}

