/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.attributes.Attribute;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.NodeView;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public class CopyReferenceAttributeAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    MindMapController controller;

    public CopyReferenceAttributeAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_attributes_copy"));
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LinkedList selection = this.controller.getView().getSelecteds();
        Vector attributes = new Vector();
        for (NodeView nodeView : selection) {
            attributes.addAll(nodeView.getAttributeView().getAttributes().getAttributes());
        }
        String refkeys = "";
        int counter = 0;
        for (Attribute attribute : attributes) {
            if (!attribute.getName().equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME)) continue;
            refkeys = counter > 0 ? refkeys + "," + attribute.getValue() : refkeys + attribute.getValue();
            ++counter;
        }
        if (counter > 0) {
            StringSelection ss = new StringSelection(refkeys);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
            try {
                String content = "" + ss.getTransferData(DataFlavor.stringFlavor);
                if (content != null) {
                    new EventSenderThread(SciPloreUtils.EVENT_COPY_REFKEYS, content);
                } else {
                    new EventSenderThread(SciPloreUtils.EVENT_COPY_REFKEYS, "");
                }
            }
            catch (UnsupportedFlavorException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

