/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.common.OptionalDontShowMeAgainDialog;
import freemind.main.FreeMindMain;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.LinkRegistryAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.MindMapXMLElement;
import java.awt.Color;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JOptionPane;
import splmm.Gui.Preferences;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.Preferences.UserDataState;
import splmm.SciPloreUtils;
import splmm.SciPloreWebClient;
import splmm.Thread.EventSenderThread;

public class MindMapMapModel
extends MapAdapter {
    public static final String RESTORE_MODE_MIND_MAP = "MindMap:";
    private static final String FREEMIND_VERSION_UPDATER_XSLT = "freemind/modes/mindmapmode/freemind_version_updater.xslt";
    LockManager lockManager = Resources.getInstance().getBoolProperty("experimental_file_locking_on") ? new LockManager() : new DummyLockManager();
    private MindMapLinkRegistry linkRegistry = new LinkRegistryAdapter();
    private Timer timerForAutomaticSaving;
    private String mindmapID;
    private boolean automaticSaveLock = false;
    private static final String[] EXPECTED_START_STRINGS = new String[]{"<map version=\"0.9.0\"", "<map version=\"0.7.1\""};

    public MindMapMapModel(FreeMindMain frame, ModeController modeController) {
        this(null, frame, modeController);
    }

    public MindMapMapModel(MindMapNodeModel root, FreeMindMain frame, ModeController modeController) {
        super(frame, modeController);
        if (root == null) {
            root = new MindMapNodeModel(frame.getResourceString("new_mindmap"), frame, this);
        }
        this.setRoot(root);
        this.readOnly = false;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MindMapMapModel.this.scheduleTimerForAutomaticSaving();
            }
        });
    }

    @Override
    public MindMapLinkRegistry getLinkRegistry() {
        return this.linkRegistry;
    }

    @Override
    public String getRestoreable() {
        return this.getFile() == null ? null : RESTORE_MODE_MIND_MAP + this.getFile().getAbsolutePath();
    }

    public void changeNode(MindMapNode node, String newText) {
        if (((Object)node).toString().startsWith("<html>")) {
            node.setUserObject(HtmlTools.unescapeHTMLUnicodeEntity(newText));
        } else {
            node.setUserObject(newText);
        }
        this.nodeChanged(node);
    }

    public String toString() {
        return this.getFile() == null ? null : this.getFile().getName();
    }

    @Override
    public String getAsHTML(List mindMapNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter fileout = new BufferedWriter(stringWriter);
            MindMapController.saveHTML(mindMapNodes, fileout);
            fileout.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return null;
        }
    }

    @Override
    public String getAsPlainText(List mindMapNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter fileout = new BufferedWriter(stringWriter);
            ListIterator it = mindMapNodes.listIterator();
            while (it.hasNext()) {
                ((MindMapNodeModel)it.next()).saveTXT(fileout, 0);
            }
            fileout.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return null;
        }
    }

    public boolean saveTXT(MindMapNodeModel rootNodeOfBranch, File file) {
        try {
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            rootNodeOfBranch.saveTXT(fileout, 0);
            fileout.close();
            return true;
        }
        catch (Exception e) {
            System.err.println("Error in MindMapMapModel.saveTXT(): ");
            Resources.getInstance().logException(e);
            return false;
        }
    }

    @Override
    public String getAsRTF(List mindMapNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter fileout = new BufferedWriter(stringWriter);
            this.saveRTF(mindMapNodes, fileout);
            fileout.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return null;
        }
    }

    public boolean saveRTF(List mindMapNodes, BufferedWriter fileout) {
        try {
            HashSet colors = new HashSet();
            ListIterator it = mindMapNodes.listIterator();
            while (it.hasNext()) {
                ((MindMapNodeModel)it.next()).collectColors(colors);
            }
            String colorTableString = "{\\colortbl;\\red0\\green0\\blue255;";
            HashMap<Color, Integer> colorTable = new HashMap<Color, Integer>();
            int colorPosition = 2;
            for (Color color : colors) {
                colorTableString = colorTableString + "\\red" + color.getRed() + "\\green" + color.getGreen() + "\\blue" + color.getBlue() + ";";
                colorTable.put(color, new Integer(colorPosition));
                ++colorPosition;
            }
            colorTableString = colorTableString + "}";
            fileout.write("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1033{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}" + colorTableString + "}" + "\\viewkind4\\uc1\\pard\\f0\\fs20{}");
            Iterator it2 = mindMapNodes.listIterator();
            while (it2.hasNext()) {
                ((MindMapNodeModel)it2.next()).saveRTF(fileout, 0, colorTable);
            }
            fileout.write("}");
            return true;
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return false;
        }
    }

    @Override
    public boolean save(File file) {
        return this.saveInternal(file, false);
    }

    private boolean saveInternal(File file, boolean isInternal) {
        if (!isInternal && this.readOnly) {
            System.err.println("Attempt to save read-only map.");
            return false;
        }
        try {
            if (this.timerForAutomaticSaving != null) {
                this.timerForAutomaticSaving.cancel();
            }
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            if (!isInternal) {
                this.setFile(file);
            }
            this.getXml(fileout);
            if (!isInternal) {
                this.setFile(file);
                this.setSaved(true);
            }
            this.scheduleTimerForAutomaticSaving();
            return true;
        }
        catch (FileNotFoundException e) {
            String message = Tools.expandPlaceholders(this.getText("save_failed"), file.getName());
            if (!isInternal) {
                this.getFrame().getController().errorMessage(message);
            } else {
                this.getFrame().out(message);
            }
        }
        catch (Exception e) {
            logger.severe("Error in MindMapMapModel.save(): ");
            System.out.println(SciPloreUtils.getStackTraceAsString(e));
            Resources.getInstance().logException(e);
        }
        this.scheduleTimerForAutomaticSaving();
        return false;
    }

    private void getXml(Writer fileout, boolean saveInvisible) throws IOException {
        if (SplmmPreferences.getBackupSave()) {
            new EventSenderThread(SciPloreUtils.EVENT_FILE_SAVED, this.getFile().getName());
        }
        StringWriter stringWriter = new StringWriter();
        if (this.mindmapID != null) {
            stringWriter.write("<map ");
            stringWriter.write("version=\"0.9.0\" software_name=\"SciPlore_MindMapping\" software_version=\"" + SciPloreUtils.APP_VERSION_SHORT + "\" private=\"1\" mapID=\"" + this.mindmapID + "\">\n");
            stringWriter.write(SciPloreUtils.SAVE_TEXT);
            this.getRegistry().save(stringWriter);
            this.getRootNode().save(stringWriter, this.getLinkRegistry(), saveInvisible, true);
            stringWriter.write("</map>\n");
            if (SplmmPreferences.getBackupSave() && (SplmmPreferences.getAllowBackup().booleanValue() || SplmmPreferences.getAllowIRonMM().booleanValue()) && this.isUserDataValid().booleanValue()) {
                SciPloreWebClient.putMindMap(stringWriter.getBuffer().toString(), this.mindmapID, this.getFile().getName());
            }
        } else {
            stringWriter.write("<map ");
            stringWriter.write("version=\"0.9.0\" software_name=\"SciPlore_MindMapping\" software_version=\"" + SciPloreUtils.APP_VERSION_SHORT + "\" private=\"1\">\n");
            stringWriter.write(SciPloreUtils.SAVE_TEXT);
            this.getRegistry().save(stringWriter);
            this.getRootNode().save(stringWriter, this.getLinkRegistry(), saveInvisible, true);
            stringWriter.write("</map>\n");
            if (SplmmPreferences.getBackupSave() && (SplmmPreferences.getAllowBackup().booleanValue() || SplmmPreferences.getAllowIRonMM().booleanValue()) && this.isUserDataValid().booleanValue()) {
                this.mindmapID = SciPloreWebClient.postMindMap(stringWriter.getBuffer().toString(), this.getFile().getName());
                if (this.mindmapID != null) {
                    stringWriter.getBuffer().insert(stringWriter.getBuffer().indexOf(">"), " mapID=\"" + this.mindmapID + "\"");
                }
            }
        }
        SplmmPreferences.setBackupSave(false);
        fileout.write(stringWriter.getBuffer().toString());
        fileout.close();
    }

    private Boolean isUserDataValid() {
        if (!SplmmPreferences.getCredentialsValidated().booleanValue()) {
            switch (UserDataState.getCurrentState()) {
                case 0: {
                    JOptionPane.showMessageDialog(null, LocalizationSupport.message("enter.user.name.and.password.to.backup.mindmaps"), "Error", 0);
                    Preferences pref = new Preferences(this.getFrame());
                    pref.selectTab(pref.getServicePanel());
                    pref.showPrefs();
                    break;
                }
                case 1: {
                    SciPloreWebClient.ValidationState state = SciPloreWebClient.validateUserData(SplmmPreferences.getUserName(), SplmmPreferences.getPassword());
                    if (state == SciPloreWebClient.ValidationState.VALID || state == SciPloreWebClient.ValidationState.EXCEPTION || state == SciPloreWebClient.ValidationState.CONNECTION_PROBLEM || state == SciPloreWebClient.ValidationState.SERVICE_DOWN) break;
                    Preferences prefs = new Preferences(this.getFrame());
                    prefs.showPrefs(prefs.getServicePanel());
                    break;
                }
                case 2: {
                    SplmmPreferences.createUUID();
                }
            }
        }
        return SplmmPreferences.getCredentialsValidated();
    }

    @Override
    public void getXml(Writer fileout) throws IOException {
        this.getXml(fileout, true);
    }

    @Override
    public void getFilteredXml(Writer fileout) throws IOException {
        this.getXml(fileout, false);
    }

    @Override
    public String tryToLock(File file) throws Exception {
        String lockingUser = this.lockManager.tryToLock(file);
        String lockingUserOfOldLock = this.lockManager.popLockingUserOfOldLock();
        if (lockingUserOfOldLock != null) {
            this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("locking_old_lock_removed"), file.getName(), lockingUserOfOldLock));
        }
        if (lockingUser == null) {
            this.readOnly = false;
        }
        return lockingUser;
    }

    @Override
    public void load(URL url) throws FileNotFoundException, IOException, XMLParseException, URISyntaxException {
        logger.info("Loading file: " + url.toString());
        File file = Tools.urlToFile(url);
        this.load(file);
    }

    @Override
    public void load(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(Tools.expandPlaceholders(this.getText("file_not_found"), file.getPath()));
        }
        if (!file.canWrite()) {
            this.readOnly = true;
        } else {
            try {
                String lockingUser = this.tryToLock(file);
                if (lockingUser != null) {
                    this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("map_locked_by_open"), file.getName(), lockingUser));
                    this.readOnly = true;
                } else {
                    this.readOnly = false;
                }
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
                this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("locking_failed_by_open"), file.getName()));
                this.readOnly = true;
            }
        }
        MindMapNodeModel root = this.loadTree(file);
        if (root != null) {
            this.setRoot(root);
            ((MindMapController)this.mModeController).invokeHooksRecursively(root, this);
        }
        this.setFile(file);
        this.mindmapID = SciPloreUtils.getMindMapID(file);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.lockManager.releaseLock();
        this.lockManager.releaseTimer();
        this.timerForAutomaticSaving.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MindMapNodeModel loadTree(File file) throws XMLParseException, IOException {
        Object mapStart;
        int versionInfoLength = EXPECTED_START_STRINGS[0].length();
        if (file != null) {
            new EventSenderThread(SciPloreUtils.EVENT_FILE_OPENED, file.getName());
        }
        StringBuffer buffer = this.readFileStart(file, versionInfoLength);
        Reader reader = null;
        for (int i = 0; i < EXPECTED_START_STRINGS.length; ++i) {
            versionInfoLength = EXPECTED_START_STRINGS[i].length();
            mapStart = "";
            if (buffer.length() >= versionInfoLength) {
                mapStart = buffer.substring(0, versionInfoLength);
            }
            if (!((String)mapStart).startsWith(EXPECTED_START_STRINGS[i])) continue;
            reader = Tools.getActualReader(file);
            break;
        }
        if (reader == null) {
            int showResult = new OptionalDontShowMeAgainDialog(this.mModeController.getFrame().getJFrame(), this.mModeController.getSelectedView(), "really_convert_to_current_version2", "confirmation", this.mModeController, new OptionalDontShowMeAgainDialog.StandardPropertyHandler(this.mModeController.getController(), "resources_convert_to_current_version"), 0).show().getResult();
            if (showResult != 0) {
                throw new IllegalArgumentException("We should not open the file " + file);
            }
            reader = Tools.getUpdateReader(file, FREEMIND_VERSION_UPDATER_XSLT, this.getFrame());
        }
        try {
            HashMap IDToTarget = new HashMap();
            mapStart = (MindMapNodeModel)this.mModeController.createNodeTreeFromXml(reader, IDToTarget);
            return mapStart;
        }
        catch (Exception ex) {
            String errorMessage = "Error while parsing file:" + ex;
            System.err.println(errorMessage);
            Resources.getInstance().logException(ex);
            MindMapXMLElement mapElement = new MindMapXMLElement(this.mModeController);
            NodeAdapter result = mapElement.createNodeAdapter(this.getFrame(), null);
            result.setText(errorMessage);
            MindMapNodeModel mindMapNodeModel = (MindMapNodeModel)result;
            return mindMapNodeModel;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private StringBuffer readFileStart(File file, int pMinimumLength) {
        BufferedReader in = null;
        StringBuffer buffer = new StringBuffer();
        try {
            String str;
            in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                buffer.append(str);
                if (buffer.length() < pMinimumLength) continue;
            }
            in.close();
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return new StringBuffer();
        }
        return buffer;
    }

    private void scheduleTimerForAutomaticSaving() {
        int numberOfTempFiles = Integer.parseInt(this.getFrame().getProperty("number_of_different_files_for_automatic_save"));
        boolean filesShouldBeDeletedAfterShutdown = Resources.getInstance().getBoolProperty("delete_automatic_saves_at_exit");
        String path = this.getFrame().getProperty("path_to_automatic_saves");
        if (Tools.safeEquals(path, "default")) {
            path = null;
        }
        if (Tools.safeEquals(path, "freemind_home")) {
            path = this.getFrame().getFreemindDirectory();
        }
        int delay = Integer.parseInt(this.getFrame().getProperty("time_for_automatic_save"));
        File dirToStore = null;
        if (path != null && !(dirToStore = new File(path)).isDirectory()) {
            dirToStore = null;
            System.err.println("Temporary directory " + path + " not found. Disabling automatic store.");
            delay = Integer.MAX_VALUE;
            return;
        }
        this.timerForAutomaticSaving = new Timer();
        this.timerForAutomaticSaving.schedule((TimerTask)new DoAutomaticSave(this, numberOfTempFiles, filesShouldBeDeletedAfterShutdown, dirToStore), delay, (long)delay);
    }

    public boolean getAutomaticSaveLock() {
        return this.automaticSaveLock;
    }

    public void setAutomaticSaveLock(boolean automaticSaveLock) {
        this.automaticSaveLock = automaticSaveLock;
    }

    private static class DoAutomaticSave
    extends TimerTask {
        private MindMapMapModel model;
        private Vector tempFileStack;
        private int numberOfFiles;
        private boolean filesShouldBeDeletedAfterShutdown;
        private File pathToStore;
        private int changeState;

        DoAutomaticSave(MindMapMapModel model, int numberOfTempFiles, boolean filesShouldBeDeletedAfterShutdown, File pathToStore) {
            this.model = model;
            this.tempFileStack = new Vector();
            this.numberOfFiles = numberOfTempFiles > 0 ? numberOfTempFiles : 1;
            this.filesShouldBeDeletedAfterShutdown = filesShouldBeDeletedAfterShutdown;
            this.pathToStore = pathToStore;
            this.changeState = model.getNumberOfChangesSinceLastSave();
        }

        @Override
        public void run() {
            if (this.model.getAutomaticSaveLock()) {
                return;
            }
            if (this.model.getNumberOfChangesSinceLastSave() == this.changeState) {
                return;
            }
            this.changeState = this.model.getNumberOfChangesSinceLastSave();
            if (this.changeState == 0) {
                return;
            }
            try {
                this.cancel();
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        File tempFile;
                        if (DoAutomaticSave.this.tempFileStack.size() >= DoAutomaticSave.this.numberOfFiles) {
                            tempFile = (File)DoAutomaticSave.this.tempFileStack.remove(0);
                        } else {
                            try {
                                tempFile = File.createTempFile("FM_" + (DoAutomaticSave.this.model.toString() == null ? "unnamed" : DoAutomaticSave.this.model.toString()), ".mm", DoAutomaticSave.this.pathToStore);
                                if (DoAutomaticSave.this.filesShouldBeDeletedAfterShutdown) {
                                    tempFile.deleteOnExit();
                                }
                            }
                            catch (Exception e) {
                                System.err.println("Error in automatic MindMapMapModel.save(): " + e.getMessage());
                                Resources.getInstance().logException(e);
                                return;
                            }
                        }
                        try {
                            DoAutomaticSave.this.model.saveInternal(tempFile, true);
                            DoAutomaticSave.this.model.getFrame().out(Resources.getInstance().format("automatically_save_message", new Object[]{tempFile.toString()}));
                            new EventSenderThread(SciPloreUtils.EVENT_FILE_AUTO_SAVED, tempFile.getName());
                        }
                        catch (Exception e) {
                            System.err.println("Error in automatic MindMapMapModel.save(): " + e.getMessage());
                            Resources.getInstance().logException(e);
                        }
                        DoAutomaticSave.this.tempFileStack.add(tempFile);
                    }
                });
            }
            catch (InterruptedException e) {
                Resources.getInstance().logException(e);
            }
            catch (InvocationTargetException e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    private class DummyLockManager
    extends LockManager {
        private DummyLockManager() {
        }

        @Override
        public synchronized String popLockingUserOfOldLock() {
            return null;
        }

        @Override
        public synchronized String tryToLock(File file) throws Exception {
            return null;
        }

        @Override
        public synchronized void releaseLock() {
        }

        @Override
        public synchronized void releaseTimer() {
        }

        @Override
        public synchronized void run() {
        }
    }

    private class LockManager
    extends TimerTask {
        File lockedSemaphoreFile = null;
        Timer lockTimer = null;
        final long lockUpdatePeriod = 240000L;
        final long lockSafetyPeriod = 300000L;
        String lockingUserOfOldLock = null;

        private LockManager() {
        }

        private File getSemaphoreFile(File mapFile) {
            return new File(mapFile.getParent() + System.getProperty("file.separator") + "$~" + mapFile.getName() + "~");
        }

        public synchronized String popLockingUserOfOldLock() {
            String toReturn = this.lockingUserOfOldLock;
            this.lockingUserOfOldLock = null;
            return toReturn;
        }

        private void writeSemaphoreFile(File inSemaphoreFile) throws Exception {
            FileOutputStream semaphoreOutputStream = new FileOutputStream(inSemaphoreFile);
            FileLock lock = null;
            try {
                lock = semaphoreOutputStream.getChannel().tryLock();
                if (lock == null) {
                    semaphoreOutputStream.close();
                    System.err.println("Locking failed.");
                    throw new Exception();
                }
            }
            catch (UnsatisfiedLinkError eUle) {
            }
            catch (NoClassDefFoundError eDcdf) {
                // empty catch block
            }
            semaphoreOutputStream.write(System.getProperty("user.name").getBytes());
            semaphoreOutputStream.write(10);
            semaphoreOutputStream.write(String.valueOf(System.currentTimeMillis()).getBytes());
            semaphoreOutputStream.close();
            semaphoreOutputStream = null;
            Tools.setHidden(inSemaphoreFile, true, false);
            if (lock != null) {
                lock.release();
            }
        }

        public synchronized String tryToLock(File file) throws Exception {
            File semaphoreFile = this.getSemaphoreFile(file);
            if (semaphoreFile == this.lockedSemaphoreFile) {
                return null;
            }
            try {
                BufferedReader semaphoreReader = new BufferedReader(new FileReader(semaphoreFile));
                String lockingUser = semaphoreReader.readLine();
                long lockTime = new Long(semaphoreReader.readLine());
                long timeDifference = System.currentTimeMillis() - lockTime;
                if (timeDifference <= 300000L) {
                    return lockingUser;
                }
                semaphoreReader.close();
                this.lockingUserOfOldLock = lockingUser;
                semaphoreFile.delete();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.writeSemaphoreFile(semaphoreFile);
            if (this.lockTimer == null) {
                this.lockTimer = new Timer();
                this.lockTimer.schedule((TimerTask)this, 240000L, 240000L);
            }
            this.releaseLock();
            this.lockedSemaphoreFile = semaphoreFile;
            return null;
        }

        public synchronized void releaseLock() {
            if (this.lockedSemaphoreFile != null) {
                this.lockedSemaphoreFile.delete();
                this.lockedSemaphoreFile = null;
            }
        }

        public synchronized void releaseTimer() {
            if (this.lockTimer != null) {
                this.lockTimer.cancel();
                this.lockTimer = null;
            }
        }

        @Override
        public synchronized void run() {
            if (this.lockedSemaphoreFile == null) {
                System.err.println("unexpected: lockedSemaphoreFile is null upon lock update");
                return;
            }
            try {
                Tools.setHidden(this.lockedSemaphoreFile, false, true);
                this.writeSemaphoreFile(this.lockedSemaphoreFile);
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
        }
    }
}

