/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.ColorSwatch;
import freemind.controller.LastOpenedList;
import freemind.controller.MainToolBar;
import freemind.controller.MapModuleManager;
import freemind.controller.MapMouseMotionListener;
import freemind.controller.MapMouseWheelListener;
import freemind.controller.MenuBar;
import freemind.controller.MenuItemSelectedListener;
import freemind.controller.NodeDragListener;
import freemind.controller.NodeDropListener;
import freemind.controller.NodeKeyListener;
import freemind.controller.NodeMotionListener;
import freemind.controller.NodeMouseMotionListener;
import freemind.controller.filter.FilterController;
import freemind.controller.printpreview.PreviewDialog;
import freemind.main.FreeMind;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.ModesCreator;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.mindmapmode.attributeactors.AttributeManagerDialog;
import freemind.preferences.FreemindPropertyListener;
import freemind.preferences.layout.OptionPanel;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import splmm.Actions.AboutAction;
import splmm.Actions.LicenseAction;
import splmm.Actions.SplmmDocumentation;
import splmm.Gui.SplmmToolbar;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public class Controller
implements MapModuleManager.MapModuleChangeObserver {
    private HashSet mMapTitleChangeListenerSet = new HashSet();
    public SplmmToolbar splmmToolbar;
    public static Logger logger;
    public static LocalLinkConverter localDocumentationLinkConverter;
    private static JColorChooser colorChooser;
    private LastOpenedList lastOpened;
    private MapModuleManager mapModuleManager;
    private Mode mMode;
    private FreeMindMain frame;
    private JToolBar toolbar;
    private JToolBar filterToolbar;
    private JPanel northToolbarPanel;
    private NodeMouseMotionListener nodeMouseMotionListener;
    private NodeMotionListener nodeMotionListener;
    private NodeKeyListener nodeKeyListener;
    private NodeDragListener nodeDragListener;
    private NodeDropListener nodeDropListener;
    private MapMouseMotionListener mapMouseMotionListener;
    private MapMouseWheelListener mapMouseWheelListener;
    private ModesCreator mModescreator = new ModesCreator(this);
    private PageFormat pageFormat = null;
    private PrinterJob printerJob = null;
    private Icon bswatch = new BackgroundSwatch();
    private boolean antialiasEdges = false;
    private boolean antialiasAll = false;
    private Map fontMap = new HashMap();
    private FilterController mFilterController;
    boolean isPrintingAllowed = true;
    boolean menubarVisible = true;
    boolean toolbarVisible = true;
    boolean leftToolbarVisible = true;
    public CloseAction close;
    public Action print;
    public Action printDirect;
    public Action printPreview;
    public Action page;
    public Action quit;
    public Action showAllAttributes = new ShowAllAttributesAction();
    public Action showSelectedAttributes = new ShowSelectedAttributesAction();
    public Action hideAllAttributes = new HideAllAttributesAction();
    public OptionAntialiasAction optionAntialiasAction;
    public Action optionHTMLExportFoldingAction;
    public Action optionSelectionMechanismAction;
    public Action about;
    public Action faq;
    public Action keyDocumentation;
    public Action webDocu;
    public Action documentation;
    public Action splmmDocumentation;
    public Action license;
    public Action navigationPreviousMap;
    public Action showFilterToolbarAction;
    public Action showAttributeManagerAction;
    public Action navigationNextMap;
    public Action moveToRoot;
    public Action toggleMenubar;
    public Action toggleToolbar;
    public Action toggleLeftToolbar;
    public Action zoomIn;
    public Action zoomOut;
    public Action showSelectionAsRectangle;
    public PropertyAction propertyAction;
    public OpenURLAction freemindUrl;
    private static final String[] zooms;
    public static final String JAVA_VERSION;
    private static Vector propertyChangeListeners;
    private AttributeManagerDialog attributeDialog = null;

    public Controller(FreeMindMain frame) {
        this.frame = frame;
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Component comp;
                String prop = e.getPropertyName();
                if ("focusOwner".equals(prop) && (comp = (Component)e.getNewValue()) instanceof FreeMindMain) {
                    Controller.this.obtainFocusForSelected();
                }
            }
        });
        localDocumentationLinkConverter = new DefaultLocalLinkConverter();
        this.lastOpened = new LastOpenedList(this, this.getProperty("lastOpened"));
        this.mapModuleManager = new MapModuleManager(this);
        this.mapModuleManager.addListener(this);
        this.nodeMouseMotionListener = new NodeMouseMotionListener(this);
        this.nodeMotionListener = new NodeMotionListener(this);
        this.nodeKeyListener = new NodeKeyListener(this);
        this.nodeDragListener = new NodeDragListener(this);
        this.nodeDropListener = new NodeDropListener(this);
        this.mapMouseMotionListener = new MapMouseMotionListener(this);
        this.mapMouseWheelListener = new MapMouseWheelListener(this);
        this.close = new CloseAction(this);
        this.print = new PrintAction(this, true);
        this.printDirect = new PrintAction(this, false);
        this.printPreview = new PrintPreviewAction(this);
        this.page = new PageAction(this);
        this.quit = new QuitAction(this);
        this.about = new AboutAction(this);
        this.freemindUrl = new OpenURLAction(this, LocalizationSupport.message("splmm_website"), this.getProperty("webFreeMindLocation"));
        this.faq = new OpenURLAction(this, this.getResourceString("FAQ"), this.getProperty("webFAQLocation"));
        this.keyDocumentation = new KeyDocumentationAction(this);
        this.webDocu = new OpenURLAction(this, this.getResourceString("webDocu"), this.getProperty("webDocuLocation"));
        this.documentation = new DocumentationAction(this);
        this.splmmDocumentation = new SplmmDocumentation(this);
        this.license = new LicenseAction(this);
        this.navigationPreviousMap = new NavigationPreviousMapAction(this);
        this.showFilterToolbarAction = new ShowFilterToolbarAction(this);
        this.showAttributeManagerAction = new ShowAttributeDialogAction(this);
        this.navigationNextMap = new NavigationNextMapAction(this);
        this.toggleMenubar = new ToggleMenubarAction(this);
        this.toggleToolbar = new ToggleToolbarAction(this);
        this.toggleLeftToolbar = new ToggleLeftToolbarAction(this);
        this.optionAntialiasAction = new OptionAntialiasAction(this);
        this.optionHTMLExportFoldingAction = new OptionHTMLExportFoldingAction(this);
        this.optionSelectionMechanismAction = new OptionSelectionMechanismAction(this);
        this.zoomIn = new ZoomInAction(this);
        this.zoomOut = new ZoomOutAction(this);
        this.propertyAction = new PropertyAction(this);
        this.showSelectionAsRectangle = new ShowSelectionAsRectangleAction(this);
        this.moveToRoot = new MoveToRootAction(this);
        this.northToolbarPanel = new JPanel(new BorderLayout());
        this.toolbar = new MainToolBar(this);
        this.mFilterController = new FilterController(this);
        this.filterToolbar = this.mFilterController.getFilterToolbar();
        this.getFrame().getContentPane().add((Component)this.northToolbarPanel, "North");
        this.northToolbarPanel.add((Component)this.toolbar, "North");
        this.northToolbarPanel.add((Component)this.filterToolbar, "South");
        this.setAllActions(false);
        if (!Tools.isAvailableFontFamily(this.getProperty("defaultfont"))) {
            logger.warning("Warning: the font you have set as standard - " + this.getProperty("defaultfont") + " - is not available.");
            frame.setProperty("defaultfont", "SansSerif");
        }
    }

    public String getProperty(String property) {
        return this.frame.getProperty(property);
    }

    public int getIntProperty(String property, int defaultValue) {
        return this.frame.getIntProperty(property, defaultValue);
    }

    public void setProperty(String property, String value) {
        String oldValue = this.getProperty(property);
        this.firePropertyChanged(property, value, oldValue);
    }

    private void firePropertyChanged(String property, String value, String oldValue) {
        if (oldValue == null || !oldValue.equals(value)) {
            this.frame.setProperty(property, value);
            for (FreemindPropertyListener listener : Controller.getPropertyChangeListeners()) {
                listener.propertyChanged(property, value, oldValue);
            }
        }
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public JFrame getJFrame() {
        FreeMindMain f = this.getFrame();
        if (f instanceof JFrame) {
            return (JFrame)((Object)f);
        }
        return null;
    }

    public URL getResource(String resource) {
        return this.getFrame().getResource(resource);
    }

    public String getResourceString(String resource) {
        return this.frame.getResourceString(resource);
    }

    public ModeController getModeController() {
        if (this.getMapModule() != null) {
            return this.getMapModule().getModeController();
        }
        return this.getMode().getDefaultModeController();
    }

    public MindMap getModel() {
        if (this.getMapModule() != null) {
            return this.getMapModule().getModel();
        }
        return null;
    }

    public MapView getView() {
        if (this.getMapModule() != null) {
            return this.getMapModule().getView();
        }
        return null;
    }

    Set getModes() {
        return this.mModescreator.getAllModes();
    }

    public Mode getMode() {
        return this.mMode;
    }

    public String[] getZooms() {
        return zooms;
    }

    public MapModuleManager getMapModuleManager() {
        return this.mapModuleManager;
    }

    public LastOpenedList getLastOpenedList() {
        return this.lastOpened;
    }

    public MapModule getMapModule() {
        return this.getMapModuleManager().getMapModule();
    }

    private JToolBar getToolBar() {
        return this.toolbar;
    }

    public Font getFontThroughMap(Font font) {
        if (!this.fontMap.containsKey(font.toString())) {
            this.fontMap.put(font.toString(), font);
        }
        return (Font)this.fontMap.get(font.toString());
    }

    public void setAntialiasEdges(boolean antialiasEdges) {
        this.antialiasEdges = antialiasEdges;
    }

    public void setAntialiasAll(boolean antialiasAll) {
        this.antialiasAll = antialiasAll;
    }

    private boolean getAntialiasEdges() {
        return this.antialiasEdges;
    }

    private boolean getAntialiasAll() {
        return this.antialiasAll;
    }

    public Font getDefaultFont() {
        int fontSize = this.getDefaultFontSize();
        int fontStyle = this.getDefaultFontStyle();
        String fontFamily = this.getDefaultFontFamilyName();
        return this.getFontThroughMap(new Font(fontFamily, fontStyle, fontSize));
    }

    public String getDefaultFontFamilyName() {
        String fontFamily = this.getProperty("defaultfont");
        return fontFamily;
    }

    public int getDefaultFontStyle() {
        int fontStyle = this.frame.getIntProperty("defaultfontstyle", 0);
        return fontStyle;
    }

    public int getDefaultFontSize() {
        int fontSize = this.frame.getIntProperty("defaultfontsize", 12);
        return fontSize;
    }

    public static JColorChooser getCommonJColorChooser() {
        return colorChooser;
    }

    public static Color showCommonJColorChooserDialog(Component component, String title, Color initialColor) throws HeadlessException {
        JColorChooser pane = Controller.getCommonJColorChooser();
        pane.setColor(initialColor);
        ColorTracker ok = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(component, title, true, pane, ok, null);
        dialog.addWindowListener(new Closer());
        dialog.addComponentListener(new DisposeOnClose());
        dialog.show();
        return ok.getColor();
    }

    @Override
    public boolean isMapModuleChangeAllowed(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        return true;
    }

    @Override
    public void afterMapClose(MapModule pOldMapModule, Mode pOldMode) {
    }

    @Override
    public void beforeMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        ModeController oldModeController;
        this.mMode = newMode;
        if (oldMapModule != null) {
            oldModeController = oldMapModule.getModeController();
            oldModeController.setVisible(false);
            oldModeController.shutdownController();
        } else if (oldMode != null) {
            oldModeController = oldMode.getDefaultModeController();
        } else {
            return;
        }
        if (oldModeController.getModeToolBar() != null) {
            this.toolbar.remove(oldModeController.getModeToolBar());
        }
        if (oldModeController.getLeftToolBar() != null) {
            this.getFrame().getContentPane().remove(oldModeController.getLeftToolBar());
        }
    }

    @Override
    public void afterMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        Component newLeftToolBar;
        ModeController newModeController;
        if (newMapModule != null) {
            this.getFrame().setView(newMapModule.getView());
            this.setAllActions(true);
            if (this.getView().getSelected() == null) {
                this.moveToRoot();
            }
            this.lastOpened.mapOpened(newMapModule);
            ((MainToolBar)this.getToolbar()).setZoomComboBox(newMapModule.getView().getZoom());
            newModeController = newMapModule.getModeController();
            newModeController.startupController();
            newModeController.setVisible(true);
        } else {
            newModeController = newMode.getDefaultModeController();
            this.getFrame().setView(null);
            this.setAllActions(false);
        }
        this.setTitle();
        JToolBar newToolBar = newModeController.getModeToolBar();
        if (newToolBar != null) {
            this.toolbar.add(newToolBar);
            newToolBar.repaint();
        }
        if (newModeController != null && newMode != null && newMapModule != null) {
            if (!newMode.toString().equalsIgnoreCase("MindMap")) {
                if (this.splmmToolbar != null) {
                    this.splmmToolbar.hideToolbar();
                }
            } else if (this.splmmToolbar == null) {
                this.splmmToolbar = new SplmmToolbar(this);
                this.getFrame().getContentPane().add((Component)this.splmmToolbar, "East");
                this.splmmToolbar.setVisible(true);
                if (newModeController.getMap() != null && newModeController.getMap().getRootNode() != null) {
                    this.splmmToolbar.onShow();
                }
            } else if (!oldMode.toString().equalsIgnoreCase("MindMap")) {
                this.splmmToolbar.showToolbar();
            } else {
                this.splmmToolbar.update();
            }
        } else if (newModeController != null && newMode != null) {
            if (!newMode.toString().equalsIgnoreCase("MindMap")) {
                if (this.splmmToolbar != null) {
                    this.splmmToolbar.hideToolbar();
                }
            } else if (oldMode != null && !oldMode.toString().equalsIgnoreCase("MindMap")) {
                this.splmmToolbar.showToolbar();
            }
        }
        if ((newLeftToolBar = newModeController.getLeftToolBar()) != null) {
            this.getFrame().getContentPane().add(newLeftToolBar, "West");
            if (this.leftToolbarVisible) {
                newLeftToolBar.setVisible(true);
                newLeftToolBar.repaint();
            } else {
                newLeftToolBar.setVisible(false);
            }
        }
        this.toolbar.validate();
        this.toolbar.repaint();
        MenuBar menuBar = this.getFrame().getFreeMindMenuBar();
        menuBar.updateMenus(newModeController);
        menuBar.revalidate();
        menuBar.repaint();
        this.obtainFocusForSelected();
    }

    @Override
    public void numberOfOpenMapInformation(int number) {
        this.navigationPreviousMap.setEnabled(number > 0);
        this.navigationNextMap.setEnabled(number > 0);
    }

    public boolean createNewMode(String mode) {
        if (this.getMode() != null && mode.equals(this.getMode().toString())) {
            return true;
        }
        Mode newMode = this.mModescreator.getMode(mode);
        if (newMode == null) {
            this.errorMessage(this.getResourceString("mode_na") + ": " + mode);
            return false;
        }
        this.getMapModuleManager().setMapModule(null, newMode);
        this.setTitle();
        this.getMode().activate();
        Object[] messageArguments = new Object[]{this.getMode().toLocalizedString()};
        MessageFormat formatter = new MessageFormat(this.getResourceString("mode_status"));
        this.getFrame().out(formatter.format(messageArguments));
        return true;
    }

    public void setMenubarVisible(boolean visible) {
        this.menubarVisible = visible;
        this.getFrame().getFreeMindMenuBar().setVisible(this.menubarVisible);
    }

    public void setToolbarVisible(boolean visible) {
        this.toolbarVisible = visible;
        this.toolbar.setVisible(this.toolbarVisible);
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public SplmmToolbar getSplmmToolbar() {
        return this.splmmToolbar;
    }

    public void setLeftToolbarVisible(boolean visible) {
        this.leftToolbarVisible = visible;
        if (this.getMode() == null) {
            return;
        }
        Component leftToolBar = this.getModeController().getLeftToolBar();
        if (leftToolBar != null) {
            leftToolBar.setVisible(this.leftToolbarVisible);
            ((JComponent)leftToolBar.getParent()).revalidate();
        }
    }

    public NodeKeyListener getNodeKeyListener() {
        return this.nodeKeyListener;
    }

    public NodeMouseMotionListener getNodeMouseMotionListener() {
        return this.nodeMouseMotionListener;
    }

    public NodeMotionListener getNodeMotionListener() {
        return this.nodeMotionListener;
    }

    public MapMouseMotionListener getMapMouseMotionListener() {
        return this.mapMouseMotionListener;
    }

    public MapMouseWheelListener getMapMouseWheelListener() {
        return this.mapMouseWheelListener;
    }

    public NodeDragListener getNodeDragListener() {
        return this.nodeDragListener;
    }

    public NodeDropListener getNodeDropListener() {
        return this.nodeDropListener;
    }

    public void setFrame(FreeMindMain frame) {
        this.frame = frame;
    }

    void moveToRoot() {
        if (this.getMapModule() != null) {
            this.getView().moveToRoot();
        }
    }

    public void close(boolean force) {
        this.getMapModuleManager().close(force);
    }

    public void informationMessage(Object message) {
        JOptionPane.showMessageDialog(this.getFrame().getContentPane(), message.toString(), "FreeMind", 1);
    }

    public void informationMessage(Object message, JComponent component) {
        JOptionPane.showMessageDialog(component, message.toString(), "FreeMind", 1);
    }

    public void errorMessage(Object message) {
        String myMessage = "";
        if (message != null) {
            myMessage = message.toString();
        } else {
            myMessage = this.getResourceString("undefined_error");
            if (myMessage == null) {
                myMessage = "Undefined error";
            }
        }
        JOptionPane.showMessageDialog(this.getFrame().getContentPane(), myMessage, "FreeMind", 0);
    }

    public void errorMessage(Object message, JComponent component) {
        JOptionPane.showMessageDialog(component, message.toString(), "FreeMind", 0);
    }

    public void obtainFocusForSelected() {
        if (this.getView() != null) {
            logger.info("Requesting Focus for " + this.getView().getSelected());
            this.getView().getSelected().requestFocus();
        } else {
            logger.info("No view present. No focus!");
            this.getFrame().getFreeMindMenuBar().requestFocus();
        }
    }

    public void setZoom(float zoom) {
        this.getView().setZoom(zoom);
        ((MainToolBar)this.toolbar).setZoomComboBox(zoom);
        Object[] messageArguments = new Object[]{String.valueOf(zoom * 100.0f)};
        String stringResult = Resources.getInstance().format("user_defined_zoom_status_bar", messageArguments);
        this.getFrame().out(stringResult);
    }

    public void setTitle() {
        Object[] messageArguments = new Object[]{this.getMode().toLocalizedString()};
        MessageFormat formatter = new MessageFormat(LocalizationSupport.message("splmm_mode_title"));
        String title = formatter.format(messageArguments);
        String rawTitle = "";
        MindMap model = null;
        MapModule mapModule = this.getMapModule();
        if (mapModule != null) {
            model = mapModule.getModel();
            rawTitle = mapModule.toString();
            title = rawTitle + (model.isSaved() ? "" : "*") + " - " + title + (model.isReadOnly() ? " (" + this.getResourceString("read_only") + ")" : "");
            File file = model.getFile();
            if (file != null) {
                title = title + " " + file.getAbsolutePath();
            }
        }
        this.getFrame().setTitle(title);
        for (MapModuleManager.MapTitleChangeListener listener : this.mMapTitleChangeListenerSet) {
            listener.setMapTitle(rawTitle, mapModule, model);
        }
    }

    public void registerMapTitleChangeListener(MapModuleManager.MapTitleChangeListener pMapTitleChangeListener) {
        this.mMapTitleChangeListenerSet.add(pMapTitleChangeListener);
    }

    public void deregisterMapTitleChangeListener(MapModuleManager.MapTitleChangeListener pMapTitleChangeListener) {
        this.mMapTitleChangeListenerSet.remove(pMapTitleChangeListener);
    }

    public void setAllActions(boolean enabled) {
        this.print.setEnabled(enabled && this.isPrintingAllowed);
        this.printDirect.setEnabled(enabled && this.isPrintingAllowed);
        this.printPreview.setEnabled(enabled && this.isPrintingAllowed);
        this.page.setEnabled(enabled && this.isPrintingAllowed);
        this.close.setEnabled(enabled);
        this.moveToRoot.setEnabled(enabled);
        this.showAllAttributes.setEnabled(enabled);
        this.showSelectedAttributes.setEnabled(enabled);
        this.hideAllAttributes.setEnabled(enabled);
        this.showAttributeManagerAction.setEnabled(enabled);
        ((MainToolBar)this.getToolBar()).setAllActions(enabled);
        this.showSelectionAsRectangle.setEnabled(enabled);
    }

    private void quit() {
        String currentMapRestorable;
        String string = currentMapRestorable = this.getModel() != null ? this.getModel().getRestoreable() : null;
        while (this.getMapModuleManager().getMapModuleVector().size() > 0) {
            if (this.getMapModule() != null) {
                boolean closingNotCancelled = this.getMapModuleManager().close(false);
                if (closingNotCancelled) continue;
                return;
            }
            this.getMapModuleManager().nextMapModule();
        }
        String lastOpenedString = this.lastOpened.save();
        this.setProperty("lastOpened", lastOpenedString);
        if (currentMapRestorable != null) {
            this.getFrame().setProperty("onStartIfNotSpecified", currentMapRestorable);
        }
        this.setProperty("toolbarVisible", this.toolbarVisible ? "true" : "false");
        this.setProperty("leftToolbarVisible", this.leftToolbarVisible ? "true" : "false");
        this.setProperty("antialiasEdges", this.antialiasEdges ? "true" : "false");
        this.setProperty("antialiasAll", this.antialiasAll ? "true" : "false");
        if (!this.getFrame().isApplet()) {
            int winState = this.getFrame().getWinState();
            if (6 != (winState & 6)) {
                this.setProperty("appwindow_x", String.valueOf(this.getFrame().getWinX()));
                this.setProperty("appwindow_y", String.valueOf(this.getFrame().getWinY()));
                this.setProperty("appwindow_width", String.valueOf(this.getFrame().getWinWidth()));
                this.setProperty("appwindow_height", String.valueOf(this.getFrame().getWinHeight()));
            }
            this.setProperty("appwindow_state", String.valueOf(winState));
        }
        this.getFrame().saveProperties();
        System.exit(0);
    }

    private boolean acquirePrinterJobAndPageFormat() {
        if (this.printerJob == null) {
            try {
                this.printerJob = PrinterJob.getPrinterJob();
            }
            catch (SecurityException ex) {
                this.isPrintingAllowed = false;
                return false;
            }
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
            if (Tools.safeEquals(this.getProperty("page_orientation"), "landscape")) {
                this.pageFormat.setOrientation(0);
            } else if (Tools.safeEquals(this.getProperty("page_orientation"), "portrait")) {
                this.pageFormat.setOrientation(1);
            } else if (Tools.safeEquals(this.getProperty("page_orientation"), "reverse_landscape")) {
                this.pageFormat.setOrientation(2);
            }
        }
        return true;
    }

    public static Collection getPropertyChangeListeners() {
        return Collections.unmodifiableCollection(propertyChangeListeners);
    }

    public void toggleSelectionAsRectangle() {
        if (this.isSelectionAsRectangle()) {
            this.setProperty("standarddrawrectangleforselection", "false");
        } else {
            this.setProperty("standarddrawrectangleforselection", "true");
        }
    }

    private boolean isSelectionAsRectangle() {
        return this.getProperty("standarddrawrectangleforselection").equalsIgnoreCase("true");
    }

    public MindMap getMap() {
        return this.getMapModule().getModel();
    }

    public static void addPropertyChangeListener(FreemindPropertyListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static void addPropertyChangeListenerAndPropagate(FreemindPropertyListener listener) {
        Controller.addPropertyChangeListener(listener);
        Properties properties = Resources.getInstance().getProperties();
        for (String string : properties.keySet()) {
            listener.propertyChanged(string, properties.getProperty(string), null);
        }
    }

    public static void removePropertyChangeListener(FreemindPropertyListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public FilterController getFilterController() {
        return this.mFilterController;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setAttributeViewType(MindMap map, String value) {
        if (value.equals("selected")) {
            ((ShowSelectedAttributesAction)this.showSelectedAttributes).setAttributeViewType(map);
        } else if (value.equals("hide")) {
            ((HideAllAttributesAction)this.hideAllAttributes).setAttributeViewType(map);
        } else if (value.equals("extended")) {
            ((ShowAllAttributesAction)this.showAllAttributes).setAttributeViewType(map);
        }
    }

    public Object setEdgesRenderingHint(Graphics2D g) {
        Object renderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.getAntialiasEdges() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        return renderingHint;
    }

    public void setTextRenderingHint(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.getAntialiasAll() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.getAntialiasAll() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    static {
        colorChooser = new JColorChooser();
        zooms = new String[]{"25%", "50%", "75%", "100%", "150%", "200%", "300%", "400%"};
        JAVA_VERSION = System.getProperty("java.version");
        propertyChangeListeners = new Vector();
    }

    private class OpenURLAction
    extends AbstractAction {
        Controller c;
        private final String url;

        OpenURLAction(Controller controller2, String description, String url) {
            super(description, new ImageIcon(controller2.getResource("images/Link.png")));
            this.c = controller2;
            this.url = url;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.c.getFrame().openDocument(new URL(this.url));
            }
            catch (MalformedURLException ex) {
                this.c.errorMessage(this.c.getResourceString("url_error") + "\n" + ex);
            }
            catch (Exception ex) {
                this.c.errorMessage(ex);
            }
        }
    }

    private class OptionSelectionMechanismAction
    extends AbstractAction
    implements FreemindPropertyListener {
        Controller c;

        OptionSelectionMechanismAction(Controller controller2) {
            this.c = controller2;
            Controller.addPropertyChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            this.changeSelection(command);
        }

        private void changeSelection(String command) {
            Controller.this.setProperty("selection_method", command);
            this.c.getNodeMouseMotionListener().updateSelectionMethod();
            String statusBarString = this.c.getResourceString(command);
            if (statusBarString != null) {
                this.c.getFrame().out(statusBarString);
            }
        }

        @Override
        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("selection_method")) {
                this.changeSelection(newValue);
            }
        }
    }

    private class OptionHTMLExportFoldingAction
    extends AbstractAction {
        OptionHTMLExportFoldingAction(Controller controller2) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Controller.this.setProperty("html_export_folding", e.getActionCommand());
        }
    }

    public class OptionAntialiasAction
    extends AbstractAction
    implements FreemindPropertyListener {
        OptionAntialiasAction(Controller controller2) {
            Controller.addPropertyChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            this.changeAntialias(command);
        }

        public void changeAntialias(String command) {
            if (command == null) {
                return;
            }
            if (command.equals("antialias_none")) {
                Controller.this.setAntialiasEdges(false);
                Controller.this.setAntialiasAll(false);
            }
            if (command.equals("antialias_edges")) {
                Controller.this.setAntialiasEdges(true);
                Controller.this.setAntialiasAll(false);
            }
            if (command.equals("antialias_all")) {
                Controller.this.setAntialiasEdges(true);
                Controller.this.setAntialiasAll(true);
            }
            if (Controller.this.getView() != null) {
                Controller.this.getView().repaint();
            }
        }

        @Override
        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("antialias")) {
                this.changeAntialias(newValue);
            }
        }
    }

    private class BackgroundSwatch
    extends ColorSwatch {
        private BackgroundSwatch() {
        }

        @Override
        Color getColor() {
            return Controller.this.getView().getBackground();
        }
    }

    public class PropertyAction
    extends AbstractAction {
        private final Controller controller;

        public PropertyAction(Controller controller2) {
            super(controller2.getResourceString("property_dialog"));
            this.controller = controller2;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            final String lang = Controller.this.frame.getProperty("language");
            JDialog dialog = new JDialog((Frame)Controller.this.getFrame().getJFrame(), true);
            dialog.setResizable(true);
            dialog.setUndecorated(false);
            final OptionPanel options = new OptionPanel((FreeMind)Controller.this.getFrame(), dialog, new OptionPanel.OptionPanelFeedback(){

                @Override
                public void writeProperties(Properties props) {
                    Vector<Object> sortedKeys = new Vector<Object>();
                    sortedKeys.addAll(props.keySet());
                    Collections.sort(sortedKeys);
                    boolean propertiesChanged = false;
                    for (String string : sortedKeys) {
                        String newProperty = props.getProperty(string);
                        propertiesChanged = propertiesChanged || !newProperty.equals(PropertyAction.this.controller.getProperty(string));
                        PropertyAction.this.controller.setProperty(string, newProperty);
                    }
                    if (propertiesChanged) {
                        JOptionPane.showMessageDialog(null, Controller.this.getResourceString("option_changes_may_require_restart"));
                        PropertyAction.this.controller.getFrame().saveProperties();
                        String l = Controller.this.frame.getProperty("language");
                        if (!lang.equalsIgnoreCase(Controller.this.frame.getProperty("language"))) {
                            new EventSenderThread(SciPloreUtils.EVENT_APP_LANGUAGE, Controller.this.frame.getProperty("language"));
                        }
                    }
                }
            });
            options.buildPanel();
            options.setProperties();
            dialog.setTitle("Freemind Properties");
            dialog.setDefaultCloseOperation(2);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    options.closeWindow();
                }
            });
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    options.closeWindow();
                }
            };
            Tools.addEscapeActionToDialog(dialog, action);
            dialog.setVisible(true);
        }
    }

    private class ShowSelectedAttributesAction
    extends AbstractAction {
        public ShowSelectedAttributesAction() {
            super(Resources.getInstance().getResourceString("attributes_show_selected"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MindMap map = Controller.this.getMap();
            this.setAttributeViewType(map);
        }

        void setAttributeViewType(MindMap map) {
            AttributeRegistry attributes = map.getRegistry().getAttributes();
            if (attributes.getAttributeViewType() != "selected") {
                attributes.setAttributeViewType("selected");
            }
        }
    }

    private class HideAllAttributesAction
    extends AbstractAction {
        public HideAllAttributesAction() {
            super(Resources.getInstance().getResourceString("attributes_hide_all"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MindMap map = Controller.this.getMap();
            this.setAttributeViewType(map);
        }

        public void setAttributeViewType(MindMap map) {
            AttributeRegistry attributes = map.getRegistry().getAttributes();
            if (attributes.getAttributeViewType() != "hide") {
                attributes.setAttributeViewType("hide");
            }
        }
    }

    private class ShowAllAttributesAction
    extends AbstractAction {
        public ShowAllAttributesAction() {
            super(Resources.getInstance().getResourceString("attributes_show_all"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MindMap map = Controller.this.getMap();
            this.setAttributeViewType(map);
        }

        public void setAttributeViewType(MindMap map) {
            AttributeRegistry attributes = map.getRegistry().getAttributes();
            if (attributes.getAttributeViewType() != "extended") {
                attributes.setAttributeViewType("extended");
            }
        }
    }

    protected class ShowSelectionAsRectangleAction
    extends AbstractAction
    implements MenuItemSelectedListener {
        public ShowSelectionAsRectangleAction(Controller controller2) {
            super(controller2.getResourceString("selection_as_rectangle"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Controller.this.toggleSelectionAsRectangle();
        }

        @Override
        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return Controller.this.isSelectionAsRectangle();
        }
    }

    protected class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction(Controller controller2) {
            super(controller2.getResourceString("zoom_out"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((MainToolBar)Controller.this.toolbar).zoomOut();
        }
    }

    protected class ZoomInAction
    extends AbstractAction {
        public ZoomInAction(Controller controller2) {
            super(controller2.getResourceString("zoom_in"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((MainToolBar)Controller.this.toolbar).zoomIn();
        }
    }

    private class ToggleLeftToolbarAction
    extends AbstractAction
    implements MenuItemSelectedListener {
        ToggleLeftToolbarAction(Controller controller2) {
            super(controller2.getResourceString("toggle_left_toolbar"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Controller.this.leftToolbarVisible = !Controller.this.leftToolbarVisible;
            Controller.this.setLeftToolbarVisible(Controller.this.leftToolbarVisible);
        }

        @Override
        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return Controller.this.leftToolbarVisible;
        }
    }

    private class ToggleToolbarAction
    extends AbstractAction
    implements MenuItemSelectedListener {
        ToggleToolbarAction(Controller controller2) {
            super(controller2.getResourceString("toggle_toolbar"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Controller.this.toolbarVisible = !Controller.this.toolbarVisible;
            Controller.this.setToolbarVisible(Controller.this.toolbarVisible);
        }

        @Override
        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            logger.info("ToggleToolbar was asked for selectedness.");
            return Controller.this.toolbarVisible;
        }
    }

    private class ToggleMenubarAction
    extends AbstractAction
    implements MenuItemSelectedListener {
        ToggleMenubarAction(Controller controller2) {
            super(controller2.getResourceString("toggle_menubar"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Controller.this.menubarVisible = !Controller.this.menubarVisible;
            Controller.this.setMenubarVisible(Controller.this.menubarVisible);
        }

        @Override
        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return Controller.this.menubarVisible;
        }
    }

    private class MoveToRootAction
    extends AbstractAction {
        MoveToRootAction(Controller controller2) {
            super(controller2.getResourceString("move_to_root"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Controller.this.moveToRoot();
        }
    }

    private class NavigationNextMapAction
    extends AbstractAction {
        NavigationNextMapAction(Controller controller2) {
            super(controller2.getResourceString("next_map"), new ImageIcon(Controller.this.getResource("images/1rightarrow.png")));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Controller.this.mapModuleManager.nextMapModule();
        }
    }

    private class ShowFilterToolbarAction
    extends AbstractAction {
        ShowFilterToolbarAction(Controller controller2) {
            super(null, new ImageIcon(Controller.this.getResource("images/filter.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JToggleButton btnFilter = (JToggleButton)event.getSource();
            if (btnFilter.getModel().isSelected()) {
                Controller.this.getFilterController().showFilterToolbar(true);
            } else {
                Controller.this.getFilterController().showFilterToolbar(false);
            }
        }
    }

    private class ShowAttributeDialogAction
    extends AbstractAction {
        private Controller c;

        ShowAttributeDialogAction(Controller c) {
            super(c.getResourceString("attributes_dialog"), new ImageIcon(Controller.this.getResource("images/showAttributes.gif")));
            this.c = c;
        }

        private AttributeManagerDialog getAttributeDialog() {
            if (Controller.this.attributeDialog == null) {
                Controller.this.attributeDialog = new AttributeManagerDialog(this.c);
            }
            return Controller.this.attributeDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.getAttributeDialog().isVisible() && Controller.this.getMapModule() != null) {
                this.getAttributeDialog().pack();
                this.getAttributeDialog().show();
            }
        }
    }

    private class NavigationPreviousMapAction
    extends AbstractAction {
        NavigationPreviousMapAction(Controller controller2) {
            super(controller2.getResourceString("previous_map"), new ImageIcon(Controller.this.getResource("images/1leftarrow.png")));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Controller.this.mapModuleManager.previousMapModule();
        }
    }

    private class KeyDocumentationAction
    extends AbstractAction {
        Controller controller;

        KeyDocumentationAction(Controller controller2) {
            super(controller2.getResourceString("KeyDoc"));
            this.controller = controller2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String urlText = this.controller.getFrame().getResourceString("pdfKeyDocLocation");
            urlText = Tools.removeTranslateComment(urlText);
            try {
                if (urlText != null && urlText.startsWith(".")) {
                    urlText = localDocumentationLinkConverter.convertLocalLink(urlText);
                }
                if (urlText != null && urlText != "") {
                    URL url = null;
                    url = new URL(urlText);
                    this.controller.getFrame().openDocument(url);
                }
            }
            catch (Exception e2) {
                Resources.getInstance().logException(e2);
                return;
            }
        }
    }

    private class DocumentationAction
    extends AbstractAction {
        Controller controller;

        DocumentationAction(Controller controller2) {
            super(controller2.getResourceString("documentation"));
            this.controller = controller2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String map = this.controller.getFrame().getResourceString("browsemode_initial_map");
            if ((map = Tools.removeTranslateComment(map)) != null && map.startsWith(".")) {
                try {
                    map = localDocumentationLinkConverter.convertLocalLink(map);
                }
                catch (AccessControlException ex) {
                    Controller.this.webDocu.actionPerformed(e);
                    return;
                }
            }
            if (map != null && map != "") {
                URL url = null;
                try {
                    url = new URL(map);
                }
                catch (MalformedURLException e2) {
                    Resources.getInstance().logException(e2);
                    return;
                }
                final URL endUrl = url;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Controller.this.createNewMode("Browse");
                            DocumentationAction.this.controller.getModeController().load(endUrl);
                        }
                        catch (Exception e1) {
                            Resources.getInstance().logException(e1);
                        }
                    }
                });
            }
        }
    }

    private class DefaultLocalLinkConverter
    implements LocalLinkConverter {
        private DefaultLocalLinkConverter() {
        }

        @Override
        public String convertLocalLink(String map) {
            String applicationPath = Controller.this.frame.getFreemindBaseDir();
            return "file:" + applicationPath + map.substring(1);
        }
    }

    public static interface LocalLinkConverter {
        public String convertLocalLink(String var1);
    }

    private class PageAction
    extends AbstractAction {
        Controller controller;

        PageAction(Controller controller2) {
            super(controller2.getResourceString("page"));
            this.controller = controller2;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Controller.this.acquirePrinterJobAndPageFormat()) {
                return;
            }
            final JDialog dialog = new JDialog((JFrame)((Object)Controller.this.getFrame()), Controller.this.getResourceString("printing_settings"), true);
            JCheckBox fitToPage = new JCheckBox(Controller.this.getResourceString("fit_to_page"), Resources.getInstance().getBoolProperty("fit_to_page"));
            JLabel userZoomL = new JLabel(Controller.this.getResourceString("user_zoom"));
            final JTextField userZoom = new JTextField(Controller.this.getProperty("user_zoom"), 3);
            userZoom.setEditable(!fitToPage.isSelected());
            JButton okButton = new JButton();
            Tools.setLabelAndMnemonic(okButton, Controller.this.getResourceString("ok"));
            final Tools.IntHolder eventSource = new Tools.IntHolder();
            JPanel panel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            eventSource.setValue(0);
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    eventSource.setValue(1);
                    dialog.dispose();
                }
            });
            fitToPage.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    userZoom.setEditable(e.getStateChange() == 2);
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            gridbag.setConstraints(fitToPage, c);
            panel.add(fitToPage);
            c.gridy = 1;
            c.gridwidth = 1;
            gridbag.setConstraints(userZoomL, c);
            panel.add(userZoomL);
            c.gridx = 1;
            c.gridwidth = 1;
            gridbag.setConstraints(userZoom, c);
            panel.add(userZoom);
            c.gridy = 2;
            c.gridx = 0;
            c.gridwidth = 3;
            c.insets = new Insets(10, 0, 0, 0);
            gridbag.setConstraints(okButton, c);
            panel.add(okButton);
            panel.setLayout(gridbag);
            dialog.setDefaultCloseOperation(2);
            dialog.setContentPane(panel);
            dialog.setLocationRelativeTo((JFrame)((Object)Controller.this.getFrame()));
            dialog.getRootPane().setDefaultButton(okButton);
            dialog.pack();
            dialog.setVisible(true);
            if (eventSource.getValue() != 1) {
                return;
            }
            Controller.this.setProperty("user_zoom", userZoom.getText());
            Controller.this.setProperty("fit_to_page", fitToPage.isSelected() ? "true" : "false");
            Controller.this.pageFormat = Controller.this.printerJob.pageDialog(Controller.this.pageFormat);
            if (Controller.this.pageFormat.getOrientation() == 0) {
                Controller.this.setProperty("page_orientation", "landscape");
            } else if (Controller.this.pageFormat.getOrientation() == 1) {
                Controller.this.setProperty("page_orientation", "portrait");
            } else if (Controller.this.pageFormat.getOrientation() == 2) {
                Controller.this.setProperty("page_orientation", "reverse_landscape");
            }
        }
    }

    private class PrintPreviewAction
    extends AbstractAction {
        Controller controller;

        PrintPreviewAction(Controller controller2) {
            super(controller2.getResourceString("print_preview"));
            this.controller = controller2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Controller.this.acquirePrinterJobAndPageFormat()) {
                return;
            }
            PreviewDialog previewDialog = new PreviewDialog(this.controller.getResourceString("print_preview_title"), Controller.this.getView());
            previewDialog.pack();
            previewDialog.setLocationRelativeTo(JOptionPane.getFrameForComponent(Controller.this.getView()));
            previewDialog.setVisible(true);
        }
    }

    private class PrintAction
    extends AbstractAction {
        Controller controller;
        boolean isDlg;

        PrintAction(Controller controller2, boolean isDlg) {
            super(isDlg ? controller2.getResourceString("print_dialog") : controller2.getResourceString("print"), new ImageIcon(Controller.this.getResource("images/fileprint.png")));
            this.controller = controller2;
            this.setEnabled(false);
            this.isDlg = isDlg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Controller.this.acquirePrinterJobAndPageFormat()) {
                return;
            }
            Controller.this.printerJob.setPrintable(Controller.this.getView(), Controller.this.pageFormat);
            if (!this.isDlg || Controller.this.printerJob.printDialog()) {
                try {
                    Controller.this.frame.setWaitingCursor(true);
                    Controller.this.printerJob.print();
                }
                catch (Exception ex) {
                    Resources.getInstance().logException(ex);
                }
                finally {
                    Controller.this.frame.setWaitingCursor(false);
                }
            }
        }
    }

    public static class CloseAction
    extends AbstractAction {
        private final Controller controller;

        CloseAction(Controller controller) {
            Tools.setLabelAndMnemonic(this, controller.getResourceString("close"));
            this.controller = controller;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = this.controller.getMap().getFile();
            if (file == null) {
                new EventSenderThread(SciPloreUtils.EVENT_FILE_CLOSED, "");
            } else {
                new EventSenderThread(SciPloreUtils.EVENT_FILE_CLOSED, file.getName());
            }
            this.controller.close(false);
        }
    }

    private class QuitAction
    extends AbstractAction {
        QuitAction(Controller controller2) {
            super(controller2.getResourceString("quit"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new EventSenderThread(SciPloreUtils.EVENT_APP_CLOSED, null);
            Controller.this.quit();
        }
    }

    static class DisposeOnClose
    extends ComponentAdapter
    implements Serializable {
        DisposeOnClose() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            Window w = (Window)e.getComponent();
            w.dispose();
        }
    }

    static class Closer
    extends WindowAdapter
    implements Serializable {
        Closer() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Window w = e.getWindow();
            w.hide();
        }
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

