/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.util.xslt;

import accessories.plugins.util.window.WindowClosingAdapter;
import accessories.plugins.util.xslt.FileChooseListener;
import accessories.plugins.util.xslt.XmlExporter;
import freemind.modes.ModeController;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ExportDialog
extends JFrame {
    private static final String ACCESSORIES_PLUGINS_UTIL_XSLT_EXPORT_DIALOG_STORE_TARGET = "accessories.plugins.util.xslt.ExportDialog.store.target";
    private static final String ACCESSORIES_PLUGINS_UTIL_XSLT_EXPORT_DIALOG_STORE_XSLT = "accessories.plugins.util.xslt.ExportDialog.store.xslt";
    protected JTextField fieldXsltFileName = null;
    protected JTextField fieldTargetFileName = null;
    protected File xmlFile = null;
    private final ModeController mController;

    public ExportDialog(File nxmlFile, ModeController pController) {
        super("ExportDialog");
        this.xmlFile = nxmlFile;
        this.mController = pController;
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowClosingAdapter(false));
        GridBagLayout gbl = new GridBagLayout();
        this.getContentPane().setLayout(gbl);
        String lastXsltFileName = this.mController.getFrame().getProperty(ACCESSORIES_PLUGINS_UTIL_XSLT_EXPORT_DIALOG_STORE_XSLT);
        String lastTargetFileName = this.mController.getFrame().getProperty(ACCESSORIES_PLUGINS_UTIL_XSLT_EXPORT_DIALOG_STORE_TARGET);
        GridBagConstraints gbc = this.makegbc(0, 0, 1, 1);
        gbc.fill = 0;
        JLabel label = new JLabel("Choose XSL File ");
        gbl.setConstraints(label, gbc);
        this.getContentPane().add(label);
        gbc = this.makegbc(1, 0, 1, 1);
        gbc.weightx = 300.0;
        gbc.fill = 2;
        this.fieldXsltFileName = new JTextField(lastXsltFileName);
        this.fieldXsltFileName.setColumns(20);
        gbl.setConstraints(this.fieldXsltFileName, gbc);
        this.getContentPane().add(this.fieldXsltFileName);
        gbc = this.makegbc(0, 1, 1, 1);
        gbc.fill = 0;
        JLabel labeli = new JLabel("choose ExportFile ");
        gbl.setConstraints(labeli, gbc);
        this.getContentPane().add(labeli);
        gbc = this.makegbc(1, 1, 1, 1);
        gbc.weightx = 100.0;
        gbc.fill = 2;
        this.fieldTargetFileName = new JTextField(lastTargetFileName);
        this.fieldTargetFileName.setColumns(20);
        gbl.setConstraints(this.fieldTargetFileName, gbc);
        this.getContentPane().add(this.fieldTargetFileName);
        JButton xslbutton = new JButton("Browse");
        gbc = this.makegbc(2, 0, 1, 1);
        gbc.fill = 0;
        gbl.setConstraints(xslbutton, gbc);
        xslbutton.addActionListener(new FileChooseListener(0, this.fieldXsltFileName, xslbutton, this.xmlFile));
        this.getContentPane().add(xslbutton);
        JButton exportbutton = new JButton("Browse");
        gbc = this.makegbc(2, 1, 1, 1);
        gbc.fill = 0;
        exportbutton.addActionListener(new FileChooseListener(1, this.fieldTargetFileName, exportbutton, this.xmlFile));
        gbl.setConstraints(exportbutton, gbc);
        this.getContentPane().add(exportbutton);
        JButton button = new JButton("Export");
        gbc = this.makegbc(2, 2, 1, 1);
        gbc.fill = 0;
        button.addActionListener(new ExportListener(this));
        gbl.setConstraints(button, gbc);
        this.getContentPane().add(button);
        JButton cbutton = new JButton("Cancel");
        gbc = this.makegbc(1, 2, 1, 1);
        gbc.anchor = 13;
        gbc.fill = 0;
        gbl.setConstraints(cbutton, gbc);
        cbutton.addActionListener(new ExportListener(this, true));
        this.getContentPane().add(cbutton);
        this.pack();
    }

    private GridBagConstraints makegbc(int x, int y, int width, int height) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.anchor = 17;
        return gbc;
    }

    class ExportListener
    implements ActionListener {
        private ExportDialog parent = null;
        boolean exitSystem = true;
        private boolean cancel = false;
        XmlExporter xe = null;

        public ExportListener(ExportDialog m) {
            this.parent = m;
        }

        public ExportListener(ExportDialog m, boolean pCancel) {
            this.parent = m;
            this.cancel = pCancel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.cancel) {
                this.xe = new XmlExporter();
                this.xe.transForm(this.parent.xmlFile, new File(this.parent.fieldXsltFileName.getText()), new File(this.parent.fieldTargetFileName.getText()));
            }
            ExportDialog.this.mController.getFrame().setProperty(ExportDialog.ACCESSORIES_PLUGINS_UTIL_XSLT_EXPORT_DIALOG_STORE_XSLT, ExportDialog.this.fieldXsltFileName.getText());
            ExportDialog.this.mController.getFrame().setProperty(ExportDialog.ACCESSORIES_PLUGINS_UTIL_XSLT_EXPORT_DIALOG_STORE_TARGET, ExportDialog.this.fieldTargetFileName.getText());
            this.parent.setVisible(false);
            this.parent.dispose();
        }
    }
}

