/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.ExportHook;
import freemind.main.Resources;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExportToImage
extends ExportHook {
    @Override
    public void startupMapHook() {
        super.startupMapHook();
        BufferedImage image = this.createBufferedImage();
        if (image != null) {
            String imageType = this.getResourceString("image_type");
            this.exportToImage(image, imageType, this.getResourceString("image_description"));
        }
    }

    public boolean exportToImage(BufferedImage image, String type, String description) {
        File chosenFile = this.chooseFile(type, description, null);
        if (chosenFile == null) {
            return false;
        }
        try {
            this.getController().getFrame().setWaitingCursor(true);
            FileOutputStream out = new FileOutputStream(chosenFile);
            ImageIO.write((RenderedImage)image, type, out);
            out.close();
        }
        catch (IOException e1) {
            Resources.getInstance().logException(e1);
        }
        this.getController().getFrame().setWaitingCursor(false);
        return true;
    }

    public void transForm(Source xmlSource, InputStream xsltStream, File resultFile, String areaCode) {
        StreamSource xsltSource = new StreamSource(xsltStream);
        StreamResult result = new StreamResult(resultFile);
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setParameter("destination_dir", resultFile.getName() + "_files/");
            trans.setParameter("area_code", areaCode);
            trans.setParameter("folding_type", this.getController().getFrame().getProperty("html_export_folding"));
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
        }
    }
}

