/*
 * Decompiled with CFR 0.152.
 */
package plugins.latex;

import freemind.extensions.StatefulMindMapNodeHookAdapter;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.NodeView;
import java.awt.Component;
import java.awt.Container;
import java.util.LinkedHashSet;
import java.util.Set;
import plugins.latex.JZoomedHotEqn;

public class LatexNodeHook
extends StatefulMindMapNodeHookAdapter {
    private String equation = "\\mbox{I}^\\fgcolor{ff0000}{\\heartsuit}\\mbox{HotEqn}";
    private Set viewers = new LinkedHashSet();

    public void onViewCreatedHook(NodeView nodeView) {
        this.createViewer(nodeView);
        super.onViewCreatedHook(nodeView);
    }

    public void onViewRemovedHook(NodeView nodeView) {
        this.deleteViewer(nodeView);
        super.onViewRemovedHook(nodeView);
    }

    private void deleteViewer(NodeView nodeView) {
        if (this.viewers.isEmpty()) {
            return;
        }
        Container contentPane = nodeView.getContentPane();
        int componentCount = contentPane.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = contentPane.getComponent(i);
            if (!this.viewers.contains(component)) continue;
            this.viewers.remove(component);
            contentPane.remove(i);
            return;
        }
    }

    public void invoke(MindMapNode node) {
        for (NodeView view : node.getViewers()) {
            this.createViewer(view);
        }
        super.invoke(node);
    }

    private void createViewer(NodeView view) {
        JZoomedHotEqn comp = new JZoomedHotEqn(this);
        this.viewers.add(comp);
        view.getContentPane().add((Component)((Object)comp));
    }

    public String getContent(String key) {
        return this.equation;
    }

    public void setContent(String key, String content) {
        this.equation = content;
        for (JZoomedHotEqn comp : this.viewers) {
            comp.setModel(this);
        }
        this.getController().nodeChanged(this.getNode());
    }

    public void loadFrom(XMLElement child) {
        this.equation = child.getAttribute("EQUATION", (Object)this.equation).toString();
        super.loadFrom(child);
    }

    public void save(XMLElement xml) {
        super.save(xml);
        xml.setAttribute("EQUATION", (Object)this.equation);
    }

    public void shutdownMapHook() {
        for (JZoomedHotEqn comp : this.viewers) {
            comp.getParent().remove((Component)((Object)comp));
        }
        super.shutdownMapHook();
    }
}

