/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;

public class DatabasePropertiesDialog
extends JDialog {
    MetaData metaData;
    BasePanel panel = null;
    JComboBox encoding;
    JButton ok;
    JButton cancel;
    JTextField fileDir = new JTextField(40);
    JTextField pdfDir = new JTextField(40);
    JTextField psDir = new JTextField(40);
    String oldFileVal = "";
    String oldPdfVal = "";
    String oldPsVal = "";
    JCheckBox protect = new JCheckBox(Globals.lang("Refuse to save the database before external changes have been reviewed."));
    boolean oldProtectVal = false;
    JCheckBox clearLegacyFileDir = new JCheckBox(Globals.lang("Legacy file directory setting found - clear setting?"), false);
    boolean oldClearLgcFileVal = false;

    public DatabasePropertiesDialog(JFrame parent) {
        super(parent, Globals.lang("Database properties"), false);
        this.encoding = new JComboBox<String>(Globals.ENCODINGS);
        this.ok = new JButton(Globals.lang("Ok"));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.init(parent);
    }

    public void setPanel(BasePanel panel) {
        this.panel = panel;
        this.metaData = panel.metaData();
    }

    public final void init(JFrame parent) {
        JButton browseFile = new JButton(Globals.lang("Browse"));
        JButton browsePdf = new JButton(Globals.lang("Browse"));
        JButton browsePs = new JButton(Globals.lang("Browse"));
        browseFile.addActionListener(new BrowseAction(parent, this.fileDir, true));
        browsePdf.addActionListener(new BrowseAction(parent, this.pdfDir, true));
        browsePs.addActionListener(new BrowseAction(parent, this.psDir, true));
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, left:pref, 4dlu, fill:pref", ""));
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        builder.append(Globals.lang("Database encoding"));
        builder.append(this.encoding);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Override default file directories"));
        builder.nextLine();
        builder.append(Globals.lang("File directory"));
        builder.append(this.fileDir);
        builder.append(browseFile);
        builder.nextLine();
        builder.append((Component)this.clearLegacyFileDir, 3);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Override legacy file fields"));
        builder.append((Component)new JLabel("<html>" + Globals.lang("Note that these settings are used for the legacy <b>pdf</b> and <b>ps</b> fields only.<br>For most users, setting the <b>Main file directory</b> above should be sufficient.") + "</html>"), 3);
        builder.nextLine();
        builder.append(Globals.lang("PDF directory"));
        builder.append(this.pdfDir);
        builder.append(browsePdf);
        builder.nextLine();
        builder.append(Globals.lang("PS directory"));
        builder.append(this.psDir);
        builder.append(browsePs);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Database protection"));
        builder.nextLine();
        builder.append((Component)this.protect, 3);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.cancel);
        bb.addGlue();
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)bb.getPanel(), "South");
        this.pack();
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DatabasePropertiesDialog.this.dispose();
            }
        };
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", closeAction);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatabasePropertiesDialog.this.storeSettings();
                DatabasePropertiesDialog.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatabasePropertiesDialog.this.dispose();
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setValues();
        }
        super.setVisible(visible);
    }

    public void setValues() {
        this.encoding.setSelectedItem(this.panel.getEncoding());
        Vector<String> fileD = this.metaData.getData(Globals.prefs.get("userFileDir"));
        if (fileD == null) {
            this.fileDir.setText("");
        } else if (fileD.size() >= 1) {
            this.fileDir.setText(fileD.get(0).trim());
        }
        Vector<String> pdfD = this.metaData.getData("pdfDirectory");
        if (pdfD == null) {
            this.pdfDir.setText("");
        } else if (pdfD.size() >= 1) {
            this.pdfDir.setText(pdfD.get(0).trim());
        }
        Vector<String> psD = this.metaData.getData("psDirectory");
        if (psD == null) {
            this.psDir.setText("");
        } else if (psD.size() >= 1) {
            this.psDir.setText(psD.get(0).trim());
        }
        Vector<String> prot = this.metaData.getData("protectedFlag");
        if (prot == null) {
            this.protect.setSelected(false);
        } else if (prot.size() >= 1) {
            this.protect.setSelected(Boolean.parseBoolean(prot.get(0)));
        }
        this.clearLegacyFileDir.setVisible(this.metaData.getData("fileDirectory") != null);
        this.oldFileVal = this.fileDir.getText();
        this.oldPdfVal = this.pdfDir.getText();
        this.oldPsVal = this.psDir.getText();
        this.oldProtectVal = this.protect.isSelected();
        this.oldClearLgcFileVal = this.clearLegacyFileDir.isSelected();
    }

    public void storeSettings() {
        boolean changed;
        String oldEncoding = this.panel.getEncoding();
        String newEncoding = (String)this.encoding.getSelectedItem();
        this.panel.setEncoding(newEncoding);
        Vector<String> dir = new Vector<String>(1);
        String text = this.fileDir.getText().trim();
        if (text.length() > 0) {
            dir.add(text);
            this.metaData.putData(Globals.prefs.get("userFileDir"), dir);
        } else {
            this.metaData.remove(Globals.prefs.get("userFileDir"));
        }
        if (this.metaData.getData("fileDirectory") != null && this.clearLegacyFileDir.isSelected()) {
            this.metaData.remove("fileDirectory");
        }
        dir = new Vector(1);
        text = this.pdfDir.getText().trim();
        if (text.length() > 0) {
            dir.add(text);
            this.metaData.putData("pdfDirectory", dir);
        } else {
            this.metaData.remove("pdfDirectory");
        }
        dir = new Vector(1);
        text = this.psDir.getText().trim();
        if (text.length() > 0) {
            dir.add(text);
            this.metaData.putData("psDirectory", dir);
        } else {
            this.metaData.remove("psDirectory");
        }
        if (this.protect.isSelected()) {
            dir = new Vector(1);
            dir.add("true");
            this.metaData.putData("protectedFlag", dir);
        } else {
            this.metaData.remove("protectedFlag");
        }
        boolean bl = changed = !newEncoding.equals(oldEncoding) || !this.oldPdfVal.equals(this.pdfDir.getText()) || !this.oldPsVal.equals(this.psDir.getText()) || this.oldProtectVal != this.protect.isSelected() || this.oldClearLgcFileVal != this.clearLegacyFileDir.isSelected();
        if (changed) {
            this.panel.markNonUndoableBaseChanged();
        }
    }
}

