/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.undo.NamedCompound;

public class AddToGroupAction
extends AbstractAction {
    protected GroupTreeNode m_node;
    protected final boolean m_move;
    protected BasePanel m_panel;

    public AddToGroupAction(GroupTreeNode node, boolean move, BasePanel panel) {
        super(node.getGroup().getName());
        this.m_node = node;
        this.m_move = move;
        this.m_panel = panel;
    }

    public AddToGroupAction(boolean move) {
        super(Globals.lang(move ? "Assign entry selection exclusively to this group" : "Add entry selection to this group"));
        this.m_move = move;
    }

    public void setBasePanel(BasePanel panel) {
        this.m_panel = panel;
    }

    public void setNode(GroupTreeNode node) {
        this.m_node = node;
    }

    public void actionPerformed(ActionEvent evt) {
        BibtexEntry[] entries = this.m_panel.getSelectedEntries();
        Vector<GroupTreeNode> removeGroupsNodes = new Vector<GroupTreeNode>();
        if (this.m_move) {
            Enumeration<GroupTreeNode> e = ((GroupTreeNode)this.m_node.getRoot()).preorderEnumeration();
            while (e.hasMoreElements()) {
                GroupTreeNode node = e.nextElement();
                if (!node.getGroup().supportsRemove()) continue;
                for (int i = 0; i < entries.length; ++i) {
                    if (!node.getGroup().contains(entries[i])) continue;
                    removeGroupsNodes.add(node);
                }
            }
            AbstractGroup[] groups = new AbstractGroup[removeGroupsNodes.size() + 1];
            for (int i = 0; i < removeGroupsNodes.size(); ++i) {
                groups[i] = ((GroupTreeNode)removeGroupsNodes.elementAt(i)).getGroup();
            }
            groups[groups.length - 1] = this.m_node.getGroup();
            if (!Util.warnAssignmentSideEffects(groups, entries, this.m_panel.getDatabase(), this.m_panel.frame())) {
                return;
            }
        } else if (!Util.warnAssignmentSideEffects(new AbstractGroup[]{this.m_node.getGroup()}, entries, this.m_panel.getDatabase(), this.m_panel.frame())) {
            return;
        }
        this.m_panel.storeCurrentEdit();
        NamedCompound undoAll = new NamedCompound(Globals.lang("change assignment of entries"));
        if (this.m_move) {
            for (int i = 0; i < removeGroupsNodes.size(); ++i) {
                GroupTreeNode node = (GroupTreeNode)removeGroupsNodes.elementAt(i);
                if (!node.getGroup().containsAny(entries)) continue;
                undoAll.addEdit(node.removeFromGroup(entries));
            }
            AbstractUndoableEdit undoAdd = this.m_node.addToGroup(entries);
            if (undoAdd != null) {
                undoAll.addEdit(undoAdd);
            }
        } else {
            AbstractUndoableEdit undoAdd = this.m_node.addToGroup(entries);
            if (undoAdd == null) {
                return;
            }
            undoAll.addEdit(undoAdd);
        }
        undoAll.end();
        this.m_panel.undoManager.addEdit(undoAll);
        this.m_panel.markBaseChanged();
        this.m_panel.updateEntryEditorIfShowing();
        this.m_panel.getGroupSelector().valueChanged(null);
    }
}

