/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Vector;
import net.sf.jabref.export.layout.Layout;
import wsi.ra.types.StringInt;

public class LayoutHelper {
    public static final int IS_LAYOUT_TEXT = 1;
    public static final int IS_SIMPLE_FIELD = 2;
    public static final int IS_FIELD_START = 3;
    public static final int IS_FIELD_END = 4;
    public static final int IS_OPTION_FIELD = 5;
    public static final int IS_GROUP_START = 6;
    public static final int IS_GROUP_END = 7;
    public static final int IS_ENCODING_NAME = 8;
    private static String currentGroup = null;
    private PushbackReader _in;
    private Vector<StringInt> parsedEntries = new Vector();
    private boolean _eof = false;
    private int line = 1;

    public LayoutHelper(Reader in) {
        if (in == null) {
            throw new NullPointerException();
        }
        this._in = new PushbackReader(in);
    }

    public Layout getLayoutFromText(String classPrefix) throws Exception {
        this.parse();
        for (int i = 0; i < this.parsedEntries.size(); ++i) {
            StringInt si = this.parsedEntries.get(i);
            if (si.i != 2 && si.i != 3 && si.i != 4 && si.i != 6 && si.i != 7) continue;
            si.s = si.s.trim().toLowerCase();
        }
        Layout layout = new Layout(this.parsedEntries, classPrefix);
        return layout;
    }

    public static String getCurrentGroup() {
        return currentGroup;
    }

    public static void setCurrentGroup(String newGroup) {
        currentGroup = newGroup;
    }

    private String getBracketedField(int _field) throws IOException {
        StringBuffer buffer = null;
        boolean start = false;
        while (!this._eof) {
            int c = this.read();
            if (c == -1) {
                this._eof = true;
                if (buffer != null) {
                    this.parsedEntries.add(new StringInt(buffer.toString(), _field));
                }
                return null;
            }
            if (c == 123 || c == 125) {
                if (c == 125) {
                    if (buffer == null) continue;
                    this.parsedEntries.add(new StringInt(buffer.toString(), _field));
                    return null;
                }
                start = true;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(100);
            }
            if (!start || c == 125) continue;
            buffer.append((char)c);
        }
        return null;
    }

    private String getBracketedOptionField(int _field) throws IOException {
        StringBuffer buffer = null;
        boolean start = false;
        boolean doneWithOptions = false;
        String option = null;
        while (!this._eof) {
            int c = this.read();
            if (c == -1) {
                this._eof = true;
                if (buffer != null) {
                    String tmp = option != null ? buffer.toString() + "\n" + option : buffer.toString();
                    this.parsedEntries.add(new StringInt(tmp, 5));
                }
                return null;
            }
            if (c == 93 || c == 91 || doneWithOptions && (c == 123 || c == 125)) {
                if (c == 93 || doneWithOptions && c == 125) {
                    if (c == 93 && buffer != null) {
                        option = buffer.toString();
                        buffer = null;
                        start = false;
                        doneWithOptions = true;
                        continue;
                    }
                    if (c != 125) continue;
                    String parameter = buffer == null ? " " : buffer.toString();
                    String tmp = option != null ? parameter + "\n" + option : parameter;
                    this.parsedEntries.add(new StringInt(tmp, 5));
                    return null;
                }
                start = true;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(100);
            }
            if (!start) continue;
            buffer.append((char)c);
        }
        return null;
    }

    private Object parse() throws IOException {
        this.skipWhitespace();
        StringBuffer buffer = null;
        boolean escaped = false;
        while (!this._eof) {
            int c = this.read();
            if (c == -1) {
                this._eof = true;
                if (buffer != null) {
                    this.parsedEntries.add(new StringInt(buffer.toString(), 1));
                }
                return null;
            }
            if (c == 92 && this.peek() != 92 && !escaped) {
                if (buffer != null) {
                    this.parsedEntries.add(new StringInt(buffer.toString(), 1));
                    buffer = null;
                }
                this.parseField();
                escaped = false;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(100);
            }
            if (c != 92 || escaped) {
                buffer.append((char)c);
            }
            escaped = c == 92 && !escaped;
        }
        return null;
    }

    private void parseField() throws IOException {
        StringBuffer buffer = null;
        while (!this._eof) {
            int c = this.read();
            if (c == -1) {
                this._eof = true;
            }
            if (!Character.isLetter((char)c)) {
                this.unread(c);
                String name = buffer != null ? buffer.toString() : "";
                buffer = null;
                if (name.charAt(0) == 'b') {
                    if (name.equalsIgnoreCase("begin")) {
                        this.getBracketedField(3);
                        return;
                    }
                    if (name.equalsIgnoreCase("begingroup")) {
                        this.getBracketedField(6);
                        return;
                    }
                } else if (name.charAt(0) == 'f') {
                    if (name.equalsIgnoreCase("format")) {
                        if (c == 91) {
                            this.getBracketedOptionField(5);
                            return;
                        }
                        this.getBracketedField(5);
                        return;
                    }
                } else if (name.charAt(0) == 'e') {
                    if (name.equalsIgnoreCase("end")) {
                        this.getBracketedField(4);
                        return;
                    }
                    if (name.equalsIgnoreCase("endgroup")) {
                        this.getBracketedField(7);
                        return;
                    }
                    if (name.equalsIgnoreCase("encoding")) {
                        this.parsedEntries.add(new StringInt(name, 8));
                        return;
                    }
                }
                this.parsedEntries.add(new StringInt(name, 2));
                return;
            }
            if (buffer == null) {
                buffer = new StringBuffer(100);
            }
            buffer.append((char)c);
        }
    }

    private int peek() throws IOException {
        int c = this.read();
        this.unread(c);
        return c;
    }

    private int read() throws IOException {
        int c = this._in.read();
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    private void skipWhitespace() throws IOException {
        int c;
        do {
            if ((c = this.read()) != -1 && c != 65535) continue;
            this._eof = true;
            return;
        } while (Character.isWhitespace((char)c));
        this.unread(c);
    }

    private void unread(int c) throws IOException {
        if (c == 10) {
            --this.line;
        }
        this._in.unread(c);
    }
}

