/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileDialogs;

class EntryCustomizationDialog
extends JDialog
implements ItemListener {
    BibtexEntryType type;
    JScrollPane reqSP;
    JScrollPane optSP;
    JButton ok;
    JButton cancel;
    JButton helpButton;
    JButton delete;
    JButton importTypes;
    JButton exportTypes;
    JPanel panel = new JPanel();
    JPanel fieldPanel = new JPanel();
    JPanel typePanel = new JPanel();
    int width = 10;
    JLabel messageLabel = new JLabel("", 0);
    JTextField name = new JTextField("", this.width);
    JTextArea req_ta = new JTextArea("", 5, this.width);
    JTextArea opt_ta = new JTextArea("", 5, this.width);
    JComboBox types_cb = new JComboBox();
    HelpAction help;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JPanel buttonPanel = new JPanel();
    JabRefFrame parent;
    EntryCustomizationDialog ths = this;

    public EntryCustomizationDialog(JabRefFrame parent) {
        super(parent, Globals.lang("Customize entry types"), false);
        this.parent = parent;
        this.help = new HelpAction(parent.helpDiag, GUIGlobals.customEntriesHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.setTypeSelection();
        this.initialize();
        this.makeButtons();
        this.reqSP = new JScrollPane(this.req_ta, 20, 31);
        this.optSP = new JScrollPane(this.opt_ta, 20, 31);
        JToolBar tlb = new JToolBar();
        tlb.setFloatable(false);
        tlb.add(this.help);
        this.panel.setLayout(this.gbl);
        this.typePanel.setLayout(this.gbl);
        this.fieldPanel.setLayout(this.gbl);
        this.fieldPanel.setBorder(BorderFactory.createEtchedBorder());
        this.typePanel.setBorder(BorderFactory.createEtchedBorder());
        JLabel lab = new JLabel(Globals.lang("Type") + ": ");
        JLabel lab2 = new JLabel(Globals.lang("Name") + ": ");
        this.con.insets = new Insets(5, 5, 5, 5);
        this.gbl.setConstraints(lab, this.con);
        this.gbl.setConstraints(lab2, this.con);
        this.gbl.setConstraints(this.types_cb, this.con);
        this.con.weightx = 1.0;
        this.con.fill = 2;
        this.gbl.setConstraints(this.name, this.con);
        this.con.fill = 0;
        this.con.gridwidth = 0;
        this.con.weightx = 0.0;
        this.gbl.setConstraints(tlb, this.con);
        this.con.gridwidth = 1;
        this.typePanel.add(lab);
        this.typePanel.add(this.types_cb);
        this.typePanel.add(lab2);
        this.typePanel.add(this.name);
        this.typePanel.add(tlb);
        lab = new JLabel(Globals.lang("Required fields"));
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.gbl.setConstraints(lab, this.con);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.reqSP, this.con);
        this.fieldPanel.add(lab);
        this.con.gridwidth = 0;
        lab = new JLabel(Globals.lang("Optional fields"));
        this.con.weighty = 0.0;
        this.gbl.setConstraints(lab, this.con);
        this.fieldPanel.add(lab);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.optSP, this.con);
        this.fieldPanel.add(this.reqSP);
        this.fieldPanel.add(this.optSP);
        this.con.gridwidth = 0;
        this.con.weighty = 0.0;
        this.gbl.setConstraints(this.typePanel, this.con);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.fieldPanel, this.con);
        this.con.weighty = 0.0;
        this.gbl.setConstraints(this.messageLabel, this.con);
        this.panel.add(this.typePanel);
        this.panel.add(this.fieldPanel);
        this.panel.add(this.messageLabel);
        ActionMap am = this.panel.getActionMap();
        InputMap im = this.panel.getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EntryCustomizationDialog.this.dispose();
            }
        });
        this.pack();
        this.name.requestFocus();
    }

    public EntryCustomizationDialog(JabRefFrame parent, BibtexEntryType type_) {
        this(parent);
        this.type = type_;
    }

    void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.panel, "Center");
        this.messageLabel.setForeground(Color.black);
        this.messageLabel.setText(Globals.lang("Delimit fields with semicolon, ex.") + ": author;title;journal");
        this.types_cb.addItemListener(this);
    }

    void save() {
        String typeName = this.name.getText().trim();
        if (typeName.indexOf(" ") >= 0) {
            JOptionPane.showMessageDialog(this.ths, Globals.lang("The type name can not contain spaces."), Globals.lang("Illegal type name"), 0);
            return;
        }
        String reqStr = this.req_ta.getText().replaceAll("\\s+", "").replaceAll("\\n+", "").trim();
        String optStr = this.opt_ta.getText().replaceAll("\\s+", "").replaceAll("\\n+", "").trim();
        if (!typeName.equals("")) {
            CustomEntryType typ = new CustomEntryType(Util.nCase(typeName), reqStr, optStr);
            BibtexEntryType.ALL_TYPES.put(typeName.toLowerCase(), typ);
            this.updateTypesForEntries(typ.getName());
            this.setTypeSelection();
            this.messageLabel.setText(Globals.lang("Stored definition for type") + " '" + Util.nCase(typ.getName()) + "'.");
        } else {
            this.messageLabel.setText(Globals.lang("You must fill in a name for the entry type."));
        }
    }

    private void setTypeSelection() {
        this.types_cb.removeAllItems();
        this.types_cb.addItem("<new>");
        Iterator<String> i = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (i.hasNext()) {
            BibtexEntryType type = BibtexEntryType.getType(i.next());
            String toSet = Util.nCase(type.getName());
            if (type instanceof CustomEntryType) {
                toSet = toSet + " *";
            }
            this.types_cb.addItem(toSet);
        }
    }

    void makeButtons() {
        this.ok = new JButton(Globals.lang("Store"));
        this.cancel = new JButton(Globals.lang("Close"));
        this.delete = new JButton(Globals.lang("Delete custom"));
        this.importTypes = new JButton(Globals.lang("Import"));
        this.exportTypes = new JButton(Globals.lang("Export"));
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.delete);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.importTypes);
        this.buttonPanel.add(this.exportTypes);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.cancel);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntryCustomizationDialog.this.save();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntryCustomizationDialog.this.dispose();
            }
        });
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BibtexEntryType type = BibtexEntryType.getType(EntryCustomizationDialog.this.name.getText());
                if (type == null) {
                    EntryCustomizationDialog.this.messageLabel.setText(Globals.lang("There is no entry type") + " '" + Util.nCase(EntryCustomizationDialog.this.name.getText()) + "' " + Globals.lang("defined."));
                } else if (!(type instanceof CustomEntryType)) {
                    EntryCustomizationDialog.this.messageLabel.setText("'" + type.getName() + "' " + Globals.lang("is a standard type."));
                } else {
                    int reply;
                    String nm = EntryCustomizationDialog.this.name.getText();
                    if (BibtexEntryType.getStandardType(nm) == null && (reply = JOptionPane.showConfirmDialog(EntryCustomizationDialog.this.parent, Globals.lang("All entries of this type will be declared typeless. Continue?"), Globals.lang("Delete custom format") + " '" + Util.nCase(nm) + "'", 0, 2)) != 0) {
                        return;
                    }
                    BibtexEntryType.removeType(nm);
                    EntryCustomizationDialog.this.setTypeSelection();
                    EntryCustomizationDialog.this.updateTypesForEntries(Util.nCase(nm));
                    EntryCustomizationDialog.this.messageLabel.setText(Globals.lang("Removed entry type."));
                }
            }
        });
        this.exportTypes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String filename = FileDialogs.getNewFile(EntryCustomizationDialog.this.parent, new File(System.getProperty("user.home")), ".txt", 1, false);
                if (filename == null) {
                    return;
                }
                File file = new File(filename);
                if (!file.exists() || JOptionPane.showConfirmDialog(EntryCustomizationDialog.this.ths, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Export entry types"), 2) == 0) {
                    try {
                        FileWriter out = new FileWriter(file);
                        Iterator<String> i = BibtexEntryType.ALL_TYPES.keySet().iterator();
                        while (i.hasNext()) {
                            BibtexEntryType o = BibtexEntryType.ALL_TYPES.get(i.next());
                            if (!(o instanceof CustomEntryType)) continue;
                            ((CustomEntryType)o).save(out);
                        }
                        out.close();
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(EntryCustomizationDialog.this.ths, Globals.lang("Could not export entry types") + ": " + ex.getMessage(), Globals.lang("Export preferences"), 0);
                    }
                }
            }
        });
        this.importTypes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String filename = FileDialogs.getNewFile(EntryCustomizationDialog.this.parent, new File(System.getProperty("user.home")), ".txt", 0, false);
                if (filename == null) {
                    return;
                }
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(new File(filename)));
                    int count = 0;
                    while ((line = in.readLine()) != null) {
                        CustomEntryType type;
                        if ((line = line.trim()).length() > 9 + GUIGlobals.ENTRYTYPE_FLAG.length() && line.substring(0, 9 + GUIGlobals.ENTRYTYPE_FLAG.length()).equals("@comment{" + GUIGlobals.ENTRYTYPE_FLAG) && line.substring(line.length() - 1).equals("}") && (type = CustomEntryType.parseEntryType(line.substring(9, line.length() - 1))) != null) {
                            BibtexEntryType.ALL_TYPES.put(type.getName().toLowerCase(), type);
                            ++count;
                        }
                        if (count <= 0) continue;
                        EntryCustomizationDialog.this.setTypeSelection();
                        EntryCustomizationDialog.this.req_ta.setText("");
                        EntryCustomizationDialog.this.opt_ta.setText("");
                        EntryCustomizationDialog.this.name.setText("");
                        EntryCustomizationDialog.this.messageLabel.setText(Globals.lang("Imported entry types") + ": " + count);
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(EntryCustomizationDialog.this.ths, Globals.lang("Could not import entry types") + ": " + ex.getMessage(), Globals.lang("Import entry types"), 0);
                }
            }
        });
    }

    private void updateTypesForEntries(String typeName) {
        if (this.parent.tabbedPane.getTabCount() == 0) {
            return;
        }
        this.messageLabel.setText(Globals.lang("Updating entries..."));
        for (int i = 0; i < this.parent.tabbedPane.getTabCount(); ++i) {
            BasePanel bp = (BasePanel)this.parent.tabbedPane.getComponentAt(i);
            boolean anyChanges = false;
            bp.entryEditors.remove(typeName);
            BibtexDatabase base = bp.database;
            for (BibtexEntry e : base.getEntries()) {
                anyChanges |= !e.updateType();
            }
            if (!anyChanges) continue;
            bp.markBaseChanged();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.types_cb.getSelectedIndex() > 0) {
            String name = (String)this.types_cb.getSelectedItem();
            this.updateToType(name.split(" ")[0]);
        } else {
            this.name.setText("");
            this.req_ta.setText("");
            this.opt_ta.setText("");
            this.name.requestFocus();
        }
    }

    public void updateToType(String o) {
        BibtexEntryType type = BibtexEntryType.getType(o);
        this.name.setText(type.getName());
        this.req_ta.setText(Util.stringArrayToDelimited(type.getRequiredFields(), ";\n"));
        this.opt_ta.setText(Util.stringArrayToDelimited(type.getOptionalFields(), ";\n"));
        this.req_ta.requestFocus();
    }
}

