/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.StreamPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class SimpleProcess
extends Process {
    private Process process;
    private InputStream processInput;
    private PrintStream yourOutput;
    private PrintStream yourError;
    private StreamPrinter in;
    private StreamPrinter out;
    private StreamPrinter error;

    public SimpleProcess(Process process) throws IOException {
        this(process, System.in, System.out, System.err);
    }

    public SimpleProcess(Process process, InputStream processInput, PrintStream yourOutput, PrintStream yourError) throws IOException {
        this.process = process;
        this.processInput = processInput;
        this.yourOutput = yourOutput;
        this.yourError = yourError;
    }

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    public int waitFor() throws InterruptedException {
        int retval = this.waitForImpl();
        if (this.in != null) {
            this.in.stop();
        }
        return retval;
    }

    private int waitForImpl() throws InterruptedException {
        this.in = new StreamPrinter(this.processInput, new PrintStream(this.process.getOutputStream()));
        this.in.setFlush(true);
        this.out = new StreamPrinter(this.process.getInputStream(), this.yourOutput);
        this.error = new StreamPrinter(this.process.getErrorStream(), this.yourError);
        this.in.start();
        this.out.start();
        this.error.start();
        this.out.join();
        this.error.join();
        return this.process.waitFor();
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public void destroy() throws IllegalThreadStateException {
        this.process.destroy();
    }
}

