/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DynamicGVTBuilder;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.util.EventDispatcher;
import org.apache.batik.util.HaltingThread;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class GVTTreeBuilder
extends HaltingThread {
    protected SVGDocument svgDocument;
    protected BridgeContext bridgeContext;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeBuilderListener)object).gvtBuildStarted((GVTTreeBuilderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeBuilderListener)object).gvtBuildCompleted((GVTTreeBuilderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeBuilderListener)object).gvtBuildCancelled((GVTTreeBuilderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeBuilderListener)object).gvtBuildFailed((GVTTreeBuilderEvent)object2);
        }
    };

    public GVTTreeBuilder(SVGDocument sVGDocument, BridgeContext bridgeContext) {
        this.svgDocument = sVGDocument;
        this.bridgeContext = bridgeContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        GVTTreeBuilderEvent gVTTreeBuilderEvent = new GVTTreeBuilderEvent((Object)this, null);
        try {
            try {
                this.fireEvent(startedDispatcher, gVTTreeBuilderEvent);
                if (this.isHalted()) {
                    this.fireEvent(cancelledDispatcher, gVTTreeBuilderEvent);
                    return;
                }
                Object object = null;
                object = this.bridgeContext.isDynamic() ? new DynamicGVTBuilder() : new GVTBuilder();
                GraphicsNode graphicsNode = object.build(this.bridgeContext, (Document)this.svgDocument);
                if (this.isHalted()) {
                    this.fireEvent(cancelledDispatcher, gVTTreeBuilderEvent);
                    return;
                }
                gVTTreeBuilderEvent = new GVTTreeBuilderEvent((Object)this, graphicsNode);
                this.fireEvent(completedDispatcher, gVTTreeBuilderEvent);
                return;
            }
            catch (InterruptedBridgeException interruptedBridgeException) {
                this.fireEvent(cancelledDispatcher, gVTTreeBuilderEvent);
                return;
            }
            catch (BridgeException bridgeException) {
                this.exception = bridgeException;
                gVTTreeBuilderEvent = new GVTTreeBuilderEvent((Object)this, bridgeException.getGraphicsNode());
                this.fireEvent(failedDispatcher, gVTTreeBuilderEvent);
                return;
            }
            catch (Exception exception) {
                this.exception = exception;
                this.fireEvent(failedDispatcher, gVTTreeBuilderEvent);
                return;
            }
            catch (ThreadDeath threadDeath) {
                this.exception = new Exception(threadDeath.getMessage());
                this.fireEvent(failedDispatcher, gVTTreeBuilderEvent);
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.exception = new Exception(throwable.getMessage());
                this.fireEvent(failedDispatcher, gVTTreeBuilderEvent);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            throw throwable;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.listeners.add(gVTTreeBuilderListener);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.listeners.remove(gVTTreeBuilderListener);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, (List)this.listeners, (Object)object, (boolean)true);
    }
}

