/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.crypt.SecurityHandlerFactory;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV0;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV1;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV2;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV3;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV4;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STStreamXRefSection;

public abstract class SystemSecurityHandler
implements ISystemSecurityHandler {
    public static final int DEFAULT_LENGTH = 40;
    private final COSDictionary cosEncryption;
    private COSArray currentCosIDs;
    private final COSEncryption encryption;
    private COSDictionary currentCosTrailer;
    private COSDictionary currentCosEncryption;
    private ISecurityHandler securityHandler;
    private STDocument stDoc;
    private COSCompositeObject[] contextStack = new COSCompositeObject[5];
    private short stackPtr = (short)-1;
    private boolean enabled = true;

    public static SystemSecurityHandler createFromSt(STDocument doc) throws COSSecurityException {
        SystemSecurityHandler systemSecurityHandler = null;
        COSDictionary dict = doc.cosGetTrailer().get(COSTrailer.DK_Encrypt).asDictionary();
        if (dict != null) {
            int version = 0;
            COSNumber cosVersion = dict.get(COSEncryption.DK_V).asNumber();
            if (cosVersion != null) {
                version = cosVersion.intValue();
            }
            if (version == 0) {
                systemSecurityHandler = new SystemSecurityHandlerV0(dict);
            } else if (version == 1) {
                systemSecurityHandler = new SystemSecurityHandlerV1(dict);
            } else if (version == 2) {
                systemSecurityHandler = new SystemSecurityHandlerV2(dict);
            } else if (version == 3) {
                systemSecurityHandler = new SystemSecurityHandlerV3(dict);
            } else if (version == 4) {
                systemSecurityHandler = new SystemSecurityHandlerV4(dict);
            } else {
                throw new COSSecurityException("unsupported security version " + version);
            }
            systemSecurityHandler.initialize(doc);
        }
        return systemSecurityHandler;
    }

    public static SystemSecurityHandler createNewV1() {
        COSDictionary dict = COSDictionary.create();
        dict.beIndirect();
        SystemSecurityHandlerV1 result = new SystemSecurityHandlerV1(dict);
        result.initializeFromScratch();
        return result;
    }

    public static SystemSecurityHandler createNewV2() {
        COSDictionary dict = COSDictionary.create();
        dict.beIndirect();
        SystemSecurityHandlerV2 result = new SystemSecurityHandlerV2(dict);
        ((SystemSecurityHandler)result).initializeFromScratch();
        return result;
    }

    public static SystemSecurityHandler createNewV4() {
        COSDictionary dict = COSDictionary.create();
        dict.beIndirect();
        SystemSecurityHandlerV4 result = new SystemSecurityHandlerV4(dict);
        ((SystemSecurityHandler)result).initializeFromScratch();
        return result;
    }

    protected SystemSecurityHandler(COSDictionary dict) {
        this.currentCosEncryption = this.cosEncryption = dict;
        this.encryption = (COSEncryption)COSEncryption.META.createFromCos(dict);
    }

    public void attach(STDocument stDoc) throws COSSecurityException {
        this.stDoc = stDoc;
        this.currentCosTrailer = stDoc.cosGetTrailer();
        this.currentCosIDs = this.currentCosTrailer.get(COSTrailer.DK_ID).asArray();
        this.currentCosTrailer.put(COSTrailer.DK_Encrypt, this.cosGetEncryption());
        if (this.getSecurityHandler() != null) {
            this.getSecurityHandler().attach(stDoc);
        }
        this.forceFullWrite();
    }

    public void authenticate() throws COSSecurityException {
        this.securityHandler.authenticate();
    }

    public COSDictionary cosGetEncryption() {
        return this.cosEncryption;
    }

    public void detach(STDocument stDoc) throws COSSecurityException {
        if (this.getSecurityHandler() != null) {
            this.getSecurityHandler().detach(stDoc);
        }
        stDoc.cosGetTrailer().remove(COSTrailer.DK_Encrypt);
        this.forceFullWrite();
    }

    protected void forceFullWrite() {
        if (this.stGetDoc() == null) {
            return;
        }
        this.stGetDoc().setWriteModeHint(EnumWriteMode.FULL);
    }

    public COSCompositeObject getContextObject() {
        if (this.stackPtr < 0) {
            return null;
        }
        return this.contextStack[this.stackPtr];
    }

    public COSEncryption getEncryption() {
        return this.encryption;
    }

    public int getLength() {
        COSEncryption encryption = this.getEncryption();
        return encryption.getFieldInt(COSEncryption.DK_Length, 40);
    }

    public ISecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public abstract int getVersion();

    public void initialize(STDocument doc) throws COSSecurityException {
        this.stDoc = doc;
        this.initializeFromSt();
    }

    protected void initializeFromScratch() {
        COSEncryption encryption = this.getEncryption();
        encryption.cosSetField(COSEncryption.DK_V, COSInteger.create(this.getVersion()));
    }

    protected void initializeFromSt() throws COSSecurityException {
        COSEncryption encryption = this.getEncryption();
        this.securityHandler = SecurityHandlerFactory.get().getSecurityHandler(encryption);
        this.securityHandler.initialize(this.stGetDoc());
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    public COSCompositeObject popContextObject() {
        COSDictionary dict;
        short s = this.stackPtr;
        this.stackPtr = (short)(s - 1);
        COSCompositeObject contextObject = this.contextStack[s];
        if (contextObject == this.currentCosEncryption || contextObject == this.currentCosIDs) {
            this.enabled = true;
        }
        if (contextObject instanceof COSStream && (dict = contextObject.asStream().getDict()) != null && dict.get(STStreamXRefSection.DK_Type).equals(STStreamXRefSection.CN_Type_XRef)) {
            this.enabled = true;
        }
        return contextObject;
    }

    public void pushContextObject(COSCompositeObject contextObject) {
        COSDictionary dict;
        this.stackPtr = (short)(this.stackPtr + 1);
        if (this.stackPtr >= this.contextStack.length) {
            COSCompositeObject[] tempStack = new COSCompositeObject[this.contextStack.length + 5];
            System.arraycopy(this.contextStack, 0, tempStack, 0, this.contextStack.length);
            this.contextStack = tempStack;
        }
        this.contextStack[this.stackPtr] = contextObject;
        if (contextObject == this.currentCosEncryption || contextObject == this.currentCosIDs) {
            this.enabled = false;
        }
        if (contextObject instanceof COSStream && (dict = contextObject.asStream().getDict()) != null && dict.get(STStreamXRefSection.DK_Type).equals(STStreamXRefSection.CN_Type_XRef)) {
            this.enabled = false;
        }
    }

    public void setLength(int length) {
        COSEncryption encryption = this.getEncryption();
        encryption.setFieldInt(COSEncryption.DK_Length, length);
    }

    public void setSecurityHandler(ISecurityHandler pSecurityHandler) throws COSSecurityException {
        if (this.securityHandler != null) {
            this.securityHandler.detach(this.stGetDoc());
        }
        this.securityHandler = pSecurityHandler;
        if (this.securityHandler != null) {
            this.securityHandler.attach(this.stGetDoc());
        }
    }

    public STDocument stGetDoc() {
        return this.stDoc;
    }

    public void updateTrailer(COSDictionary trailer) {
        this.currentCosTrailer = trailer;
        this.currentCosIDs = this.currentCosTrailer.get(COSTrailer.DK_ID).asArray();
        this.currentCosEncryption = trailer.get(COSTrailer.DK_Encrypt).asDictionary();
    }
}

