/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.xml;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.sciplore.resources.Citation;
import org.sciplore.resources.Document;
import org.sciplore.resources.DocumentPerson;
import org.sciplore.resources.Feedback;
import org.sciplore.resources.FulltextUrl;
import org.sciplore.resources.Keyword;
import org.sciplore.resources.Venue;
import org.sciplore.xml.ExternalizedStrings;
import org.sciplore.xml.XmlAbstract;
import org.sciplore.xml.XmlAnnotations;
import org.sciplore.xml.XmlAuthor;
import org.sciplore.xml.XmlAuthors;
import org.sciplore.xml.XmlCitedBy;
import org.sciplore.xml.XmlDoi;
import org.sciplore.xml.XmlFulltext;
import org.sciplore.xml.XmlFulltexts;
import org.sciplore.xml.XmlKeyword;
import org.sciplore.xml.XmlKeywords;
import org.sciplore.xml.XmlNumber;
import org.sciplore.xml.XmlPages;
import org.sciplore.xml.XmlPublishdate;
import org.sciplore.xml.XmlReferences;
import org.sciplore.xml.XmlResource;
import org.sciplore.xml.XmlTitle;
import org.sciplore.xml.XmlVenue;
import org.sciplore.xml.XmlVolume;

@XmlRootElement(name="document")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="document", propOrder={"title", "_abstract", "authors", "keywords", "fulltexts", "references", "citedBy", "doi", "venue", "pages", "volume", "number", "publishdate", "annotations"})
public class XmlDocument {
    @XmlElement(required=true)
    protected XmlTitle title;
    @XmlElement(name="abstract")
    protected XmlAbstract _abstract;
    protected XmlAuthors authors;
    protected XmlKeywords keywords;
    protected XmlFulltexts fulltexts;
    protected XmlReferences references;
    @XmlElement(name="cited_by")
    protected XmlCitedBy citedBy;
    protected XmlDoi doi;
    protected XmlVenue venue;
    protected XmlPages pages;
    protected XmlVolume volume;
    protected XmlNumber number;
    protected XmlPublishdate publishdate;
    protected XmlAnnotations annotations;
    @XmlAttribute(required=true)
    protected String type;
    @XmlAttribute(required=true)
    protected String hash;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="unsignedLong")
    protected long id;
    @XmlAttribute(required=true)
    protected String href;

    public XmlDocument() {
    }

    public XmlDocument(Document document) {
        this.setHref(String.valueOf(ExternalizedStrings.getString("XmlResource.href")) + ExternalizedStrings.getString("XmlDocument.href") + document.getId());
        this.setId(document.getId().intValue());
        this.setHash(document.getHash());
        this.setType(document.getType());
        this.setTitle(document.getTitle());
        this.setAbstract(document.getAbstract());
        this.setAuthors(document.getPersons());
        this.setKeywords(document.getKeywords());
        this.setFulltexts(document.getFulltextUrls());
        this.setReferences(document.getCleanCitations());
        this.setCitedBy(document.getRcvdCitations());
        this.setDoi(document.getDoi());
        this.setVenue(document);
        this.setPages(document.getPages());
        this.setVolume(document.getVolume());
        this.setNumber(document.getNumber());
        this.setPublishdate(document.getPublishedDay(), document.getPublishedMonth(), document.getPublishedYear());
        this.setAnnotations(document.getFeedbacks());
    }

    public XmlDocument(long id) {
        this.setHref(String.valueOf(ExternalizedStrings.getString("XmlResource.href")) + ExternalizedStrings.getString("XmlDocument.href") + id);
        this.setId(id);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public XmlTitle getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = new XmlTitle(this.getHref());
        this.title.setValue(title);
    }

    public XmlAbstract getAbstract() {
        return this._abstract;
    }

    public void setAbstract(String _abstract) {
        this._abstract = new XmlAbstract(this.getHref());
        this._abstract.setId(this.getId());
        this._abstract.setValue(_abstract);
    }

    public XmlAuthors getAuthors() {
        return this.authors;
    }

    public void setAuthors(Set<DocumentPerson> authors) {
        this.authors = new XmlAuthors(this.getHref());
        DocumentPerson[] tempAuthors = new DocumentPerson[authors.size()];
        authors.toArray(tempAuthors);
        if (authors.size() > 1) {
            boolean changed = false;
            block0: do {
                changed = false;
                int i = 0;
                while (i < tempAuthors.length - 1) {
                    if (tempAuthors[i].getRank() > tempAuthors[i + 1].getRank()) {
                        DocumentPerson tempAuthor = tempAuthors[i];
                        tempAuthors[i] = tempAuthors[i + 1];
                        tempAuthors[i + 1] = tempAuthor;
                        changed = true;
                        continue block0;
                    }
                    ++i;
                }
            } while (changed);
        }
        DocumentPerson[] documentPersonArray = tempAuthors;
        int n = tempAuthors.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentPerson author = documentPersonArray[n2];
            XmlAuthor xmlAuthor = new XmlAuthor(author.getPerson().getId().intValue());
            xmlAuthor.setNameComplete(author.getPerson());
            this.authors.getAuthors().add(xmlAuthor);
            ++n2;
        }
    }

    public XmlKeywords getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set<Keyword> keywords) {
        this.keywords = new XmlKeywords(this.getHref());
        for (Keyword keyword : keywords) {
            XmlKeyword xmlKeyword = new XmlKeyword();
            xmlKeyword.setKeywordtype(keyword.getType().shortValue());
            xmlKeyword.setValue(keyword.getKeyword());
            this.keywords.getKeywords().add(xmlKeyword);
        }
    }

    public XmlFulltexts getFulltexts() {
        return this.fulltexts;
    }

    public void setFulltexts(Set<FulltextUrl> fulltexts) {
        this.fulltexts = new XmlFulltexts(this.getHref());
        for (FulltextUrl fulltext : fulltexts) {
            XmlFulltext xmlFulltext = new XmlFulltext(fulltext.getId().intValue());
            xmlFulltext.setLicence(fulltext.getLicence().shortValue());
            xmlFulltext.setValue(fulltext.getUrl());
            this.fulltexts.getFulltexts().add(xmlFulltext);
        }
    }

    public XmlReferences getReferences() {
        return this.references;
    }

    public void setReferences(Set<Citation> references) {
        this.references = new XmlReferences(this.getHref());
        for (Citation reference : references) {
            Document citedDocument = reference.getCitedDocument();
            XmlDocument xmlDocument = new XmlDocument(citedDocument.getId().intValue());
            xmlDocument.setHash(citedDocument.getHash());
            xmlDocument.setType(citedDocument.getType());
            xmlDocument.setTitle(citedDocument.getTitle());
            this.references.getReferences().add(xmlDocument);
        }
    }

    public XmlCitedBy getCitedBy() {
        return this.citedBy;
    }

    public void setCitedBy(Set<Citation> citedBy) {
        this.citedBy = new XmlCitedBy(this.getHref());
        this.citedBy.setCitationcount(citedBy.size());
        for (Citation citation : citedBy) {
            Document citingDocument = citation.getCitingDocument();
            XmlDocument xmlDocument = new XmlDocument(citingDocument.getId().intValue());
            xmlDocument.setHash(citingDocument.getHash());
            xmlDocument.setType(citingDocument.getType());
            xmlDocument.setTitle(citingDocument.getTitle());
            this.citedBy.getCitingDocuments().add(xmlDocument);
        }
    }

    public XmlVenue getVenue() {
        return this.venue;
    }

    public void setVenue(Document document) {
        Venue venue = document.getVenue();
        this.venue = new XmlVenue(this.getHref());
        if (venue != null) {
            this.venue.setId(venue.getId());
            this.venue.setValue(venue.getName());
        } else if (document.getParent() != null) {
            Document parent = document.getParent();
            this.venue.setId(parent.getId());
            this.venue.setValue(parent.getTitle());
        }
    }

    public XmlDoi getDoi() {
        return this.doi;
    }

    public void setDoi(String doi) {
        this.doi = new XmlDoi(this.getHref());
        this.doi.setValue(doi);
    }

    public XmlPages getPages() {
        return this.pages;
    }

    public void setPages(String pages) {
        this.pages = new XmlPages(this.getHref());
        this.pages.setValue(pages);
    }

    public XmlVolume getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = new XmlVolume(this.getHref());
        this.volume.setValue(volume);
    }

    public XmlNumber getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = new XmlNumber(this.getHref());
        this.number.setValue(number);
    }

    public XmlPublishdate getPublishdate() {
        return this.publishdate;
    }

    public void setPublishdate(Short day, String month, Short year) {
        this.publishdate = new XmlPublishdate(this.getHref());
        this.publishdate.setDay("" + day);
        this.publishdate.setYear("" + year);
        this.publishdate.setMonth(month);
    }

    public XmlAnnotations getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Feedback> annotations) {
        this.annotations = new XmlAnnotations(this.getHref());
        this.annotations.add(annotations);
    }

    public String getXML() throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal((Object)this, (Writer)stringWriter);
        return stringWriter.getBuffer().toString();
    }

    public String getXHTML() throws JAXBException, TransformerException {
        InputStream xsltFile = XmlResource.class.getResourceAsStream("document.xsl");
        StreamSource xmlSource = new StreamSource(new StringReader(this.getXML()));
        StreamSource xsltSource = new StreamSource(xsltFile);
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = transFact.newTransformer(xsltSource);
        StringWriter stringwriter = new StringWriter();
        trans.transform(xmlSource, new StreamResult(stringwriter));
        return stringwriter.toString();
    }
}

