/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Alert;
import org.sciplore.resources.Contact;
import org.sciplore.resources.Feedback;
import org.sciplore.resources.Mindmap;
import org.sciplore.resources.Newsletter;
import org.sciplore.resources.Person;
import org.sciplore.resources.Resource;
import org.sciplore.tools.SciploreResponseCode;
import org.sciplore.tools.Tools;

@Entity
@Table(name="users")
public class User
extends Resource {
    public static final short USER_TYPE_ADMIN = 1;
    public static final short USER_TYPE_NORMAL = 2;
    public static final short USER_TYPE_ANONYMOUS = 3;
    public static final short USER_TYPE_EXTERNAL = 4;
    public static final short USER_VALID = 1;
    public static final String USER_DEFAULT_LANG = "en";
    @OneToMany
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Alert> alterts;
    @OneToMany
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Feedback> feedbacks;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(nullable=false)
    private String lang;
    @OneToMany
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Mindmap> mindmaps;
    @OneToMany
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Newsletter> newsletters;
    private String password;
    @OneToOne
    @JoinColumn(name="person_id", nullable=false)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Person person;
    @Column(nullable=false)
    private Date registrationdate;
    private String remark;
    @Column(nullable=false)
    private Short type;
    @Column(nullable=false)
    private String username;
    @Column(nullable=false)
    private Short valid = 1;

    public static String crypt(String password) {
        String pass = "";
        try {
            pass = Tools.convertToSaltedMD5Digest("spl", password);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return pass;
    }

    public User getUser(String username) {
        return (User)this.getSession().createCriteria(User.class).add((Criterion)Restrictions.like((String)"username", (Object)username)).setMaxResults(1).uniqueResult();
    }

    public User getUser(Person person) {
        return (User)this.getSession().createCriteria(User.class).add((Criterion)Restrictions.eq((String)"person", (Object)person)).setMaxResults(1).uniqueResult();
    }

    public User getUserByEmail(String email) {
        Contact contact = new Contact(this.getSession()).getContact(email);
        if (contact != null) {
            return this.getUser(contact.getPerson());
        }
        return null;
    }

    public User getUserByEmailOrUsername(String value) {
        User user = this.getUser(value);
        if (user != null) {
            return user;
        }
        return this.getUserByEmail(value);
    }

    public User sync(User user) {
        return user;
    }

    public User() {
    }

    public User(Session s) {
        this.setSession(s);
    }

    public User(Session s, String username) {
        this.setSession(s);
        this.username = username;
    }

    public User(Session s, String username, String password) {
        this.setSession(s);
        this.username = username;
        this.password = password;
    }

    public boolean checkCredentials(String password) {
        if ((this.password == null || this.password.isEmpty()) && (password == null || password.isEmpty())) {
            return true;
        }
        return this.password.equalsIgnoreCase(User.crypt(password)) || this.password.equalsIgnoreCase(password);
    }

    public int createUserinDB() {
        int userID = 1234;
        return userID;
    }

    public SciploreResponseCode createUser(String username, String password, String retypedPassword, String eMail, String firstName, String middleName, String lastName, int birthYear, boolean generalNewsLetter, boolean searchNewsLetter, boolean splmmNewsLetter, short userType) {
        if (username == null || username.isEmpty()) {
            return new SciploreResponseCode(420, "User can not be null or empty.");
        }
        if (this.getUser(username) != null) {
            return new SciploreResponseCode(421, "User already exists.");
        }
        switch (userType) {
            case 3: {
                return this.createAnonymousUser(username);
            }
            case 4: {
                return this.createAnonymousUser(username, userType);
            }
            case 2: {
                return this.createNormalUser(username, password, retypedPassword, eMail, firstName, middleName, lastName, birthYear, generalNewsLetter, searchNewsLetter, splmmNewsLetter);
            }
        }
        return new SciploreResponseCode(423, "Invalid user type.");
    }

    private SciploreResponseCode createNormalUser(String username, String password, String retypedPassword, String eMail, String firstName, String middleName, String lastName, int birthYear, boolean generalNewsLetter, boolean searchNewsLetter, boolean splmmNewsLetter) {
        if (!Tools.isValidUsername(username)) {
            return new SciploreResponseCode(420, "Username invalid.");
        }
        if (eMail == null || !Tools.isValidEmailAddress(eMail)) {
            return new SciploreResponseCode(430, "Email invalid.");
        }
        if (password == null || password.length() < 6) {
            return new SciploreResponseCode(441, "Password too short");
        }
        if (!password.equals(retypedPassword)) {
            return new SciploreResponseCode(442, "Passwords not identical");
        }
        if (new Contact(this.getSession()).getContact(eMail) != null) {
            return new SciploreResponseCode(431, "Email already exists.");
        }
        Person person = new Person(this.getSession());
        person.setNameFirst(firstName);
        person.setNameMiddle(middleName);
        person.setNameLast(lastName);
        person.setDob(new GregorianCalendar(birthYear, 0, 1).getTime());
        person.save();
        Contact contact = new Contact(this.getSession());
        contact.setUri(eMail);
        contact.setPerson(person);
        contact.setType((short)5);
        contact.save();
        this.setUsername(username);
        this.setPerson(person);
        this.setPassword(password, true);
        this.setType((short)2);
        this.setLang(USER_DEFAULT_LANG);
        this.setRegistrationdate(new GregorianCalendar().getTime());
        this.save();
        Newsletter newsletter = new Newsletter(this.getSession());
        newsletter.setUser(this);
        newsletter.setNewsGeneral(generalNewsLetter);
        newsletter.setNewsSearch(searchNewsLetter);
        newsletter.setNewsSplmm(splmmNewsLetter);
        newsletter.save();
        return new SciploreResponseCode(200, "User created.");
    }

    private SciploreResponseCode createAnonymousUser(String username) {
        Person person = new Person(this.getSession());
        person.setNameFirst(username);
        person.save();
        this.setUsername(username);
        this.setPerson(person);
        this.setPassword(null);
        this.setLang(USER_DEFAULT_LANG);
        this.setRegistrationdate(new GregorianCalendar().getTime());
        this.setType((short)3);
        this.save();
        return new SciploreResponseCode(200, "User created.");
    }

    private SciploreResponseCode createAnonymousUser(String username, Short userType) {
        Person person = new Person(this.getSession());
        person.setNameFirst(username);
        person.save();
        this.setUsername(username);
        this.setPerson(person);
        this.setPassword(null);
        this.setLang(USER_DEFAULT_LANG);
        this.setRegistrationdate(new GregorianCalendar().getTime());
        this.setType(userType);
        this.save();
        return new SciploreResponseCode(200, "User created.");
    }

    public Set<Alert> getAlterts() {
        return this.alterts;
    }

    public Set<Feedback> getFeedbacks() {
        return this.feedbacks;
    }

    public Integer getId() {
        return this.id;
    }

    public String getLang() {
        return this.lang;
    }

    public Set<Mindmap> getMindmaps() {
        return this.mindmaps;
    }

    public Set<Newsletter> getNewsletters() {
        return this.newsletters;
    }

    public String getPassword() {
        return this.password;
    }

    public Person getPerson() {
        return this.person;
    }

    public Date getRegistrationdate() {
        return this.registrationdate;
    }

    public String getRemark() {
        return this.remark;
    }

    public Short getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public Short getValid() {
        return this.valid;
    }

    public boolean isValidUser(String username, String password) {
        boolean isvalid = false;
        return isvalid;
    }

    public void setAlterts(Set<Alert> alterts) {
        this.alterts = alterts;
    }

    public void setFeedbacks(Set<Feedback> feedbacks) {
        this.feedbacks = feedbacks;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setMindmaps(Set<Mindmap> mindmaps) {
        this.mindmaps = mindmaps;
    }

    public void setNewsletters(Set<Newsletter> newsletters) {
        this.newsletters = newsletters;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPassword(String password, Boolean crypt) {
        this.password = crypt != false ? User.crypt(password) : password;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void setRegistrationdate(Date registrationdate) {
        this.registrationdate = registrationdate;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }
}

