/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Application;
import org.sciplore.resources.MindmapNode;
import org.sciplore.resources.Resource;
import org.sciplore.resources.User;
import org.sciplore.tools.SciploreResponseCode;
import org.sciplore.tools.Tools;

@Entity
@Table(name="mindmaps")
public class Mindmap
extends Resource {
    @Column(nullable=false)
    private Boolean allowIR;
    @Column(nullable=false)
    private Boolean backup;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(nullable=false)
    private String mindmapId;
    @Column(name="publishInGallery", nullable=false)
    private Boolean publishInGallery;
    @Column(nullable=false)
    private Date revision;
    @ManyToOne
    @JoinColumn(nullable=false)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private User user;
    @ManyToOne
    @JoinColumn(nullable=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Application application;
    private String mapversion;
    private Integer filesize;
    private String filename;
    @OneToMany(mappedBy="mindmap")
    private Set<MindmapNode> nodes = new HashSet<MindmapNode>();
    @Column(nullable=false)
    private Short parsed;

    public static Mindmap sync(Mindmap m) {
        return m;
    }

    public Mindmap() {
    }

    public Mindmap(Session s) {
        this.setSession(s);
    }

    public Mindmap(Session s, User user, File mindmap) {
    }

    public SciploreResponseCode create(User user, boolean allowIR, boolean backup, String mindmapId, String mindmapName, String mindmapFile) {
        if (user == null) {
            return new SciploreResponseCode(401, "User cannot be null.");
        }
        this.setAllowIR(allowIR);
        this.setBackup(backup);
        this.setUser(user);
        this.setRevision(new GregorianCalendar().getTime());
        this.setMindmapId(mindmapId);
        this.setPublishInGallery(false);
        this.setFilename(mindmapName);
        this.setParsed((short)0);
        try {
            this.setFilesize(Tools.getFileSize(mindmapFile));
        }
        catch (IOException e) {
            System.out.println(Tools.getStackTraceAsString(e));
            return new SciploreResponseCode(500, e.getStackTrace().toString());
        }
        this.save();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd--HH-mm-ss");
        String filename = String.valueOf(this.getMindmapId()) + "_" + format.format(this.getRevision());
        return new SciploreResponseCode(200, filename);
    }

    public void create(User user, boolean allowIR, boolean backup, Date revision, Application app, String mindmapId, String mindmapName, String mindmapFile) {
        if (user == null) {
            return;
        }
        this.setAllowIR(allowIR);
        this.setBackup(backup);
        this.setUser(user);
        this.setRevision(revision);
        this.setMindmapId(mindmapId);
        this.setPublishInGallery(false);
        this.setFilename(mindmapName);
        this.setApplication(app);
        this.setParsed((short)0);
        try {
            this.setFilesize(Tools.getFileSize(mindmapFile));
        }
        catch (IOException e) {
            System.out.println(Tools.getStackTraceAsString(e));
        }
        this.save();
    }

    public Mindmap getMindmap(String mindmapId, Date revision) {
        return (Mindmap)this.getSession().createCriteria(Mindmap.class).add((Criterion)Restrictions.eq((String)"mindmapId", (Object)mindmapId)).add((Criterion)Restrictions.eq((String)"revision", (Object)revision)).setMaxResults(1).uniqueResult();
    }

    public Boolean getAllowIR() {
        return this.allowIR;
    }

    public Boolean getBackup() {
        return this.backup;
    }

    public Integer getId() {
        return this.id;
    }

    public String getMindmapId() {
        return this.mindmapId;
    }

    public Boolean getPublishInGallery() {
        return this.publishInGallery;
    }

    public Date getRevision() {
        return this.revision;
    }

    public User getUser() {
        return this.user;
    }

    public void setAllowIR(Boolean allowIR) {
        this.allowIR = allowIR;
    }

    public void setBackup(Boolean backup) {
        this.backup = backup;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setMindmapId(String mindmapId) {
        this.mindmapId = mindmapId;
    }

    public void setPublishInGallery(Boolean publishInGallery) {
        this.publishInGallery = publishInGallery;
    }

    public void setRevision(Date revision) {
        this.revision = revision;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getMapversion() {
        return this.mapversion;
    }

    public void setMapversion(String mapversion) {
        this.mapversion = mapversion;
    }

    public Integer getFilesize() {
        return this.filesize;
    }

    public void setFilesize(Integer filesize) {
        this.filesize = filesize;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public Set<MindmapNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(Set<MindmapNode> nodes) {
        this.nodes = nodes;
    }

    public int store(File mindmap, User user) {
        int mmid = 123;
        return mmid;
    }

    public void setParsed(Short parsed) {
        this.parsed = parsed;
    }

    public Short getParsed() {
        return this.parsed;
    }
}

